/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.v3;

import com.android.apksig.ApkVerifier;
import com.android.apksig.SigningCertificateLineage;
import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.apk.ApkUtils;
import com.android.apksig.internal.apk.ApkSigningBlockUtils;
import com.android.apksig.internal.apk.ContentDigestAlgorithm;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.apk.SignatureInfo;
import com.android.apksig.internal.util.ByteBufferUtils;
import com.android.apksig.internal.util.GuaranteedEncodedFormX509Certificate;
import com.android.apksig.internal.util.X509CertificateUtils;
import com.android.apksig.util.DataSource;
import com.android.apksig.util.RunnablesExecutor;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;

public abstract class V3SchemeVerifier {
    private static final int APK_SIGNATURE_SCHEME_V3_BLOCK_ID = -262969152;

    private V3SchemeVerifier() {
    }

    public static ApkSigningBlockUtils.Result verify(RunnablesExecutor runnablesExecutor, DataSource dataSource, ApkUtils.ZipSections zipSections, int n, int n2) throws IOException, NoSuchAlgorithmException, ApkSigningBlockUtils.SignatureNotFoundException {
        ApkSigningBlockUtils.Result result = new ApkSigningBlockUtils.Result(3);
        SignatureInfo signatureInfo = ApkSigningBlockUtils.findSignature(dataSource, zipSections, -262969152, result);
        DataSource dataSource2 = dataSource.slice(0L, signatureInfo.apkSigningBlockOffset);
        DataSource dataSource3 = dataSource.slice(signatureInfo.centralDirOffset, signatureInfo.eocdOffset - signatureInfo.centralDirOffset);
        ByteBuffer byteBuffer = signatureInfo.eocd;
        if (n < 28) {
            n = 28;
        }
        V3SchemeVerifier.verify(runnablesExecutor, dataSource2, signatureInfo.signatureBlock, dataSource3, byteBuffer, n, n2, result);
        return result;
    }

    private static void verify(RunnablesExecutor runnablesExecutor, DataSource dataSource, ByteBuffer byteBuffer, DataSource dataSource2, ByteBuffer byteBuffer2, int n, int n2, ApkSigningBlockUtils.Result result) throws IOException, NoSuchAlgorithmException {
        HashSet<ContentDigestAlgorithm> hashSet = new HashSet<ContentDigestAlgorithm>(1);
        V3SchemeVerifier.parseSigners(byteBuffer, hashSet, result);
        if (result.containsErrors()) {
            return;
        }
        ApkSigningBlockUtils.verifyIntegrity(runnablesExecutor, dataSource, dataSource2, byteBuffer2, hashSet, result);
        TreeMap<Integer, ApkSigningBlockUtils.Result.SignerInfo> treeMap = new TreeMap<Integer, ApkSigningBlockUtils.Result.SignerInfo>();
        for (ApkSigningBlockUtils.Result.SignerInfo signerInfo : result.signers) {
            treeMap.put(signerInfo.minSdkVersion, signerInfo);
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        ArrayList<SigningCertificateLineage> arrayList = new ArrayList<SigningCertificateLineage>(result.signers.size());
        for (ApkSigningBlockUtils.Result.SignerInfo signerInfo : treeMap.values()) {
            int n6 = signerInfo.minSdkVersion;
            int n7 = signerInfo.maxSdkVersion;
            if (n3 == 0) {
                n3 = n6;
            } else if (n6 != n4 + 1) {
                result.addError(ApkVerifier.Issue.V3_INCONSISTENT_SDK_VERSIONS, new Object[0]);
                break;
            }
            n4 = n7;
            if (signerInfo.signingCertificateLineage == null) continue;
            int n8 = signerInfo.signingCertificateLineage.size();
            if (n8 < n5) {
                result.addError(ApkVerifier.Issue.V3_INCONSISTENT_LINEAGES, new Object[0]);
                break;
            }
            n5 = n8;
            arrayList.add(signerInfo.signingCertificateLineage);
        }
        if (n3 > n || n4 < n2) {
            result.addError(ApkVerifier.Issue.V3_MISSING_SDK_VERSIONS, n3, n4);
        }
        try {
            result.signingCertificateLineage = SigningCertificateLineage.consolidateLineages(arrayList);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            result.addError(ApkVerifier.Issue.V3_INCONSISTENT_LINEAGES, new Object[0]);
        }
        if (!result.containsErrors()) {
            result.verified = true;
        }
    }

    private static void parseSigners(ByteBuffer byteBuffer, Set<ContentDigestAlgorithm> set, ApkSigningBlockUtils.Result result) throws NoSuchAlgorithmException {
        CertificateFactory certificateFactory;
        ByteBuffer byteBuffer2;
        try {
            byteBuffer2 = ApkSigningBlockUtils.getLengthPrefixedSlice(byteBuffer);
        }
        catch (ApkFormatException apkFormatException) {
            result.addError(ApkVerifier.Issue.V3_SIG_MALFORMED_SIGNERS, new Object[0]);
            return;
        }
        if (!byteBuffer2.hasRemaining()) {
            result.addError(ApkVerifier.Issue.V3_SIG_NO_SIGNERS, new Object[0]);
            return;
        }
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new RuntimeException("Failed to obtain X.509 CertificateFactory", certificateException);
        }
        int n = 0;
        while (byteBuffer2.hasRemaining()) {
            int n2 = n++;
            ApkSigningBlockUtils.Result.SignerInfo signerInfo = new ApkSigningBlockUtils.Result.SignerInfo();
            signerInfo.index = n2;
            result.signers.add(signerInfo);
            try {
                ByteBuffer byteBuffer3 = ApkSigningBlockUtils.getLengthPrefixedSlice(byteBuffer2);
                V3SchemeVerifier.parseSigner(byteBuffer3, certificateFactory, signerInfo, set);
            }
            catch (ApkFormatException | BufferUnderflowException exception) {
                signerInfo.addError(ApkVerifier.Issue.V3_SIG_MALFORMED_SIGNER, new Object[0]);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void parseSigner(ByteBuffer byteBuffer, CertificateFactory certificateFactory, ApkSigningBlockUtils.Result.SignerInfo signerInfo, Set<ContentDigestAlgorithm> set) throws ApkFormatException, NoSuchAlgorithmException {
        Object object;
        int n;
        Object object2;
        Object object3;
        Object object4;
        SignatureAlgorithm signatureAlgorithm;
        Object object5;
        Object object6;
        ByteBuffer byteBuffer2 = ApkSigningBlockUtils.getLengthPrefixedSlice(byteBuffer);
        byte[] byArray = new byte[byteBuffer2.remaining()];
        byteBuffer2.get(byArray);
        byteBuffer2.flip();
        signerInfo.signedData = byArray;
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        signerInfo.minSdkVersion = n2;
        signerInfo.maxSdkVersion = n3;
        if (n2 < 0 || n2 > n3) {
            signerInfo.addError(ApkVerifier.Issue.V3_SIG_INVALID_SDK_VERSIONS, n2, n3);
        }
        ByteBuffer byteBuffer3 = ApkSigningBlockUtils.getLengthPrefixedSlice(byteBuffer);
        byte[] byArray2 = ApkSigningBlockUtils.readLengthPrefixedByteArray(byteBuffer);
        int n4 = 0;
        ArrayList<ApkSigningBlockUtils.SupportedSignature> arrayList = new ArrayList<ApkSigningBlockUtils.SupportedSignature>(1);
        while (byteBuffer3.hasRemaining()) {
            ++n4;
            try {
                object6 = ApkSigningBlockUtils.getLengthPrefixedSlice(byteBuffer3);
                int n5 = ((ByteBuffer)object6).getInt();
                object5 = ApkSigningBlockUtils.readLengthPrefixedByteArray((ByteBuffer)object6);
                signerInfo.signatures.add(new ApkSigningBlockUtils.Result.SignerInfo.Signature(n5, (byte[])object5));
                signatureAlgorithm = SignatureAlgorithm.findById(n5);
                if (signatureAlgorithm == null) {
                    signerInfo.addWarning(ApkVerifier.Issue.V3_SIG_UNKNOWN_SIG_ALGORITHM, n5);
                    continue;
                }
                arrayList.add(new ApkSigningBlockUtils.SupportedSignature(signatureAlgorithm, (byte[])object5));
            }
            catch (ApkFormatException | BufferUnderflowException exception) {
                signerInfo.addError(ApkVerifier.Issue.V3_SIG_MALFORMED_SIGNATURE, n4);
                return;
            }
        }
        if (signerInfo.signatures.isEmpty()) {
            signerInfo.addError(ApkVerifier.Issue.V3_SIG_NO_SIGNATURES, new Object[0]);
            return;
        }
        object6 = null;
        try {
            object6 = ApkSigningBlockUtils.getSignaturesToVerify(arrayList, signerInfo.minSdkVersion, signerInfo.maxSdkVersion);
        }
        catch (ApkSigningBlockUtils.NoSupportedSignaturesException noSupportedSignaturesException) {
            signerInfo.addError(ApkVerifier.Issue.V3_SIG_NO_SUPPORTED_SIGNATURES, new Object[0]);
            return;
        }
        Object object7 = object6.iterator();
        while (object7.hasNext()) {
            object5 = (ApkSigningBlockUtils.SupportedSignature)object7.next();
            signatureAlgorithm = ((ApkSigningBlockUtils.SupportedSignature)object5).algorithm;
            String string = signatureAlgorithm.getJcaSignatureAlgorithmAndParams().getFirst();
            object4 = signatureAlgorithm.getJcaSignatureAlgorithmAndParams().getSecond();
            String string2 = signatureAlgorithm.getJcaKeyAlgorithm();
            try {
                object3 = KeyFactory.getInstance(string2).generatePublic(new X509EncodedKeySpec(byArray2));
            }
            catch (Exception exception) {
                signerInfo.addError(ApkVerifier.Issue.V3_SIG_MALFORMED_PUBLIC_KEY, exception);
                return;
            }
            try {
                object2 = Signature.getInstance(string);
                ((Signature)object2).initVerify((PublicKey)object3);
                if (object4 != null) {
                    ((Signature)object2).setParameter((AlgorithmParameterSpec)object4);
                }
                byteBuffer2.position(0);
                ((Signature)object2).update(byteBuffer2);
                byte[] byArray3 = ((ApkSigningBlockUtils.SupportedSignature)object5).signature;
                if (!((Signature)object2).verify(byArray3)) {
                    signerInfo.addError(ApkVerifier.Issue.V3_SIG_DID_NOT_VERIFY, new Object[]{signatureAlgorithm});
                    return;
                }
                signerInfo.verifiedSignatures.put(signatureAlgorithm, byArray3);
                set.add(signatureAlgorithm.getContentDigestAlgorithm());
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | SignatureException generalSecurityException) {
                signerInfo.addError(ApkVerifier.Issue.V3_SIG_VERIFY_EXCEPTION, new Object[]{signatureAlgorithm, generalSecurityException});
                return;
            }
        }
        byteBuffer2.position(0);
        object7 = ApkSigningBlockUtils.getLengthPrefixedSlice(byteBuffer2);
        object5 = ApkSigningBlockUtils.getLengthPrefixedSlice(byteBuffer2);
        int n6 = byteBuffer2.getInt();
        if (n6 != n2) {
            signerInfo.addError(ApkVerifier.Issue.V3_MIN_SDK_VERSION_MISMATCH_BETWEEN_SIGNER_AND_SIGNED_DATA_RECORD, n2, n6);
        }
        if ((n = byteBuffer2.getInt()) != n3) {
            signerInfo.addError(ApkVerifier.Issue.V3_MAX_SDK_VERSION_MISMATCH_BETWEEN_SIGNER_AND_SIGNED_DATA_RECORD, n3, n);
        }
        object4 = ApkSigningBlockUtils.getLengthPrefixedSlice(byteBuffer2);
        int n7 = -1;
        while (((Buffer)object5).hasRemaining()) {
            ++n7;
            object3 = ApkSigningBlockUtils.readLengthPrefixedByteArray((ByteBuffer)object5);
            try {
                object2 = X509CertificateUtils.generateCertificate((byte[])object3, certificateFactory);
            }
            catch (CertificateException certificateException) {
                signerInfo.addError(ApkVerifier.Issue.V3_SIG_MALFORMED_CERTIFICATE, n7, n7 + 1, certificateException);
                return;
            }
            object2 = new GuaranteedEncodedFormX509Certificate((X509Certificate)object2, (byte[])object3);
            signerInfo.certs.add((X509Certificate)object2);
        }
        if (signerInfo.certs.isEmpty()) {
            signerInfo.addError(ApkVerifier.Issue.V3_SIG_NO_CERTIFICATES, new Object[0]);
            return;
        }
        object3 = signerInfo.certs.get(0);
        object2 = ((Certificate)object3).getPublicKey().getEncoded();
        if (!Arrays.equals(byArray2, (byte[])object2)) {
            signerInfo.addError(ApkVerifier.Issue.V3_SIG_PUBLIC_KEY_MISMATCH_BETWEEN_CERTIFICATE_AND_SIGNATURES_RECORD, ApkSigningBlockUtils.toHex((byte[])object2), ApkSigningBlockUtils.toHex(byArray2));
            return;
        }
        int n8 = 0;
        while (((Buffer)object7).hasRemaining()) {
            ++n8;
            try {
                object = ApkSigningBlockUtils.getLengthPrefixedSlice((ByteBuffer)object7);
                int n9 = ((ByteBuffer)object).getInt();
                byte[] object8 = ApkSigningBlockUtils.readLengthPrefixedByteArray((ByteBuffer)object);
                signerInfo.contentDigests.add(new ApkSigningBlockUtils.Result.SignerInfo.ContentDigest(n9, object8));
            }
            catch (ApkFormatException | BufferUnderflowException exception) {
                signerInfo.addError(ApkVerifier.Issue.V3_SIG_MALFORMED_DIGEST, n8);
                return;
            }
        }
        object = new ArrayList(signerInfo.signatures.size());
        for (ApkSigningBlockUtils.Result.SignerInfo.Signature signature : signerInfo.signatures) {
            object.add(signature.getAlgorithmId());
        }
        ArrayList arrayList2 = new ArrayList(signerInfo.contentDigests.size());
        for (ApkSigningBlockUtils.Result.SignerInfo.ContentDigest contentDigest : signerInfo.contentDigests) {
            arrayList2.add(contentDigest.getSignatureAlgorithmId());
        }
        if (!object.equals(arrayList2)) {
            signerInfo.addError(ApkVerifier.Issue.V3_SIG_SIG_ALG_MISMATCH_BETWEEN_SIGNATURES_AND_DIGESTS_RECORDS, object, arrayList2);
            return;
        }
        boolean bl = false;
        while (((Buffer)object4).hasRemaining()) {
            void var24_41;
            ++var24_41;
            try {
                ByteBuffer byteBuffer4 = ApkSigningBlockUtils.getLengthPrefixedSlice((ByteBuffer)object4);
                int n5 = byteBuffer4.getInt();
                byte[] byArray3 = ByteBufferUtils.toByteArray(byteBuffer4);
                signerInfo.additionalAttributes.add(new ApkSigningBlockUtils.Result.SignerInfo.AdditionalAttribute(n5, byArray3));
                if (n5 == 1000370060) {
                    try {
                        signerInfo.signingCertificateLineage = SigningCertificateLineage.readFromV3AttributeValue(byArray3);
                        SigningCertificateLineage signingCertificateLineage = signerInfo.signingCertificateLineage.getSubLineage(signerInfo.certs.get(0));
                        if (signerInfo.signingCertificateLineage.size() == signingCertificateLineage.size()) continue;
                        signerInfo.addError(ApkVerifier.Issue.V3_SIG_POR_CERT_MISMATCH, new Object[0]);
                    }
                    catch (SecurityException securityException) {
                        signerInfo.addError(ApkVerifier.Issue.V3_SIG_POR_DID_NOT_VERIFY, new Object[0]);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        signerInfo.addError(ApkVerifier.Issue.V3_SIG_POR_CERT_MISMATCH, new Object[0]);
                    }
                    catch (Exception exception) {
                        signerInfo.addError(ApkVerifier.Issue.V3_SIG_MALFORMED_LINEAGE, new Object[0]);
                    }
                    continue;
                }
                signerInfo.addWarning(ApkVerifier.Issue.V3_SIG_UNKNOWN_ADDITIONAL_ATTRIBUTE, n5);
            }
            catch (ApkFormatException | BufferUnderflowException exception) {
                signerInfo.addError(ApkVerifier.Issue.V3_SIG_MALFORMED_ADDITIONAL_ATTRIBUTE, (int)var24_41);
                return;
            }
        }
    }
}

