/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.v1;

import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.internal.apk.v1.DigestAlgorithm;
import com.android.apksig.internal.asn1.Asn1DerEncoder;
import com.android.apksig.internal.asn1.Asn1EncodingException;
import com.android.apksig.internal.asn1.Asn1OpaqueObject;
import com.android.apksig.internal.jar.ManifestWriter;
import com.android.apksig.internal.jar.SignatureFileWriter;
import com.android.apksig.internal.pkcs7.AlgorithmIdentifier;
import com.android.apksig.internal.pkcs7.ContentInfo;
import com.android.apksig.internal.pkcs7.EncapsulatedContentInfo;
import com.android.apksig.internal.pkcs7.IssuerAndSerialNumber;
import com.android.apksig.internal.pkcs7.SignedData;
import com.android.apksig.internal.pkcs7.SignerIdentifier;
import com.android.apksig.internal.pkcs7.SignerInfo;
import com.android.apksig.internal.util.Pair;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.security.auth.x500.X500Principal;

public abstract class V1SchemeSigner {
    public static final String MANIFEST_ENTRY_NAME = "META-INF/MANIFEST.MF";
    private static final Attributes.Name ATTRIBUTE_NAME_CREATED_BY = new Attributes.Name("Created-By");
    private static final String ATTRIBUTE_VALUE_MANIFEST_VERSION = "1.0";
    private static final String ATTRIBUTE_VALUE_SIGNATURE_VERSION = "1.0";
    static final String SF_ATTRIBUTE_NAME_ANDROID_APK_SIGNED_NAME_STR = "X-Android-APK-Signed";
    private static final Attributes.Name SF_ATTRIBUTE_NAME_ANDROID_APK_SIGNED_NAME = new Attributes.Name("X-Android-APK-Signed");
    private static final Asn1OpaqueObject ASN1_DER_NULL = new Asn1OpaqueObject(new byte[]{5, 0});

    private V1SchemeSigner() {
    }

    public static DigestAlgorithm getSuggestedSignatureDigestAlgorithm(PublicKey publicKey, int n) throws InvalidKeyException {
        String string = publicKey.getAlgorithm();
        if ("RSA".equalsIgnoreCase(string)) {
            if (n < 18) {
                return DigestAlgorithm.SHA1;
            }
            return DigestAlgorithm.SHA256;
        }
        if ("DSA".equalsIgnoreCase(string)) {
            if (n < 21) {
                return DigestAlgorithm.SHA1;
            }
            return DigestAlgorithm.SHA256;
        }
        if ("EC".equalsIgnoreCase(string)) {
            if (n < 18) {
                throw new InvalidKeyException("ECDSA signatures only supported for minSdkVersion 18 and higher");
            }
            return DigestAlgorithm.SHA256;
        }
        throw new InvalidKeyException("Unsupported key algorithm: " + string);
    }

    public static String getSafeSignerName(String string) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Empty name");
        }
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = string.toUpperCase(Locale.US).toCharArray();
        for (int i = 0; i < Math.min(cArray.length, 8); ++i) {
            char c = cArray[i];
            if (c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_') {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append('_');
        }
        return stringBuilder.toString();
    }

    private static MessageDigest getMessageDigestInstance(DigestAlgorithm digestAlgorithm) throws NoSuchAlgorithmException {
        String string = digestAlgorithm.getJcaMessageDigestAlgorithm();
        return MessageDigest.getInstance(string);
    }

    public static String getJcaMessageDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        return digestAlgorithm.getJcaMessageDigestAlgorithm();
    }

    public static boolean isJarEntryDigestNeededInManifest(String string) {
        if (string.endsWith("/")) {
            return false;
        }
        if (!string.startsWith("META-INF/")) {
            return true;
        }
        if (string.indexOf(47, "META-INF/".length()) != -1) {
            return true;
        }
        String string2 = string.substring("META-INF/".length()).toLowerCase(Locale.US);
        return !"manifest.mf".equals(string2) && !string2.endsWith(".sf") && !string2.endsWith(".rsa") && !string2.endsWith(".dsa") && !string2.endsWith(".ec") && !string2.startsWith("sig-");
    }

    public static List<Pair<String, byte[]>> sign(List<SignerConfig> list, DigestAlgorithm digestAlgorithm, Map<String, byte[]> map, List<Integer> list2, byte[] byArray, String string) throws NoSuchAlgorithmException, ApkFormatException, InvalidKeyException, CertificateException, SignatureException {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("At least one signer config must be provided");
        }
        OutputManifestFile outputManifestFile = V1SchemeSigner.generateManifestFile(digestAlgorithm, map, byArray);
        return V1SchemeSigner.signManifest(list, digestAlgorithm, list2, string, outputManifestFile);
    }

    public static List<Pair<String, byte[]>> signManifest(List<SignerConfig> list, DigestAlgorithm digestAlgorithm, List<Integer> list2, String string, OutputManifestFile outputManifestFile) throws NoSuchAlgorithmException, InvalidKeyException, CertificateException, SignatureException {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("At least one signer config must be provided");
        }
        ArrayList<Pair<String, byte[]>> arrayList = new ArrayList<Pair<String, byte[]>>(2 * list.size() + 1);
        byte[] byArray = V1SchemeSigner.generateSignatureFile(list2, digestAlgorithm, string, outputManifestFile);
        for (SignerConfig signerConfig : list) {
            byte[] byArray2;
            String string2 = signerConfig.name;
            try {
                byArray2 = V1SchemeSigner.generateSignatureBlock(signerConfig, byArray);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new InvalidKeyException("Failed to sign using signer \"" + string2 + "\"", invalidKeyException);
            }
            catch (CertificateException certificateException) {
                throw new CertificateException("Failed to sign using signer \"" + string2 + "\"", certificateException);
            }
            catch (SignatureException signatureException) {
                throw new SignatureException("Failed to sign using signer \"" + string2 + "\"", signatureException);
            }
            arrayList.add(Pair.of("META-INF/" + string2 + ".SF", byArray));
            PublicKey publicKey = signerConfig.certificates.get(0).getPublicKey();
            String string3 = "META-INF/" + string2 + "." + publicKey.getAlgorithm().toUpperCase(Locale.US);
            arrayList.add(Pair.of(string3, byArray2));
        }
        arrayList.add(Pair.of(MANIFEST_ENTRY_NAME, outputManifestFile.contents));
        return arrayList;
    }

    public static Set<String> getOutputEntryNames(List<SignerConfig> list) {
        HashSet<String> hashSet = new HashSet<String>(2 * list.size() + 1);
        for (SignerConfig signerConfig : list) {
            String string = signerConfig.name;
            hashSet.add("META-INF/" + string + ".SF");
            PublicKey publicKey = signerConfig.certificates.get(0).getPublicKey();
            String string2 = "META-INF/" + string + "." + publicKey.getAlgorithm().toUpperCase(Locale.US);
            hashSet.add(string2);
        }
        hashSet.add(MANIFEST_ENTRY_NAME);
        return hashSet;
    }

    public static OutputManifestFile generateManifestFile(DigestAlgorithm digestAlgorithm, Map<String, byte[]> map, byte[] byArray) throws ApkFormatException {
        Manifest manifest = null;
        if (byArray != null) {
            try {
                manifest = new Manifest(new ByteArrayInputStream(byArray));
            }
            catch (IOException iOException) {
                throw new ApkFormatException("Malformed source META-INF/MANIFEST.MF", iOException);
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Attributes attributes = new Attributes();
        if (manifest != null) {
            attributes.putAll((Map<?, ?>)manifest.getMainAttributes());
        } else {
            attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        }
        try {
            ManifestWriter.writeMainSection(byteArrayOutputStream, attributes);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to write in-memory MANIFEST.MF", iOException);
        }
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        Collections.sort(arrayList);
        TreeMap<String, byte[]> treeMap = new TreeMap<String, byte[]>();
        String string = V1SchemeSigner.getEntryDigestAttributeName(digestAlgorithm);
        for (String string2 : arrayList) {
            byte[] byArray2;
            V1SchemeSigner.checkEntryNameValid(string2);
            byte[] byArray3 = map.get(string2);
            Attributes attributes2 = new Attributes();
            attributes2.putValue(string, Base64.getEncoder().encodeToString(byArray3));
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            try {
                ManifestWriter.writeIndividualSection(byteArrayOutputStream2, string2, attributes2);
                byArray2 = byteArrayOutputStream2.toByteArray();
                byteArrayOutputStream.write(byArray2);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Failed to write in-memory MANIFEST.MF", iOException);
            }
            treeMap.put(string2, byArray2);
        }
        OutputManifestFile outputManifestFile = new OutputManifestFile();
        outputManifestFile.contents = byteArrayOutputStream.toByteArray();
        outputManifestFile.mainSectionAttributes = attributes;
        outputManifestFile.individualSectionsContents = treeMap;
        return outputManifestFile;
    }

    private static void checkEntryNameValid(String string) throws ApkFormatException {
        for (char c : string.toCharArray()) {
            if (c != '\r' && c != '\n' && c != '\u0000') continue;
            throw new ApkFormatException(String.format("Unsupported character 0x%1$02x in ZIP entry name \"%2$s\"", c, string));
        }
    }

    private static byte[] generateSignatureFile(List<Integer> list, DigestAlgorithm digestAlgorithm, String string, OutputManifestFile outputManifestFile) throws NoSuchAlgorithmException {
        Object object;
        Object object2;
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.SIGNATURE_VERSION, "1.0");
        attributes.put(ATTRIBUTE_NAME_CREATED_BY, string);
        if (!list.isEmpty()) {
            object2 = new StringBuilder();
            object = list.iterator();
            while (object.hasNext()) {
                int n = object.next();
                if (((StringBuilder)object2).length() > 0) {
                    ((StringBuilder)object2).append(", ");
                }
                ((StringBuilder)object2).append(String.valueOf(n));
            }
            attributes.put(SF_ATTRIBUTE_NAME_ANDROID_APK_SIGNED_NAME, ((StringBuilder)object2).toString());
        }
        object2 = V1SchemeSigner.getMessageDigestInstance(digestAlgorithm);
        attributes.putValue(V1SchemeSigner.getManifestDigestAttributeName(digestAlgorithm), Base64.getEncoder().encodeToString(((MessageDigest)object2).digest(outputManifestFile.contents)));
        object = new ByteArrayOutputStream();
        try {
            SignatureFileWriter.writeMainSection((OutputStream)object, attributes);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to write in-memory .SF file", iOException);
        }
        String string2 = V1SchemeSigner.getEntryDigestAttributeName(digestAlgorithm);
        for (Map.Entry<String, byte[]> entry : outputManifestFile.individualSectionsContents.entrySet()) {
            String string3 = entry.getKey();
            byte[] byArray = entry.getValue();
            byte[] byArray2 = ((MessageDigest)object2).digest(byArray);
            Attributes attributes2 = new Attributes();
            attributes2.putValue(string2, Base64.getEncoder().encodeToString(byArray2));
            try {
                SignatureFileWriter.writeIndividualSection((OutputStream)object, string3, attributes2);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Failed to write in-memory .SF file", iOException);
            }
        }
        if (((ByteArrayOutputStream)object).size() > 0 && ((ByteArrayOutputStream)object).size() % 1024 == 0) {
            try {
                SignatureFileWriter.writeSectionDelimiter((OutputStream)object);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Failed to write to ByteArrayOutputStream", iOException);
            }
        }
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    private static byte[] generateSignatureBlock(SignerConfig signerConfig, byte[] byArray) throws NoSuchAlgorithmException, InvalidKeyException, CertificateException, SignatureException {
        byte[] byArray2;
        Object object;
        List<X509Certificate> list = signerConfig.certificates;
        X509Certificate x509Certificate = list.get(0);
        PublicKey publicKey = x509Certificate.getPublicKey();
        DigestAlgorithm digestAlgorithm = signerConfig.signatureDigestAlgorithm;
        Pair<String, AlgorithmIdentifier> pair = V1SchemeSigner.getSignerInfoSignatureAlgorithm(publicKey, digestAlgorithm);
        String string = pair.getFirst();
        try {
            object = Signature.getInstance(string);
            ((Signature)object).initSign(signerConfig.privateKey);
            ((Signature)object).update(byArray);
            byArray2 = ((Signature)object).sign();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeyException("Failed to sign using " + string, invalidKeyException);
        }
        catch (SignatureException signatureException) {
            throw new SignatureException("Failed to sign using " + string, signatureException);
        }
        try {
            object = Signature.getInstance(string);
            ((Signature)object).initVerify(publicKey);
            ((Signature)object).update(byArray);
            if (!((Signature)object).verify(byArray2)) {
                throw new SignatureException("Signature did not verify");
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeyException("Failed to verify generated " + string + " signature using public key from certificate", invalidKeyException);
        }
        catch (SignatureException signatureException) {
            throw new SignatureException("Failed to verify generated " + string + " signature using public key from certificate", signatureException);
        }
        try {
            object = new SignerInfo();
            ((SignerInfo)object).version = 1;
            X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
            ((SignerInfo)object).sid = new SignerIdentifier(new IssuerAndSerialNumber(new Asn1OpaqueObject(x500Principal.getEncoded()), x509Certificate.getSerialNumber()));
            AlgorithmIdentifier algorithmIdentifier = V1SchemeSigner.getSignerInfoDigestAlgorithmOid(digestAlgorithm);
            AlgorithmIdentifier algorithmIdentifier2 = pair.getSecond();
            ((SignerInfo)object).digestAlgorithm = algorithmIdentifier;
            ((SignerInfo)object).signatureAlgorithm = algorithmIdentifier2;
            ((SignerInfo)object).signature = ByteBuffer.wrap(byArray2);
            SignedData signedData = new SignedData();
            signedData.certificates = new ArrayList<Asn1OpaqueObject>(list.size());
            for (X509Certificate x509Certificate2 : list) {
                signedData.certificates.add(new Asn1OpaqueObject(x509Certificate2.getEncoded()));
            }
            signedData.version = 1;
            signedData.digestAlgorithms = Collections.singletonList(algorithmIdentifier);
            signedData.encapContentInfo = new EncapsulatedContentInfo("1.2.840.113549.1.7.1");
            signedData.signerInfos = Collections.singletonList(object);
            ContentInfo contentInfo = new ContentInfo();
            contentInfo.contentType = "1.2.840.113549.1.7.2";
            contentInfo.content = new Asn1OpaqueObject(Asn1DerEncoder.encode(signedData));
            return Asn1DerEncoder.encode(contentInfo);
        }
        catch (Asn1EncodingException asn1EncodingException) {
            throw new SignatureException("Failed to encode signature block", asn1EncodingException);
        }
    }

    private static AlgorithmIdentifier getSignerInfoDigestAlgorithmOid(DigestAlgorithm digestAlgorithm) {
        switch (digestAlgorithm) {
            case SHA1: {
                return new AlgorithmIdentifier("1.3.14.3.2.26", ASN1_DER_NULL);
            }
            case SHA256: {
                return new AlgorithmIdentifier("2.16.840.1.101.3.4.2.1", ASN1_DER_NULL);
            }
        }
        throw new RuntimeException("Unsupported digest algorithm: " + (Object)((Object)digestAlgorithm));
    }

    private static Pair<String, AlgorithmIdentifier> getSignerInfoSignatureAlgorithm(PublicKey publicKey, DigestAlgorithm digestAlgorithm) throws InvalidKeyException {
        String string;
        String string2 = publicKey.getAlgorithm();
        switch (digestAlgorithm) {
            case SHA1: {
                string = "SHA1";
                break;
            }
            case SHA256: {
                string = "SHA256";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected digest algorithm: " + (Object)((Object)digestAlgorithm));
            }
        }
        if ("RSA".equalsIgnoreCase(string2)) {
            return Pair.of(string + "withRSA", new AlgorithmIdentifier("1.2.840.113549.1.1.1", ASN1_DER_NULL));
        }
        if ("DSA".equalsIgnoreCase(string2)) {
            AlgorithmIdentifier algorithmIdentifier;
            switch (digestAlgorithm) {
                case SHA1: {
                    algorithmIdentifier = new AlgorithmIdentifier("1.2.840.10040.4.1", ASN1_DER_NULL);
                    break;
                }
                case SHA256: {
                    algorithmIdentifier = new AlgorithmIdentifier("2.16.840.1.101.3.4.3.2", ASN1_DER_NULL);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected digest algorithm: " + (Object)((Object)digestAlgorithm));
                }
            }
            return Pair.of(string + "withDSA", algorithmIdentifier);
        }
        if ("EC".equalsIgnoreCase(string2)) {
            return Pair.of(string + "withECDSA", new AlgorithmIdentifier("1.2.840.10045.2.1", ASN1_DER_NULL));
        }
        throw new InvalidKeyException("Unsupported key algorithm: " + string2);
    }

    private static String getEntryDigestAttributeName(DigestAlgorithm digestAlgorithm) {
        switch (digestAlgorithm) {
            case SHA1: {
                return "SHA1-Digest";
            }
            case SHA256: {
                return "SHA-256-Digest";
            }
        }
        throw new IllegalArgumentException("Unexpected content digest algorithm: " + (Object)((Object)digestAlgorithm));
    }

    private static String getManifestDigestAttributeName(DigestAlgorithm digestAlgorithm) {
        switch (digestAlgorithm) {
            case SHA1: {
                return "SHA1-Digest-Manifest";
            }
            case SHA256: {
                return "SHA-256-Digest-Manifest";
            }
        }
        throw new IllegalArgumentException("Unexpected content digest algorithm: " + (Object)((Object)digestAlgorithm));
    }

    public static class OutputManifestFile {
        public byte[] contents;
        public SortedMap<String, byte[]> individualSectionsContents;
        public Attributes mainSectionAttributes;
    }

    public static class SignerConfig {
        public String name;
        public PrivateKey privateKey;
        public List<X509Certificate> certificates;
        public DigestAlgorithm signatureDigestAlgorithm;
    }
}

