/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public final class Hints {
    public static final String PIN_HINT_ASSET_ZIP_ENTRY_NAME = "assets/com.android.hints.pins.txt";
    public static final String PIN_BYTE_RANGE_ZIP_ENTRY_NAME = "pinlist.meta";

    private static int clampToInt(long l) {
        return (int)Math.max(0L, Math.min(l, Integer.MAX_VALUE));
    }

    public static byte[] encodeByteRangeList(List<ByteRange> list) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(list.size() * 8);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            for (ByteRange byteRange : list) {
                dataOutputStream.writeInt(Hints.clampToInt(byteRange.start));
                dataOutputStream.writeInt(Hints.clampToInt(byteRange.end - byteRange.start));
            }
        }
        catch (IOException iOException) {
            throw new AssertionError("impossible", iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static ArrayList<Pattern> parsePinPatterns(byte[] byArray) {
        ArrayList<Pattern> arrayList = new ArrayList<Pattern>();
        try {
            for (String string : new String(byArray, "UTF-8").split("\n")) {
                String string2 = string.replaceFirst("#.*", "");
                if ("".equals(string2)) continue;
                arrayList.add(Pattern.compile(string2));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 must be supported", unsupportedEncodingException);
        }
        return arrayList;
    }

    public static final class ByteRange {
        final long start;
        final long end;

        public ByteRange(long l, long l2) {
            this.start = l;
            this.end = l2;
        }
    }
}

