/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig;

import com.android.apksig.ApkSigner;
import com.android.apksig.SigningCertificateLineage;
import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.apk.ApkUtils;
import com.android.apksig.internal.apk.AndroidBinXmlParser;
import com.android.apksig.internal.apk.ApkSigningBlockUtils;
import com.android.apksig.internal.apk.v1.V1SchemeVerifier;
import com.android.apksig.internal.apk.v2.V2SchemeVerifier;
import com.android.apksig.internal.apk.v3.V3SchemeVerifier;
import com.android.apksig.internal.zip.CentralDirectoryRecord;
import com.android.apksig.util.DataSource;
import com.android.apksig.util.DataSources;
import com.android.apksig.util.RunnablesExecutor;
import com.android.apksig.zip.ZipFormatException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ApkVerifier {
    private static final Map<Integer, String> SUPPORTED_APK_SIG_SCHEME_NAMES = ApkVerifier.loadSupportedApkSigSchemeNames();
    private final File mApkFile;
    private final DataSource mApkDataSource;
    private final Integer mMinSdkVersion;
    private final int mMaxSdkVersion;
    private static final int TARGET_SANDBOX_VERSION_ATTR_ID = 16844108;

    private static Map<Integer, String> loadSupportedApkSigSchemeNames() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>(2);
        hashMap.put(2, "APK Signature Scheme v2");
        hashMap.put(3, "APK Signature Scheme v3");
        return hashMap;
    }

    private ApkVerifier(File file, DataSource dataSource, Integer n, int n2) {
        this.mApkFile = file;
        this.mApkDataSource = dataSource;
        this.mMinSdkVersion = n;
        this.mMaxSdkVersion = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result verify() throws IOException, ApkFormatException, NoSuchAlgorithmException, IllegalStateException {
        try (Object object = null;){
            Object object2;
            DataSource dataSource;
            if (this.mApkDataSource != null) {
                dataSource = this.mApkDataSource;
            } else if (this.mApkFile != null) {
                object = object2 = new RandomAccessFile(this.mApkFile, "r");
                dataSource = DataSources.asDataSource((RandomAccessFile)object2, 0L, ((RandomAccessFile)object2).length());
            } else {
                throw new IllegalStateException("APK not provided");
            }
            object2 = this.verify(dataSource);
            return object2;
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private Result verify(DataSource var1_1) throws IOException, ApkFormatException, NoSuchAlgorithmException {
        if (this.mMinSdkVersion != null) {
            if (this.mMinSdkVersion < 0) {
                throw new IllegalArgumentException("minSdkVersion must not be negative: " + this.mMinSdkVersion);
            }
            if (this.mMinSdkVersion != null && this.mMinSdkVersion > this.mMaxSdkVersion) {
                throw new IllegalArgumentException("minSdkVersion (" + this.mMinSdkVersion + ") > maxSdkVersion (" + this.mMaxSdkVersion + ")");
            }
        }
        var2_2 = this.mMaxSdkVersion;
        try {
            var3_3 = ApkUtils.findZipSections(var1_1);
        }
        catch (ZipFormatException var4_4) {
            throw new ApkFormatException("Malformed APK: not a ZIP archive", var4_4);
        }
        var4_5 = null;
        if (this.mMinSdkVersion != null) {
            var5_6 = this.mMinSdkVersion;
        } else {
            if (var4_5 == null) {
                var4_5 = ApkVerifier.getAndroidManifestFromApk(var1_1, var3_3);
            }
            if ((var5_6 = ApkUtils.getMinSdkVersionFromBinaryAndroidManifest(var4_5.slice())) > this.mMaxSdkVersion) {
                throw new IllegalArgumentException("minSdkVersion from APK (" + var5_6 + ") > maxSdkVersion (" + this.mMaxSdkVersion + ")");
            }
        }
        var6_7 = new Result();
        if (var2_2 >= 28) {
            var7_8 = ApkVerifier.SUPPORTED_APK_SIG_SCHEME_NAMES;
        } else if (var2_2 >= 24) {
            var7_8 = new HashMap<Integer, String>(1);
            var7_8.put(2, ApkVerifier.SUPPORTED_APK_SIG_SCHEME_NAMES.get(2));
        } else {
            var7_8 = Collections.EMPTY_MAP;
        }
        var8_9 = new HashSet<Integer>(2);
        if (var2_2 >= 24) {
            var9_10 = RunnablesExecutor.SINGLE_THREADED;
            if (var2_2 >= 28) {
                try {
                    var10_12 = V3SchemeVerifier.verify((RunnablesExecutor)var9_10, var1_1, var3_3, Math.max(var5_6, 28), var2_2);
                    var8_9.add(3);
                    Result.access$000(var6_7, (ApkSigningBlockUtils.Result)var10_12);
                }
                catch (ApkSigningBlockUtils.SignatureNotFoundException var10_13) {
                    // empty catch block
                }
                if (var6_7.containsErrors()) {
                    return var6_7;
                }
            }
            if (var5_6 < 28 || var8_9.isEmpty()) {
                try {
                    var10_12 = V2SchemeVerifier.verify((RunnablesExecutor)var9_10, var1_1, var3_3, var7_8, var8_9, Math.max(var5_6, 24), var2_2);
                    var8_9.add(2);
                    Result.access$000(var6_7, (ApkSigningBlockUtils.Result)var10_12);
                }
                catch (ApkSigningBlockUtils.SignatureNotFoundException var10_14) {
                    // empty catch block
                }
                if (var6_7.containsErrors()) {
                    return var6_7;
                }
            }
        }
        if (var2_2 >= 26) {
            if (var4_5 == null) {
                var4_5 = ApkVerifier.getAndroidManifestFromApk(var1_1, var3_3);
            }
            if ((var9_11 = ApkVerifier.getTargetSandboxVersionFromBinaryAndroidManifest(var4_5.slice())) > 1 && var8_9.isEmpty()) {
                var6_7.addError(Issue.NO_SIG_FOR_TARGET_SANDBOX_VERSION, new Object[]{var9_11});
            }
        }
        if (var5_6 < 24 || var8_9.isEmpty()) {
            var9_10 = V1SchemeVerifier.verify(var1_1, var3_3, var7_8, var8_9, var5_6, var2_2);
            Result.access$100(var6_7, (V1SchemeVerifier.Result)var9_10);
        }
        if (var6_7.containsErrors()) {
            return var6_7;
        }
        if (var6_7.isVerifiedUsingV1Scheme() && var6_7.isVerifiedUsingV2Scheme()) {
            var9_10 = new ArrayList<Result.V1SchemeSignerInfo>(var6_7.getV1SchemeSigners());
            var10_12 = new ArrayList<Result.V2SchemeSignerInfo>(var6_7.getV2SchemeSigners());
            var11_15 = new ArrayList<E>();
            var12_17 = new ArrayList<ByteArray>();
            var13_19 = var9_10.iterator();
            while (var13_19.hasNext()) {
                var14_21 = (Result.V1SchemeSignerInfo)var13_19.next();
                try {
                    var11_15.add(new ByteArray(var14_21.getCertificate().getEncoded()));
                }
                catch (CertificateEncodingException var15_22) {
                    throw new RuntimeException("Failed to encode JAR signer " + var14_21.getName() + " certs", var15_22);
                }
            }
            var13_19 = var10_12.iterator();
            while (var13_19.hasNext()) {
                var14_21 = (Result.V2SchemeSignerInfo)var13_19.next();
                try {
                    var12_17.add(new ByteArray(var14_21.getCertificate().getEncoded()));
                }
                catch (CertificateEncodingException var15_23) {
                    throw new RuntimeException("Failed to encode APK Signature Scheme v2 signer (index: " + var14_21.getIndex() + ") certs", var15_23);
                }
            }
            for (var13_20 = 0; var13_20 < var11_15.size(); ++var13_20) {
                var14_21 = (ByteArray)var11_15.get(var13_20);
                if (var12_17.contains(var14_21)) continue;
                var15_24 = (Result.V1SchemeSignerInfo)var9_10.get(var13_20);
                Result.V1SchemeSignerInfo.access$300((Result.V1SchemeSignerInfo)var15_24, Issue.V2_SIG_MISSING, new Object[0]);
                break;
            }
            for (var13_20 = 0; var13_20 < var12_17.size(); ++var13_20) {
                var14_21 = (ByteArray)var12_17.get(var13_20);
                if (var11_15.contains(var14_21)) continue;
                var15_24 = (Result.V2SchemeSignerInfo)var10_12.get(var13_20);
                Result.V2SchemeSignerInfo.access$400((Result.V2SchemeSignerInfo)var15_24, Issue.JAR_SIG_MISSING, new Object[0]);
                break;
            }
        }
        if (var6_7.isVerifiedUsingV3Scheme() && (var6_7.isVerifiedUsingV1Scheme() || var6_7.isVerifiedUsingV2Scheme())) {
            var9_10 = var6_7.getSigningCertificateLineage();
            if (var6_7.isVerifiedUsingV1Scheme()) {
                var11_15 = var6_7.getV1SchemeSigners();
                if (var11_15.size() != 1) {
                    var6_7.addError(Issue.V3_SIG_MULTIPLE_PAST_SIGNERS, new Object[0]);
                }
                var10_12 = (X509Certificate)Result.V1SchemeSignerInfo.access$500((Result.V1SchemeSignerInfo)var11_15.get(0)).get(0);
            } else {
                var11_15 = var6_7.getV2SchemeSigners();
                if (var11_15.size() != 1) {
                    var6_7.addError(Issue.V3_SIG_MULTIPLE_PAST_SIGNERS, new Object[0]);
                }
                var10_12 = (X509Certificate)Result.V2SchemeSignerInfo.access$600((Result.V2SchemeSignerInfo)var11_15.get(0)).get(0);
            }
            if (var9_10 == null) {
                var11_15 = var6_7.getV3SchemeSigners();
                if (var11_15.size() != 1) {
                    var6_7.addError(Issue.V3_SIG_MULTIPLE_SIGNERS, new Object[0]);
                }
                try {
                    if (Arrays.equals(var10_12.getEncoded(), ((X509Certificate)Result.V3SchemeSignerInfo.access$700((Result.V3SchemeSignerInfo)var11_15.get(0)).get(0)).getEncoded())) ** GOTO lbl129
                    var6_7.addError(Issue.V3_SIG_PAST_SIGNERS_MISMATCH, new Object[0]);
                }
                catch (CertificateEncodingException var12_18) {
                    throw new RuntimeException("Failed to encode APK Signature Scheme v3 signer cert", var12_18);
                }
            } else {
                try {
                    var9_10 = var9_10.getSubLineage((X509Certificate)var10_12);
                    if (var9_10.size() != 1) {
                        var6_7.addError(Issue.V3_SIG_PAST_SIGNERS_MISMATCH, new Object[0]);
                    }
                }
                catch (IllegalArgumentException var11_16) {
                    var6_7.addError(Issue.V3_SIG_PAST_SIGNERS_MISMATCH, new Object[0]);
                }
            }
        }
lbl129:
        // 6 sources

        if (var6_7.containsErrors()) {
            return var6_7;
        }
        Result.access$800(var6_7);
        if (var6_7.isVerifiedUsingV3Scheme()) {
            var9_10 = var6_7.getV3SchemeSigners();
            Result.access$900(var6_7, var9_10.get(var9_10.size() - 1).getCertificate());
        } else if (var6_7.isVerifiedUsingV2Scheme()) {
            for (Object var10_12 : var6_7.getV2SchemeSigners()) {
                Result.access$900(var6_7, var10_12.getCertificate());
            }
        } else if (var6_7.isVerifiedUsingV1Scheme()) {
            for (Object var10_12 : var6_7.getV1SchemeSigners()) {
                Result.access$900(var6_7, var10_12.getCertificate());
            }
        } else {
            throw new RuntimeException("APK verified, but has not verified using any of v1, v2 or v3schemes");
        }
        return var6_7;
    }

    private static ByteBuffer getAndroidManifestFromApk(DataSource dataSource, ApkUtils.ZipSections zipSections) throws IOException, ApkFormatException {
        List<CentralDirectoryRecord> list = V1SchemeVerifier.parseZipCentralDirectory(dataSource, zipSections);
        try {
            return ApkSigner.getAndroidManifestFromApk(list, dataSource.slice(0L, zipSections.getZipCentralDirectoryOffset()));
        }
        catch (ZipFormatException zipFormatException) {
            throw new ApkFormatException("Failed to read AndroidManifest.xml", zipFormatException);
        }
    }

    private static int getTargetSandboxVersionFromBinaryAndroidManifest(ByteBuffer byteBuffer) throws ApkFormatException {
        try {
            AndroidBinXmlParser androidBinXmlParser = new AndroidBinXmlParser(byteBuffer);
            int n = androidBinXmlParser.getEventType();
            while (n != 2) {
                if (n == 3 && androidBinXmlParser.getDepth() == 1 && "manifest".equals(androidBinXmlParser.getName()) && androidBinXmlParser.getNamespace().isEmpty()) {
                    int n2 = 1;
                    block6: for (int i = 0; i < androidBinXmlParser.getAttributeCount(); ++i) {
                        if (androidBinXmlParser.getAttributeNameResourceId(i) != 16844108) continue;
                        int n3 = androidBinXmlParser.getAttributeValueType(i);
                        switch (n3) {
                            case 2: {
                                n2 = androidBinXmlParser.getAttributeIntValue(i);
                                break block6;
                            }
                            default: {
                                throw new ApkFormatException("Failed to determine APK's target sandbox version: unsupported value type of AndroidManifest.xml android:targetSandboxVersion. Only integer values supported.");
                            }
                        }
                    }
                    return n2;
                }
                n = androidBinXmlParser.next();
            }
            throw new ApkFormatException("Failed to determine APK's target sandbox version : no manifest element in AndroidManifest.xml");
        }
        catch (AndroidBinXmlParser.XmlParserException xmlParserException) {
            throw new ApkFormatException("Failed to determine APK's target sandbox version: malformed AndroidManifest.xml", xmlParserException);
        }
    }

    public static class Builder {
        private final File mApkFile;
        private final DataSource mApkDataSource;
        private Integer mMinSdkVersion;
        private int mMaxSdkVersion = Integer.MAX_VALUE;

        public Builder(File file) {
            if (file == null) {
                throw new NullPointerException("apk == null");
            }
            this.mApkFile = file;
            this.mApkDataSource = null;
        }

        public Builder(DataSource dataSource) {
            if (dataSource == null) {
                throw new NullPointerException("apk == null");
            }
            this.mApkDataSource = dataSource;
            this.mApkFile = null;
        }

        public Builder setMinCheckedPlatformVersion(int n) {
            this.mMinSdkVersion = n;
            return this;
        }

        public Builder setMaxCheckedPlatformVersion(int n) {
            this.mMaxSdkVersion = n;
            return this;
        }

        public ApkVerifier build() {
            return new ApkVerifier(this.mApkFile, this.mApkDataSource, this.mMinSdkVersion, this.mMaxSdkVersion);
        }
    }

    private static class ByteArray {
        private final byte[] mArray;
        private final int mHashCode;

        private ByteArray(byte[] byArray) {
            this.mArray = byArray;
            this.mHashCode = Arrays.hashCode(this.mArray);
        }

        public int hashCode() {
            return this.mHashCode;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ByteArray byteArray = (ByteArray)object;
            if (this.hashCode() != byteArray.hashCode()) {
                return false;
            }
            return Arrays.equals(this.mArray, byteArray.mArray);
        }
    }

    public static class IssueWithParams {
        private final Issue mIssue;
        private final Object[] mParams;

        public IssueWithParams(Issue issue, Object[] objectArray) {
            this.mIssue = issue;
            this.mParams = objectArray;
        }

        public Issue getIssue() {
            return this.mIssue;
        }

        public Object[] getParams() {
            return (Object[])this.mParams.clone();
        }

        public String toString() {
            return String.format(this.mIssue.getFormat(), this.mParams);
        }
    }

    public static enum Issue {
        JAR_SIG_NO_SIGNATURES("No JAR signatures"),
        JAR_SIG_NO_SIGNED_ZIP_ENTRIES("No JAR entries covered by JAR signatures"),
        JAR_SIG_DUPLICATE_ZIP_ENTRY("Duplicate entry: %1$s"),
        JAR_SIG_DUPLICATE_MANIFEST_SECTION("Duplicate section in META-INF/MANIFEST.MF: %1$s"),
        JAR_SIG_UNNNAMED_MANIFEST_SECTION("Malformed META-INF/MANIFEST.MF: invidual section #%1$d does not have a name"),
        JAR_SIG_UNNNAMED_SIG_FILE_SECTION("Malformed %1$s: invidual section #%2$d does not have a name"),
        JAR_SIG_NO_MANIFEST("Missing META-INF/MANIFEST.MF"),
        JAR_SIG_MISSING_ZIP_ENTRY_REFERENCED_IN_MANIFEST("%1$s entry referenced by META-INF/MANIFEST.MF not found in the APK"),
        JAR_SIG_NO_ZIP_ENTRY_DIGEST_IN_MANIFEST("No digest for %1$s in META-INF/MANIFEST.MF"),
        JAR_SIG_NO_ZIP_ENTRY_DIGEST_IN_SIG_FILE("No digest for %1$s in %2$s"),
        JAR_SIG_ZIP_ENTRY_NOT_SIGNED("%1$s entry not signed"),
        JAR_SIG_ZIP_ENTRY_SIGNERS_MISMATCH("Entries %1$s and %3$s are signed with different sets of signers : <%2$s> vs <%4$s>"),
        JAR_SIG_ZIP_ENTRY_DIGEST_DID_NOT_VERIFY("%2$s digest of %1$s does not match the digest specified in %3$s. Expected: <%5$s>, actual: <%4$s>"),
        JAR_SIG_MANIFEST_MAIN_SECTION_DIGEST_DID_NOT_VERIFY("%1$s digest of META-INF/MANIFEST.MF main section does not match the digest specified in %2$s. Expected: <%4$s>, actual: <%3$s>"),
        JAR_SIG_MANIFEST_SECTION_DIGEST_DID_NOT_VERIFY("%2$s digest of META-INF/MANIFEST.MF section for %1$s does not match the digest specified in %3$s. Expected: <%5$s>, actual: <%4$s>"),
        JAR_SIG_NO_MANIFEST_DIGEST_IN_SIG_FILE("%1$s does not specify digest of META-INF/MANIFEST.MF. This slows down verification."),
        JAR_SIG_NO_APK_SIG_STRIP_PROTECTION("APK is signed using APK Signature Scheme v2 but these signatures may be stripped without being detected because %1$s does not contain anti-stripping protections."),
        JAR_SIG_MISSING_FILE("Partial JAR signature. Found: %1$s, missing: %2$s"),
        JAR_SIG_VERIFY_EXCEPTION("Failed to verify JAR signature %1$s against %2$s: %3$s"),
        JAR_SIG_UNSUPPORTED_SIG_ALG("JAR signature %1$s uses digest algorithm %5$s and signature algorithm %6$s which is not supported on API Level(s) %4$s for which this APK is being verified"),
        JAR_SIG_PARSE_EXCEPTION("Failed to parse JAR signature %1$s: %2$s"),
        JAR_SIG_MALFORMED_CERTIFICATE("Malformed certificate in JAR signature %1$s: %2$s"),
        JAR_SIG_DID_NOT_VERIFY("JAR signature %1$s did not verify against %2$s"),
        JAR_SIG_NO_SIGNERS("JAR signature %1$s contains no signers"),
        JAR_SIG_DUPLICATE_SIG_FILE_SECTION("Duplicate section in %1$s: %2$s"),
        JAR_SIG_MISSING_VERSION_ATTR_IN_SIG_FILE("Malformed %1$s: missing Signature-Version attribute"),
        JAR_SIG_UNKNOWN_APK_SIG_SCHEME_ID("JAR signature %1$s references unknown APK signature scheme ID: %2$d"),
        JAR_SIG_MISSING_APK_SIG_REFERENCED("JAR signature %1$s indicates the APK is signed using %3$s but no such signature was found. Signature stripped?"),
        JAR_SIG_UNPROTECTED_ZIP_ENTRY("%1$s not protected by signature. Unauthorized modifications to this JAR entry will not be detected. Delete or move the entry outside of META-INF/."),
        JAR_SIG_MISSING("No JAR signature from this signer"),
        NO_SIG_FOR_TARGET_SANDBOX_VERSION("Missing APK Signature Scheme v2 signature required for target sandbox version %1$d"),
        V2_SIG_MISSING("No APK Signature Scheme v2 signature from this signer"),
        V2_SIG_MALFORMED_SIGNERS("Malformed list of signers"),
        V2_SIG_MALFORMED_SIGNER("Malformed signer block"),
        V2_SIG_MALFORMED_PUBLIC_KEY("Malformed public key: %1$s"),
        V2_SIG_MALFORMED_CERTIFICATE("Malformed certificate #%2$d: %3$s"),
        V2_SIG_MALFORMED_SIGNATURE("Malformed APK Signature Scheme v2 signature record #%1$d"),
        V2_SIG_MALFORMED_DIGEST("Malformed APK Signature Scheme v2 digest record #%1$d"),
        V2_SIG_MALFORMED_ADDITIONAL_ATTRIBUTE("Malformed additional attribute #%1$d"),
        V2_SIG_UNKNOWN_APK_SIG_SCHEME_ID("APK Signature Scheme v2 signer: %1$s references unknown APK signature scheme ID: %2$d"),
        V2_SIG_MISSING_APK_SIG_REFERENCED("APK Signature Scheme v2 signature %1$s indicates the APK is signed using %2$s but no such signature was found. Signature stripped?"),
        V2_SIG_NO_SIGNERS("No signers in APK Signature Scheme v2 signature"),
        V2_SIG_UNKNOWN_SIG_ALGORITHM("Unknown signature algorithm: %1$#x"),
        V2_SIG_UNKNOWN_ADDITIONAL_ATTRIBUTE("Unknown additional attribute: ID %1$#x"),
        V2_SIG_VERIFY_EXCEPTION("Failed to verify %1$s signature: %2$s"),
        V2_SIG_DID_NOT_VERIFY("%1$s signature over signed-data did not verify"),
        V2_SIG_NO_SIGNATURES("No signatures"),
        V2_SIG_NO_SUPPORTED_SIGNATURES("No supported signatures"),
        V2_SIG_NO_CERTIFICATES("No certificates"),
        V2_SIG_PUBLIC_KEY_MISMATCH_BETWEEN_CERTIFICATE_AND_SIGNATURES_RECORD("Public key mismatch between certificate and signature record: <%1$s> vs <%2$s>"),
        V2_SIG_SIG_ALG_MISMATCH_BETWEEN_SIGNATURES_AND_DIGESTS_RECORDS("Signature algorithms mismatch between signatures and digests records: %1$s vs %2$s"),
        V2_SIG_APK_DIGEST_DID_NOT_VERIFY("APK integrity check failed. %1$s digest mismatch. Expected: <%2$s>, actual: <%3$s>"),
        V3_SIG_MALFORMED_SIGNERS("Malformed list of signers"),
        V3_SIG_MALFORMED_SIGNER("Malformed signer block"),
        V3_SIG_MALFORMED_PUBLIC_KEY("Malformed public key: %1$s"),
        V3_SIG_MALFORMED_CERTIFICATE("Malformed certificate #%2$d: %3$s"),
        V3_SIG_MALFORMED_SIGNATURE("Malformed APK Signature Scheme v3 signature record #%1$d"),
        V3_SIG_MALFORMED_DIGEST("Malformed APK Signature Scheme v3 digest record #%1$d"),
        V3_SIG_MALFORMED_ADDITIONAL_ATTRIBUTE("Malformed additional attribute #%1$d"),
        V3_SIG_NO_SIGNERS("No signers in APK Signature Scheme v3 signature"),
        V3_SIG_MULTIPLE_SIGNERS("Multiple APK Signature Scheme v3 signatures found for a single  platform version."),
        V3_SIG_MULTIPLE_PAST_SIGNERS("Multiple signatures found for pre-v3 signing with an APK  Signature Scheme v3 signer.  Only one allowed."),
        V3_SIG_PAST_SIGNERS_MISMATCH("v3 signer differs from v1/v2 signer without proper signing certificate lineage."),
        V3_SIG_UNKNOWN_SIG_ALGORITHM("Unknown signature algorithm: %1$#x"),
        V3_SIG_UNKNOWN_ADDITIONAL_ATTRIBUTE("Unknown additional attribute: ID %1$#x"),
        V3_SIG_VERIFY_EXCEPTION("Failed to verify %1$s signature: %2$s"),
        V3_SIG_INVALID_SDK_VERSIONS("Invalid SDK Version parameter(s) encountered in APK Signature scheme v3 signature: minSdkVersion %1$s maxSdkVersion: %2$s"),
        V3_SIG_DID_NOT_VERIFY("%1$s signature over signed-data did not verify"),
        V3_SIG_NO_SIGNATURES("No signatures"),
        V3_SIG_NO_SUPPORTED_SIGNATURES("No supported signatures"),
        V3_SIG_NO_CERTIFICATES("No certificates"),
        V3_MIN_SDK_VERSION_MISMATCH_BETWEEN_SIGNER_AND_SIGNED_DATA_RECORD("minSdkVersion mismatch between signed data and signature record: <%1$s> vs <%2$s>"),
        V3_MAX_SDK_VERSION_MISMATCH_BETWEEN_SIGNER_AND_SIGNED_DATA_RECORD("maxSdkVersion mismatch between signed data and signature record: <%1$s> vs <%2$s>"),
        V3_SIG_PUBLIC_KEY_MISMATCH_BETWEEN_CERTIFICATE_AND_SIGNATURES_RECORD("Public key mismatch between certificate and signature record: <%1$s> vs <%2$s>"),
        V3_SIG_SIG_ALG_MISMATCH_BETWEEN_SIGNATURES_AND_DIGESTS_RECORDS("Signature algorithms mismatch between signatures and digests records: %1$s vs %2$s"),
        V3_SIG_APK_DIGEST_DID_NOT_VERIFY("APK integrity check failed. %1$s digest mismatch. Expected: <%2$s>, actual: <%3$s>"),
        V3_SIG_POR_DID_NOT_VERIFY("SigningCertificateLineage attribute containd a proof-of-rotation record with signature(s) that did not verify."),
        V3_SIG_MALFORMED_LINEAGE("Failed to parse the SigningCertificateLineage structure in the APK Signature Scheme v3 signature's additional attributes section."),
        V3_SIG_POR_CERT_MISMATCH("APK signing certificate differs from the associated certificate found in the signer's SigningCertificateLineage."),
        V3_INCONSISTENT_SDK_VERSIONS("APK Signature Scheme v3 signers supported min/max SDK versions are not continuous."),
        V3_MISSING_SDK_VERSIONS("APK Signature Scheme v3 signers supported min/max SDK versions do not cover the entire desired range.  Found min:  %1$s max %2$s"),
        V3_INCONSISTENT_LINEAGES("SigningCertificateLineages targeting different platform versions using APK Signature Scheme v3 are not all a part of the same overall lineage."),
        APK_SIG_BLOCK_UNKNOWN_ENTRY_ID("APK Signing Block contains unknown entry: ID %1$#x");

        private final String mFormat;

        private Issue(String string2) {
            this.mFormat = string2;
        }

        private String getFormat() {
            return this.mFormat;
        }
    }

    public static class Result {
        private final List<IssueWithParams> mErrors = new ArrayList<IssueWithParams>();
        private final List<IssueWithParams> mWarnings = new ArrayList<IssueWithParams>();
        private final List<X509Certificate> mSignerCerts = new ArrayList<X509Certificate>();
        private final List<V1SchemeSignerInfo> mV1SchemeSigners = new ArrayList<V1SchemeSignerInfo>();
        private final List<V1SchemeSignerInfo> mV1SchemeIgnoredSigners = new ArrayList<V1SchemeSignerInfo>();
        private final List<V2SchemeSignerInfo> mV2SchemeSigners = new ArrayList<V2SchemeSignerInfo>();
        private final List<V3SchemeSignerInfo> mV3SchemeSigners = new ArrayList<V3SchemeSignerInfo>();
        private boolean mVerified;
        private boolean mVerifiedUsingV1Scheme;
        private boolean mVerifiedUsingV2Scheme;
        private boolean mVerifiedUsingV3Scheme;
        private SigningCertificateLineage mSigningCertificateLineage;

        public boolean isVerified() {
            return this.mVerified;
        }

        private void setVerified() {
            this.mVerified = true;
        }

        public boolean isVerifiedUsingV1Scheme() {
            return this.mVerifiedUsingV1Scheme;
        }

        public boolean isVerifiedUsingV2Scheme() {
            return this.mVerifiedUsingV2Scheme;
        }

        public boolean isVerifiedUsingV3Scheme() {
            return this.mVerifiedUsingV3Scheme;
        }

        public List<X509Certificate> getSignerCertificates() {
            return this.mSignerCerts;
        }

        private void addSignerCertificate(X509Certificate x509Certificate) {
            this.mSignerCerts.add(x509Certificate);
        }

        public List<V1SchemeSignerInfo> getV1SchemeSigners() {
            return this.mV1SchemeSigners;
        }

        public List<V1SchemeSignerInfo> getV1SchemeIgnoredSigners() {
            return this.mV1SchemeIgnoredSigners;
        }

        public List<V2SchemeSignerInfo> getV2SchemeSigners() {
            return this.mV2SchemeSigners;
        }

        public List<V3SchemeSignerInfo> getV3SchemeSigners() {
            return this.mV3SchemeSigners;
        }

        public SigningCertificateLineage getSigningCertificateLineage() {
            return this.mSigningCertificateLineage;
        }

        void addError(Issue issue, Object ... objectArray) {
            this.mErrors.add(new IssueWithParams(issue, objectArray));
        }

        public List<IssueWithParams> getErrors() {
            return this.mErrors;
        }

        public List<IssueWithParams> getWarnings() {
            return this.mWarnings;
        }

        private void mergeFrom(V1SchemeVerifier.Result result) {
            this.mVerifiedUsingV1Scheme = result.verified;
            this.mErrors.addAll(result.getErrors());
            this.mWarnings.addAll(result.getWarnings());
            for (V1SchemeVerifier.Result.SignerInfo signerInfo : result.signers) {
                this.mV1SchemeSigners.add(new V1SchemeSignerInfo(signerInfo));
            }
            for (V1SchemeVerifier.Result.SignerInfo signerInfo : result.ignoredSigners) {
                this.mV1SchemeIgnoredSigners.add(new V1SchemeSignerInfo(signerInfo));
            }
        }

        private void mergeFrom(ApkSigningBlockUtils.Result result) {
            switch (result.signatureSchemeVersion) {
                case 2: {
                    this.mVerifiedUsingV2Scheme = result.verified;
                    for (ApkSigningBlockUtils.Result.SignerInfo signerInfo : result.signers) {
                        this.mV2SchemeSigners.add(new V2SchemeSignerInfo(signerInfo));
                    }
                    break;
                }
                case 3: {
                    this.mVerifiedUsingV3Scheme = result.verified;
                    for (ApkSigningBlockUtils.Result.SignerInfo signerInfo : result.signers) {
                        this.mV3SchemeSigners.add(new V3SchemeSignerInfo(signerInfo));
                    }
                    this.mSigningCertificateLineage = result.signingCertificateLineage;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Signing Block Scheme Id");
                }
            }
            this.mErrors.addAll(result.getErrors());
            this.mWarnings.addAll(result.getWarnings());
        }

        public boolean containsErrors() {
            if (!this.mErrors.isEmpty()) {
                return true;
            }
            if (!this.mV1SchemeSigners.isEmpty()) {
                for (V1SchemeSignerInfo object : this.mV1SchemeSigners) {
                    if (!object.containsErrors()) continue;
                    return true;
                }
            }
            if (!this.mV2SchemeSigners.isEmpty()) {
                for (V2SchemeSignerInfo v2SchemeSignerInfo : this.mV2SchemeSigners) {
                    if (!v2SchemeSignerInfo.containsErrors()) continue;
                    return true;
                }
            }
            if (!this.mV3SchemeSigners.isEmpty()) {
                for (V3SchemeSignerInfo v3SchemeSignerInfo : this.mV3SchemeSigners) {
                    if (!v3SchemeSignerInfo.containsErrors()) continue;
                    return true;
                }
            }
            return false;
        }

        static /* synthetic */ void access$000(Result result, ApkSigningBlockUtils.Result result2) {
            result.mergeFrom(result2);
        }

        static /* synthetic */ void access$100(Result result, V1SchemeVerifier.Result result2) {
            result.mergeFrom(result2);
        }

        static /* synthetic */ void access$800(Result result) {
            result.setVerified();
        }

        static /* synthetic */ void access$900(Result result, X509Certificate x509Certificate) {
            result.addSignerCertificate(x509Certificate);
        }

        public static class V3SchemeSignerInfo {
            private final int mIndex;
            private final List<X509Certificate> mCerts;
            private final List<IssueWithParams> mErrors;
            private final List<IssueWithParams> mWarnings;

            private V3SchemeSignerInfo(ApkSigningBlockUtils.Result.SignerInfo signerInfo) {
                this.mIndex = signerInfo.index;
                this.mCerts = signerInfo.certs;
                this.mErrors = signerInfo.getErrors();
                this.mWarnings = signerInfo.getWarnings();
            }

            public int getIndex() {
                return this.mIndex;
            }

            public X509Certificate getCertificate() {
                return this.mCerts.isEmpty() ? null : this.mCerts.get(0);
            }

            public List<X509Certificate> getCertificates() {
                return this.mCerts;
            }

            public boolean containsErrors() {
                return !this.mErrors.isEmpty();
            }

            public List<IssueWithParams> getErrors() {
                return this.mErrors;
            }

            public List<IssueWithParams> getWarnings() {
                return this.mWarnings;
            }

            static /* synthetic */ List access$700(V3SchemeSignerInfo v3SchemeSignerInfo) {
                return v3SchemeSignerInfo.mCerts;
            }
        }

        public static class V2SchemeSignerInfo {
            private final int mIndex;
            private final List<X509Certificate> mCerts;
            private final List<IssueWithParams> mErrors;
            private final List<IssueWithParams> mWarnings;

            private V2SchemeSignerInfo(ApkSigningBlockUtils.Result.SignerInfo signerInfo) {
                this.mIndex = signerInfo.index;
                this.mCerts = signerInfo.certs;
                this.mErrors = signerInfo.getErrors();
                this.mWarnings = signerInfo.getWarnings();
            }

            public int getIndex() {
                return this.mIndex;
            }

            public X509Certificate getCertificate() {
                return this.mCerts.isEmpty() ? null : this.mCerts.get(0);
            }

            public List<X509Certificate> getCertificates() {
                return this.mCerts;
            }

            private void addError(Issue issue, Object ... objectArray) {
                this.mErrors.add(new IssueWithParams(issue, objectArray));
            }

            public boolean containsErrors() {
                return !this.mErrors.isEmpty();
            }

            public List<IssueWithParams> getErrors() {
                return this.mErrors;
            }

            public List<IssueWithParams> getWarnings() {
                return this.mWarnings;
            }

            static /* synthetic */ void access$400(V2SchemeSignerInfo v2SchemeSignerInfo, Issue issue, Object[] objectArray) {
                v2SchemeSignerInfo.addError(issue, objectArray);
            }

            static /* synthetic */ List access$600(V2SchemeSignerInfo v2SchemeSignerInfo) {
                return v2SchemeSignerInfo.mCerts;
            }
        }

        public static class V1SchemeSignerInfo {
            private final String mName;
            private final List<X509Certificate> mCertChain;
            private final String mSignatureBlockFileName;
            private final String mSignatureFileName;
            private final List<IssueWithParams> mErrors;
            private final List<IssueWithParams> mWarnings;

            private V1SchemeSignerInfo(V1SchemeVerifier.Result.SignerInfo signerInfo) {
                this.mName = signerInfo.name;
                this.mCertChain = signerInfo.certChain;
                this.mSignatureBlockFileName = signerInfo.signatureBlockFileName;
                this.mSignatureFileName = signerInfo.signatureFileName;
                this.mErrors = signerInfo.getErrors();
                this.mWarnings = signerInfo.getWarnings();
            }

            public String getName() {
                return this.mName;
            }

            public String getSignatureBlockFileName() {
                return this.mSignatureBlockFileName;
            }

            public String getSignatureFileName() {
                return this.mSignatureFileName;
            }

            public X509Certificate getCertificate() {
                return this.mCertChain.isEmpty() ? null : this.mCertChain.get(0);
            }

            public List<X509Certificate> getCertificateChain() {
                return this.mCertChain;
            }

            public boolean containsErrors() {
                return !this.mErrors.isEmpty();
            }

            public List<IssueWithParams> getErrors() {
                return this.mErrors;
            }

            public List<IssueWithParams> getWarnings() {
                return this.mWarnings;
            }

            private void addError(Issue issue, Object ... objectArray) {
                this.mErrors.add(new IssueWithParams(issue, objectArray));
            }

            static /* synthetic */ void access$300(V1SchemeSignerInfo v1SchemeSignerInfo, Issue issue, Object[] objectArray) {
                v1SchemeSignerInfo.addError(issue, objectArray);
            }

            static /* synthetic */ List access$500(V1SchemeSignerInfo v1SchemeSignerInfo) {
                return v1SchemeSignerInfo.mCertChain;
            }
        }
    }
}

