/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.logging.Logger;
import org.bouncycastle.util.BigIntegers;

class DHParametersHelper {
    private static final Logger logger = Logger.getLogger(DHParametersHelper.class.getName());
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    DHParametersHelper() {
    }

    static BigInteger[] generateSafePrimes(int n, int n2, SecureRandom secureRandom) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        logger.info("Generating safe primes. This may take a long time.");
        long l = System.currentTimeMillis();
        int n3 = 0;
        int n4 = n - 1;
        do {
            ++n3;
        } while (!(bigInteger2 = (bigInteger = new BigInteger(n4, 2, secureRandom)).shiftLeft(1).add(ONE)).isProbablePrime(n2) || n2 > 2 && !bigInteger.isProbablePrime(n2));
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        logger.info("Generated safe primes: " + n3 + " tries took " + l3 + "ms");
        return new BigInteger[]{bigInteger2, bigInteger};
    }

    static BigInteger selectGenerator(BigInteger bigInteger, BigInteger bigInteger2, SecureRandom secureRandom) {
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        BigInteger bigInteger5 = bigInteger.subtract(TWO);
        while ((bigInteger4 = (bigInteger3 = BigIntegers.createRandomInRange(TWO, bigInteger5, secureRandom)).modPow(TWO, bigInteger)).equals(ONE)) {
        }
        return bigInteger4;
    }
}

