/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.CRLException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.eac.EACObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.x509.NoSuchStoreException;
import org.bouncycastle.x509.X509CollectionStoreParameters;
import org.bouncycastle.x509.X509Store;
import org.bouncycastle.x509.X509StoreParameters;
import org.bouncycastle.x509.X509V2AttributeCertificate;

class CMSSignedHelper {
    static final CMSSignedHelper INSTANCE = new CMSSignedHelper();
    private static final Map encryptionAlgs = new HashMap();
    private static final Map digestAlgs = new HashMap();
    private static final Map digestAliases = new HashMap();

    CMSSignedHelper() {
    }

    private static void addEntries(DERObjectIdentifier dERObjectIdentifier, String string, String string2) {
        digestAlgs.put(dERObjectIdentifier.getId(), string);
        encryptionAlgs.put(dERObjectIdentifier.getId(), string2);
    }

    String getDigestAlgName(String string) {
        String string2 = (String)digestAlgs.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    String getEncryptionAlgName(String string) {
        String string2 = (String)encryptionAlgs.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    X509Store createAttributeStore(String string, Provider provider, ASN1Set aSN1Set) throws NoSuchStoreException, CMSException {
        ArrayList<X509V2AttributeCertificate> arrayList = new ArrayList<X509V2AttributeCertificate>();
        if (aSN1Set != null) {
            Enumeration enumeration = aSN1Set.getObjects();
            while (enumeration.hasMoreElements()) {
                try {
                    ASN1TaggedObject aSN1TaggedObject;
                    ASN1Primitive aSN1Primitive = ((ASN1Encodable)enumeration.nextElement()).toASN1Primitive();
                    if (!(aSN1Primitive instanceof ASN1TaggedObject) || (aSN1TaggedObject = (ASN1TaggedObject)aSN1Primitive).getTagNo() != 2) continue;
                    arrayList.add(new X509V2AttributeCertificate(ASN1Sequence.getInstance(aSN1TaggedObject, false).getEncoded()));
                }
                catch (IOException iOException) {
                    throw new CMSException("can't re-encode attribute certificate!", iOException);
                }
            }
        }
        try {
            return X509Store.getInstance("AttributeCertificate/" + string, (X509StoreParameters)new X509CollectionStoreParameters(arrayList), provider);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("can't setup the X509Store", illegalArgumentException);
        }
    }

    X509Store createCertificateStore(String string, Provider provider, ASN1Set aSN1Set) throws NoSuchStoreException, CMSException {
        ArrayList arrayList = new ArrayList();
        if (aSN1Set != null) {
            this.addCertsFromSet(arrayList, aSN1Set, provider);
        }
        try {
            return X509Store.getInstance("Certificate/" + string, (X509StoreParameters)new X509CollectionStoreParameters(arrayList), provider);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("can't setup the X509Store", illegalArgumentException);
        }
    }

    X509Store createCRLsStore(String string, Provider provider, ASN1Set aSN1Set) throws NoSuchStoreException, CMSException {
        ArrayList arrayList = new ArrayList();
        if (aSN1Set != null) {
            this.addCRLsFromSet(arrayList, aSN1Set, provider);
        }
        try {
            return X509Store.getInstance("CRL/" + string, (X509StoreParameters)new X509CollectionStoreParameters(arrayList), provider);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("can't setup the X509Store", illegalArgumentException);
        }
    }

    CertStore createCertStore(String string, Provider provider, ASN1Set aSN1Set, ASN1Set aSN1Set2) throws CMSException, NoSuchAlgorithmException {
        ArrayList arrayList = new ArrayList();
        if (aSN1Set != null) {
            this.addCertsFromSet(arrayList, aSN1Set, provider);
        }
        if (aSN1Set2 != null) {
            this.addCRLsFromSet(arrayList, aSN1Set2, provider);
        }
        try {
            if (provider != null) {
                return CertStore.getInstance(string, (CertStoreParameters)new CollectionCertStoreParameters(arrayList), provider);
            }
            return CertStore.getInstance(string, new CollectionCertStoreParameters(arrayList));
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("can't setup the CertStore", invalidAlgorithmParameterException);
        }
    }

    private void addCertsFromSet(List list, ASN1Set aSN1Set, Provider provider) throws CMSException {
        CertificateFactory certificateFactory;
        try {
            certificateFactory = provider != null ? CertificateFactory.getInstance("X.509", provider) : CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new CMSException("can't get certificate factory.", certificateException);
        }
        Enumeration enumeration = aSN1Set.getObjects();
        while (enumeration.hasMoreElements()) {
            try {
                ASN1Primitive aSN1Primitive = ((ASN1Encodable)enumeration.nextElement()).toASN1Primitive();
                if (!(aSN1Primitive instanceof ASN1Sequence)) continue;
                list.add(certificateFactory.generateCertificate(new ByteArrayInputStream(aSN1Primitive.getEncoded())));
            }
            catch (IOException iOException) {
                throw new CMSException("can't re-encode certificate!", iOException);
            }
            catch (CertificateException certificateException) {
                throw new CMSException("can't re-encode certificate!", certificateException);
            }
        }
    }

    private void addCRLsFromSet(List list, ASN1Set aSN1Set, Provider provider) throws CMSException {
        CertificateFactory certificateFactory;
        try {
            certificateFactory = provider != null ? CertificateFactory.getInstance("X.509", provider) : CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new CMSException("can't get certificate factory.", certificateException);
        }
        Enumeration enumeration = aSN1Set.getObjects();
        while (enumeration.hasMoreElements()) {
            try {
                ASN1Primitive aSN1Primitive = ((ASN1Encodable)enumeration.nextElement()).toASN1Primitive();
                list.add(certificateFactory.generateCRL(new ByteArrayInputStream(aSN1Primitive.getEncoded())));
            }
            catch (IOException iOException) {
                throw new CMSException("can't re-encode CRL!", iOException);
            }
            catch (CRLException cRLException) {
                throw new CMSException("can't re-encode CRL!", cRLException);
            }
        }
    }

    AlgorithmIdentifier fixAlgID(AlgorithmIdentifier algorithmIdentifier) {
        if (algorithmIdentifier.getParameters() == null) {
            return new AlgorithmIdentifier(algorithmIdentifier.getObjectId(), (ASN1Encodable)DERNull.INSTANCE);
        }
        return algorithmIdentifier;
    }

    void setSigningEncryptionAlgorithmMapping(DERObjectIdentifier dERObjectIdentifier, String string) {
        encryptionAlgs.put(dERObjectIdentifier.getId(), string);
    }

    void setSigningDigestAlgorithmMapping(DERObjectIdentifier dERObjectIdentifier, String string) {
        digestAlgs.put(dERObjectIdentifier.getId(), string);
    }

    static {
        CMSSignedHelper.addEntries(NISTObjectIdentifiers.dsa_with_sha256, "SHA256", "DSA");
        CMSSignedHelper.addEntries(NISTObjectIdentifiers.dsa_with_sha384, "SHA384", "DSA");
        CMSSignedHelper.addEntries(NISTObjectIdentifiers.dsa_with_sha512, "SHA512", "DSA");
        CMSSignedHelper.addEntries(OIWObjectIdentifiers.dsaWithSHA1, "SHA1", "DSA");
        CMSSignedHelper.addEntries(OIWObjectIdentifiers.md5WithRSA, "MD5", "RSA");
        CMSSignedHelper.addEntries(OIWObjectIdentifiers.sha1WithRSA, "SHA1", "RSA");
        CMSSignedHelper.addEntries(PKCSObjectIdentifiers.md5WithRSAEncryption, "MD5", "RSA");
        CMSSignedHelper.addEntries(PKCSObjectIdentifiers.sha1WithRSAEncryption, "SHA1", "RSA");
        CMSSignedHelper.addEntries(PKCSObjectIdentifiers.sha256WithRSAEncryption, "SHA256", "RSA");
        CMSSignedHelper.addEntries(PKCSObjectIdentifiers.sha384WithRSAEncryption, "SHA384", "RSA");
        CMSSignedHelper.addEntries(PKCSObjectIdentifiers.sha512WithRSAEncryption, "SHA512", "RSA");
        CMSSignedHelper.addEntries(X9ObjectIdentifiers.ecdsa_with_SHA1, "SHA1", "ECDSA");
        CMSSignedHelper.addEntries(X9ObjectIdentifiers.ecdsa_with_SHA256, "SHA256", "ECDSA");
        CMSSignedHelper.addEntries(X9ObjectIdentifiers.ecdsa_with_SHA384, "SHA384", "ECDSA");
        CMSSignedHelper.addEntries(X9ObjectIdentifiers.ecdsa_with_SHA512, "SHA512", "ECDSA");
        CMSSignedHelper.addEntries(X9ObjectIdentifiers.id_dsa_with_sha1, "SHA1", "DSA");
        CMSSignedHelper.addEntries(EACObjectIdentifiers.id_TA_ECDSA_SHA_1, "SHA1", "ECDSA");
        CMSSignedHelper.addEntries(EACObjectIdentifiers.id_TA_ECDSA_SHA_256, "SHA256", "ECDSA");
        CMSSignedHelper.addEntries(EACObjectIdentifiers.id_TA_ECDSA_SHA_384, "SHA384", "ECDSA");
        CMSSignedHelper.addEntries(EACObjectIdentifiers.id_TA_ECDSA_SHA_512, "SHA512", "ECDSA");
        CMSSignedHelper.addEntries(EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_1, "SHA1", "RSA");
        CMSSignedHelper.addEntries(EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_256, "SHA256", "RSA");
        CMSSignedHelper.addEntries(EACObjectIdentifiers.id_TA_RSA_PSS_SHA_1, "SHA1", "RSAandMGF1");
        CMSSignedHelper.addEntries(EACObjectIdentifiers.id_TA_RSA_PSS_SHA_256, "SHA256", "RSAandMGF1");
        encryptionAlgs.put(X9ObjectIdentifiers.id_dsa.getId(), "DSA");
        encryptionAlgs.put(PKCSObjectIdentifiers.rsaEncryption.getId(), "RSA");
        encryptionAlgs.put(TeleTrusTObjectIdentifiers.teleTrusTRSAsignatureAlgorithm, "RSA");
        encryptionAlgs.put(X509ObjectIdentifiers.id_ea_rsa.getId(), "RSA");
        digestAlgs.put(PKCSObjectIdentifiers.md5.getId(), "MD5");
        digestAlgs.put(OIWObjectIdentifiers.idSHA1.getId(), "SHA1");
        digestAlgs.put(NISTObjectIdentifiers.id_sha256.getId(), "SHA256");
        digestAlgs.put(NISTObjectIdentifiers.id_sha384.getId(), "SHA384");
        digestAlgs.put(NISTObjectIdentifiers.id_sha512.getId(), "SHA512");
        digestAliases.put("SHA1", new String[]{"SHA-1"});
        digestAliases.put("SHA256", new String[]{"SHA-256"});
        digestAliases.put("SHA384", new String[]{"SHA-384"});
        digestAliases.put("SHA512", new String[]{"SHA-512"});
    }
}

