/*
 * Decompiled with CFR 0.152.
 */
package com.android.signapk;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.security.DigestOutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.encoders.Base64;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;

class SignApk {
    private static final String CERT_SF_NAME = "META-INF/CERT.SF";
    private static final String CERT_RSA_NAME = "META-INF/CERT.RSA";
    private static final String OTACERT_NAME = "META-INF/com/android/otacert";
    private static Provider sBouncyCastleProvider;
    private static Pattern stripPattern;

    SignApk() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate readPublicKey(File file) throws IOException, GeneralSecurityException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
            return x509Certificate;
        }
        finally {
            fileInputStream.close();
        }
    }

    private static String readPassword(File file) {
        System.out.print("Enter password for " + file + " (password will not be hidden): ");
        System.out.flush();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            return bufferedReader.readLine();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static KeySpec decryptPrivateKey(byte[] byArray, File file) throws GeneralSecurityException {
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;
        try {
            encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(byArray);
        }
        catch (IOException iOException) {
            return null;
        }
        char[] cArray = SignApk.readPassword(file).toCharArray();
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(encryptedPrivateKeyInfo.getAlgName());
        SecretKey secretKey = secretKeyFactory.generateSecret(new PBEKeySpec(cArray));
        Cipher cipher = Cipher.getInstance(encryptedPrivateKeyInfo.getAlgName());
        cipher.init(2, (Key)secretKey, encryptedPrivateKeyInfo.getAlgParameters());
        try {
            return encryptedPrivateKeyInfo.getKeySpec(cipher);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            System.err.println("signapk: Password for " + file + " may be bad.");
            throw invalidKeySpecException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PrivateKey readPrivateKey(File file) throws IOException, GeneralSecurityException {
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
        try {
            byte[] byArray = new byte[(int)file.length()];
            dataInputStream.read(byArray);
            KeySpec keySpec = SignApk.decryptPrivateKey(byArray, file);
            if (keySpec == null) {
                keySpec = new PKCS8EncodedKeySpec(byArray);
            }
            try {
                PrivateKey privateKey = KeyFactory.getInstance("RSA").generatePrivate(keySpec);
                return privateKey;
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                PrivateKey privateKey = KeyFactory.getInstance("DSA").generatePrivate(keySpec);
                dataInputStream.close();
                return privateKey;
            }
        }
        finally {
            dataInputStream.close();
        }
    }

    private static Manifest addDigestsToManifest(JarFile jarFile) throws IOException, GeneralSecurityException {
        Manifest manifest = jarFile.getManifest();
        Manifest manifest2 = new Manifest();
        Attributes attributes = manifest2.getMainAttributes();
        if (manifest != null) {
            attributes.putAll((Map<?, ?>)manifest.getMainAttributes());
        } else {
            attributes.putValue("Manifest-Version", "1.0");
            attributes.putValue("Created-By", "1.0 (Android SignApk)");
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
        byte[] byArray = new byte[4096];
        TreeMap<String, JarEntry> treeMap = new TreeMap<String, JarEntry>();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            treeMap.put(jarEntry.getName(), jarEntry);
        }
        for (JarEntry jarEntry : treeMap.values()) {
            int n;
            String string = jarEntry.getName();
            if (jarEntry.isDirectory() || string.equals("META-INF/MANIFEST.MF") || string.equals(CERT_SF_NAME) || string.equals(CERT_RSA_NAME) || string.equals(OTACERT_NAME) || stripPattern != null && stripPattern.matcher(string).matches()) continue;
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            while ((n = inputStream.read(byArray)) > 0) {
                messageDigest.update(byArray, 0, n);
            }
            Attributes attributes2 = null;
            if (manifest != null) {
                attributes2 = manifest.getAttributes(string);
            }
            attributes2 = attributes2 != null ? new Attributes(attributes2) : new Attributes();
            attributes2.putValue("SHA1-Digest", new String(Base64.encode(messageDigest.digest()), "ASCII"));
            manifest2.getEntries().put(string, attributes2);
        }
        return manifest2;
    }

    private static void addOtacert(JarOutputStream jarOutputStream, File file, long l, Manifest manifest) throws IOException, GeneralSecurityException {
        int n;
        MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
        JarEntry jarEntry = new JarEntry(OTACERT_NAME);
        jarEntry.setTime(l);
        jarOutputStream.putNextEntry(jarEntry);
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[4096];
        while ((n = fileInputStream.read(byArray)) != -1) {
            jarOutputStream.write(byArray, 0, n);
            messageDigest.update(byArray, 0, n);
        }
        fileInputStream.close();
        Attributes attributes = new Attributes();
        attributes.putValue("SHA1-Digest", new String(Base64.encode(messageDigest.digest()), "ASCII"));
        manifest.getEntries().put(OTACERT_NAME, attributes);
    }

    private static void writeSignatureFile(Manifest manifest, OutputStream outputStream) throws IOException, GeneralSecurityException {
        Manifest manifest2 = new Manifest();
        Attributes attributes = manifest2.getMainAttributes();
        attributes.putValue("Signature-Version", "1.0");
        attributes.putValue("Created-By", "1.0 (Android SignApk)");
        MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
        PrintStream printStream = new PrintStream((OutputStream)new DigestOutputStream(new ByteArrayOutputStream(), messageDigest), true, "UTF-8");
        manifest.write(printStream);
        printStream.flush();
        attributes.putValue("SHA1-Digest-Manifest", new String(Base64.encode(messageDigest.digest()), "ASCII"));
        Map<String, Attributes> map = manifest.getEntries();
        for (Map.Entry<String, Attributes> entry : map.entrySet()) {
            printStream.print("Name: " + entry.getKey() + "\r\n");
            for (Map.Entry<Object, Object> entry2 : entry.getValue().entrySet()) {
                printStream.print(entry2.getKey() + ": " + entry2.getValue() + "\r\n");
            }
            printStream.print("\r\n");
            printStream.flush();
            Attributes attributes2 = new Attributes();
            attributes2.putValue("SHA1-Digest", new String(Base64.encode(messageDigest.digest()), "ASCII"));
            manifest2.getEntries().put(entry.getKey(), attributes2);
        }
        CountOutputStream countOutputStream = new CountOutputStream(outputStream);
        manifest2.write(countOutputStream);
        if (countOutputStream.size() % 1024 == 0) {
            countOutputStream.write(13);
            countOutputStream.write(10);
        }
    }

    private static void writeSignatureBlock(CMSTypedData cMSTypedData, X509Certificate x509Certificate, PrivateKey privateKey, OutputStream outputStream) throws IOException, CertificateEncodingException, OperatorCreationException, CMSException {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(1);
        arrayList.add(x509Certificate);
        JcaCertStore jcaCertStore = new JcaCertStore(arrayList);
        CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA1withRSA").setProvider(sBouncyCastleProvider).build(privateKey);
        cMSSignedDataGenerator.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(sBouncyCastleProvider).build()).setDirectSignature(true).build(contentSigner, x509Certificate));
        cMSSignedDataGenerator.addCertificates(jcaCertStore);
        CMSSignedData cMSSignedData = cMSSignedDataGenerator.generate(cMSTypedData, false);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(cMSSignedData.getEncoded());
        DEROutputStream dEROutputStream = new DEROutputStream(outputStream);
        dEROutputStream.writeObject(aSN1InputStream.readObject());
    }

    private static void writeSignatureBlock(Signature signature, X509Certificate x509Certificate, OutputStream outputStream) throws IOException, GeneralSecurityException {
        SignerInfo signerInfo = new SignerInfo(new X500Name(x509Certificate.getIssuerX500Principal().getName()), x509Certificate.getSerialNumber(), AlgorithmId.get("SHA1"), AlgorithmId.get("RSA"), signature.sign());
        PKCS7 pKCS7 = new PKCS7(new AlgorithmId[]{AlgorithmId.get("SHA1")}, new ContentInfo(ContentInfo.DATA_OID, null), new X509Certificate[]{x509Certificate}, new SignerInfo[]{signerInfo});
        pKCS7.encodeSignedData(outputStream);
    }

    private static void signWholeOutputFile(byte[] byArray, OutputStream outputStream, X509Certificate x509Certificate, PrivateKey privateKey) throws IOException, CertificateEncodingException, OperatorCreationException, CMSException {
        if (byArray[byArray.length - 22] != 80 || byArray[byArray.length - 21] != 75 || byArray[byArray.length - 20] != 5 || byArray[byArray.length - 19] != 6) {
            throw new IllegalArgumentException("zip data already has an archive comment");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = "signed by SignApk".getBytes("UTF-8");
        byteArrayOutputStream.write(byArray2);
        byteArrayOutputStream.write(0);
        SignApk.writeSignatureBlock(new CMSByteArraySlice(byArray, 0, byArray.length - 2), x509Certificate, privateKey, byteArrayOutputStream);
        int n = byteArrayOutputStream.size() + 6;
        if (n > 65535) {
            throw new IllegalArgumentException("signature is too big for ZIP file comment");
        }
        int n2 = n - byArray2.length - 1;
        byteArrayOutputStream.write(n2 & 0xFF);
        byteArrayOutputStream.write(n2 >> 8 & 0xFF);
        byteArrayOutputStream.write(255);
        byteArrayOutputStream.write(255);
        byteArrayOutputStream.write(n & 0xFF);
        byteArrayOutputStream.write(n >> 8 & 0xFF);
        byteArrayOutputStream.flush();
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        for (int i = 0; i < byArray3.length - 3; ++i) {
            if (byArray3[i] != 80 || byArray3[i + 1] != 75 || byArray3[i + 2] != 5 || byArray3[i + 3] != 6) continue;
            throw new IllegalArgumentException("found spurious EOCD header at " + i);
        }
        outputStream.write(byArray, 0, byArray.length - 2);
        outputStream.write(n & 0xFF);
        outputStream.write(n >> 8 & 0xFF);
        byteArrayOutputStream.writeTo(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void signWholeOutputFile(String string, X509Certificate x509Certificate, PrivateKey privateKey) throws IOException, GeneralSecurityException {
        File file = null;
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        RandomAccessFile randomAccessFile = null;
        Object var7_7 = null;
        try {
            file = new File(string);
            long l = file.length();
            fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[22];
            fileInputStream.skip(l - 22L);
            fileInputStream.read(byArray, 0, 22);
            if (byArray[0] != 80 || byArray[1] != 75 || byArray[2] != 5 || byArray[3] != 6) {
                throw new IllegalArgumentException("zip data already has an archive comment");
            }
            fileInputStream.close();
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initSign(privateKey);
            fileInputStream = new FileInputStream(string);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            byte[] byArray2 = new byte[65536];
            System.err.println(" Signing Whole File");
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            while (bufferedInputStream.available() >= 2) {
                int n = bufferedInputStream.read(byArray2);
                l3 = (l4 += (long)n) * 100L / l;
                if (l3 - l2 >= 5L) {
                    l2 = l3;
                    System.err.print(l2 + "%\r");
                }
                if (bufferedInputStream.available() < 2) {
                    n = n - 2 + bufferedInputStream.available();
                }
                signature.update(byArray2, 0, n);
            }
            bufferedInputStream.close();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray3 = "signed by SignApk".getBytes("UTF-8");
            byteArrayOutputStream.write(byArray3);
            byteArrayOutputStream.write(0);
            SignApk.writeSignatureBlock(signature, x509Certificate, byteArrayOutputStream);
            int n = byteArrayOutputStream.size() + 6;
            if (n > 65535) {
                throw new IllegalArgumentException("signature is too big for ZIP file comment");
            }
            int n2 = n - byArray3.length - 1;
            byteArrayOutputStream.write(n2 & 0xFF);
            byteArrayOutputStream.write(n2 >> 8 & 0xFF);
            byteArrayOutputStream.write(255);
            byteArrayOutputStream.write(255);
            byteArrayOutputStream.write(n & 0xFF);
            byteArrayOutputStream.write(n >> 8 & 0xFF);
            byteArrayOutputStream.flush();
            byte[] byArray4 = byteArrayOutputStream.toByteArray();
            for (int i = 0; i < byArray4.length - 3; ++i) {
                if (byArray4[i] != 80 || byArray4[i + 1] != 75 || byArray4[i + 2] != 5 || byArray4[i + 3] != 6) continue;
                throw new IllegalArgumentException("found spurious EOCD header at " + i);
            }
            randomAccessFile = new RandomAccessFile(string, "rw");
            randomAccessFile.seek(l - 2L);
            randomAccessFile.write(n & 0xFF);
            randomAccessFile.write(n >> 8 & 0xFF);
            randomAccessFile.write(byteArrayOutputStream.toByteArray());
            randomAccessFile.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(1);
            }
        }
    }

    private static void copyFiles(Manifest manifest, JarFile jarFile, JarOutputStream jarOutputStream, long l) throws IOException {
        byte[] byArray = new byte[4096];
        Map<String, Attributes> map = manifest.getEntries();
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        Collections.sort(arrayList);
        for (String string : arrayList) {
            int n;
            JarEntry jarEntry = jarFile.getJarEntry(string);
            JarEntry jarEntry2 = null;
            jarEntry2 = jarEntry.getMethod() == 0 ? new JarEntry(jarEntry) : new JarEntry(string);
            System.err.println(string);
            jarEntry2.setTime(l);
            jarOutputStream.putNextEntry(jarEntry2);
            System.err.println(string);
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            while ((n = inputStream.read(byArray)) > 0) {
                jarOutputStream.write(byArray, 0, n);
            }
            jarOutputStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        if (stringArray.length != 4 && stringArray.length != 5) {
            System.err.println("Usage: signapk [-w] publickey.x509[.pem] privatekey.pk8 input.jar output.jar");
            System.exit(2);
        }
        sBouncyCastleProvider = new BouncyCastleProvider();
        Security.addProvider(sBouncyCastleProvider);
        boolean bl = false;
        int n = 0;
        if (stringArray[0].equals("-w")) {
            bl = true;
            n = 1;
        }
        ZipFile zipFile = null;
        JarOutputStream jarOutputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(stringArray[n + 0]);
            X509Certificate x509Certificate = SignApk.readPublicKey(file);
            long l = x509Certificate.getNotBefore().getTime() + 3600000L;
            PrivateKey privateKey = SignApk.readPrivateKey(new File(stringArray[n + 1]));
            zipFile = new JarFile(new File(stringArray[n + 2]), false);
            FileOutputStream fileOutputStream2 = null;
            fileOutputStream2 = fileOutputStream = new FileOutputStream(stringArray[n + 3]);
            jarOutputStream = new JarOutputStream(fileOutputStream2);
            if (!bl) {
                jarOutputStream.setLevel(9);
            }
            Manifest manifest = SignApk.addDigestsToManifest((JarFile)zipFile);
            SignApk.copyFiles(manifest, (JarFile)zipFile, jarOutputStream, l);
            if (bl) {
                SignApk.addOtacert(jarOutputStream, file, l, manifest);
            }
            JarEntry jarEntry = new JarEntry("META-INF/MANIFEST.MF");
            jarEntry.setTime(l);
            jarOutputStream.putNextEntry(jarEntry);
            manifest.write(jarOutputStream);
            jarEntry = new JarEntry(CERT_SF_NAME);
            jarEntry.setTime(l);
            jarOutputStream.putNextEntry(jarEntry);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            SignApk.writeSignatureFile(manifest, byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            jarOutputStream.write(byArray);
            jarEntry = new JarEntry(CERT_RSA_NAME);
            jarEntry.setTime(l);
            jarOutputStream.putNextEntry(jarEntry);
            SignApk.writeSignatureBlock(new CMSProcessableByteArray(byArray), x509Certificate, privateKey, jarOutputStream);
            jarOutputStream.close();
            jarOutputStream = null;
            fileOutputStream2.flush();
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (bl) {
                SignApk.signWholeOutputFile(stringArray[n + 3], x509Certificate, privateKey);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(1);
            }
        }
    }

    static {
        stripPattern = Pattern.compile("^META-INF/(.*)[.](SF|RSA|DSA)$");
    }

    private static class CMSByteArraySlice
    implements CMSTypedData {
        private final ASN1ObjectIdentifier type;
        private final byte[] data;
        private final int offset;
        private final int length;

        public CMSByteArraySlice(byte[] byArray, int n, int n2) {
            this.data = byArray;
            this.offset = n;
            this.length = n2;
            this.type = new ASN1ObjectIdentifier(CMSObjectIdentifiers.data.getId());
        }

        public Object getContent() {
            throw new UnsupportedOperationException();
        }

        public ASN1ObjectIdentifier getContentType() {
            return this.type;
        }

        public void write(OutputStream outputStream) throws IOException {
            outputStream.write(this.data, this.offset, this.length);
        }
    }

    private static class CountOutputStream
    extends FilterOutputStream {
        private int mCount = 0;

        public CountOutputStream(OutputStream outputStream) {
            super(outputStream);
        }

        public void write(int n) throws IOException {
            super.write(n);
            ++this.mCount;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            super.write(byArray, n, n2);
            this.mCount += n2;
        }

        public int size() {
            return this.mCount;
        }
    }
}

