--[[
--avb encrypt tool encapsulation
--2018.08.28
--]]
local function _MsgP(level, fmt, ...)
    print(string.format('L' .. debug.getinfo(level or 3).currentline .. ':' .. fmt, ...))
end -- local function MsgP(fmt, ...)

local function MsgP(fmt, ...)
    _MsgP(nil, fmt, ...)
end

local function copy_file(from, to)
    local src = io.open(from, 'rb')
    if not src then
        MsgP("FAIL open file %s", from); return nil
    end
    local content = src:read('*a')
    src:close()
    if not content then 
        MsgP('Fail in read file %s\n', from); return nil
    end
    local dst = io.open(to, 'wb')
    if not dst then
        MsgP("FAIL create file %s", to); return nil
    end
    local file , err = dst:write(content)
    dst:close()
    if not file then 
        MsgP('Fail in write file %s, err msg(%s)\n', to, err or 'none')
    end
    return file
end -- local function copy_file(from, to)

local function file_exist(filepath)
    local tmp = io.open(filepath)
    if not tmp then
        MsgP('file[%s] not exist', filepath); 
        return nil
    end
    local filesz = tmp:seek('end')
    tmp:close()
    return filesz
end-- local function file_exist()

local avbtool = [[dist\avbtool.exe]]
local function has_avbfooter(imgPath)
    local cmd = string.format('%s info_footer --image %s', avbtool, imgPath)
    MsgP('cmd[%s]\n', cmd)
    local terminated, sta, rcode = os.execute(cmd)
    return 1 == rcode
end -- local function has_avbfooter(imgPath)

local function avb_erase_footer(imgPath)
    local cmd = string.format('%s erase_footer --image %s', avbtool, imgPath)
    MsgP('cmd[%s]\n', cmd)
    MsgP("image sz 0x%x before erase avb footer\n", file_exist(imgPath))
    local terminated, sta, rcode = os.execute(cmd)
    local ret = (0 == rcode)
    if not ret then MsgP('Fail in erase footer for %s\n', imgPath); end
    MsgP("image sz 0x%x after erase avb footer\n", file_exist(imgPath))
    return ret
end -- local function avb_erase_footer(imgPath)

--./avbtool add_hash_footer --image boot.img.enc --partition_size 16777216 --partition_name boot 
local function avb_add_hash_footer(imgPath, partSz, partName)
    local cmd = string.format('%s add_hash_footer --image %s --partition_size %d --partition_name %s', 
                              avbtool, imgPath, partSz, partName)
    MsgP('cmd[%s]\n', cmd)
    local terminated, sta, rcode = os.execute(cmd)
    local ret = (0 == rcode)
    if not ret then MsgP('Fail in add_hash_footer\n'); end
    return ret
end -- local function avb_add_footer()

--flags=$(./avbtool info_flags --image vbmeta.img)
--rollback_index=$(./avbtool info_rollback_index --image vbmeta.img)
local function avb_get_extra_para(vbmetaPath)
    local para = '--padding_size 4096 --rollback_index %d --flags %d' 
    local cmd = string.format('%s info_flags --image %s', avbtool, vbmetaPath)
    MsgP('cmd[%s]\n', cmd)
    local terminated, sta, flag = os.execute(cmd)
    cmd = string.format('%s info_rollback_index --image %s', avbtool, vbmetaPath)
    MsgP('cmd[%s]\n', cmd)
    local terminated, sta, rollback_index = os.execute(cmd)
    para = para:format(flag, rollback_index)
    MsgP('para[%s]\n', para)
    return para
end -- local function avb_get_flag()

local usage=arg[0] .. '\n\tbefore_sign img/ota <unpack dir>' .. '\n\tafter_sign ota/img <unpack dir> pemPath'
print(arg[0], arg[-1])
print("[args]", table.unpack(arg))
if 3 > #arg then
    MsgP('arg num %d err\n usage[%s]\n', #arg, usage)
    os.exit(false)
end
local subCmd = arg[1]
local unpackDir = arg[3]
local isOtaPkg  =  ('ota' == arg[2])
if 'after_sign' == subCmd then
    if 4 > #arg then
        MsgP('arg num %d err\n usage[%s]\n', #arg, usage)
        os.exit(false)
    end
end
local scriptPath = arg[0]
local scriptDir = scriptPath:match('.*\\')
if not scriptDir then
    scriptDir = scriptPath:match('.*/')
    avbtool = avbtool:gsub('\\', '/')
end
avbtool = scriptDir .. avbtool
if not file_exist(avbtool) then return nil end
if unpackDir:sub(-1) ~= '\\' then unpackDir = unpackDir .. '\\' end
local vbmeta = unpackDir .. 'vbmeta.' .. (isOtaPkg and 'img' or 'PARTITION')
local vbmeta_a = unpackDir .. 'vbmeta_a.' .. (isOtaPkg and 'img' or 'PARTITION')
local BackVbmeta = vbmeta .. '.bak'


if not ( file_exist(vbmeta) or file_exist(vbmeta_a) ) then 
    MsgP('vbmeta[%s] and [%s] not existed\n', vbmeta, vbmeta_a)	
    os.exit(0x10);
end

local boot, recovery, dtb, super = "boot.", "recovery.", "_aml_dtb.", "super."
if isOtaPkg then
    boot, recovery , dtb = unpackDir ..  'boot.img', unpackDir .. 'recovery.img', unpackDir .. 'dtb.img'
else
    if file_exist(vbmeta_a) then
        boot, recovery , dtb = unpackDir ..  'boot_a.PARTITION', unpackDir .. 'recovery_a.PARTITION', unpackDir .. '_aml_dtb.PARTITION'
    else
        boot, recovery , dtb = unpackDir ..  'boot.PARTITION', unpackDir .. 'recovery.PARTITION', unpackDir .. '_aml_dtb.PARTITION'
    end
end
local BackBoot, BackRecovery, BackDtb = boot .. '.bak', recovery .. '.bak', dtb .. '.bak'
local hasBoot, hasRecovery, hasDtb = file_exist(boot), file_exist(recovery), file_exist(dtb)
if not (hasBoot or hasRecovery) then
    MsgP("both recovery and boot not existed, can't support avb\n");
    os.exit(false)
end
if (not hasDtb) and isOtaPkg then
    dtb = unpackDir .. 'dt.img'
    hasDtb = file_exist(dtb)
    if not hasDtb then
	MsgP("no have dtb")
--        os.exit(false); 
    else
      BackDtb = dtb .. '.bak'
    end
	
end

--[[
--./avbtool make_vbmeta_image 
--include_descriptors_from_image boot.img.enc 
--include_descriptors_from_image recovery.img.enc 
--algorithm SHA256_RSA2048 --key testkey_rsa2048.pem 
--include_descriptors_from_image dtb.img.enc 
--padding_size 4096 
----oldvbmeta vbmeta.img
--output vbmeta.img
--]]
local function avb_create_new_vbmeta(para)
    local extraPara = " --padding_size 4096"
    local cmd = avbtool .. " make_vbmeta_image " ..
    " --include_descriptors_from_image " .. para.boot ..
    " --include_descriptors_from_image  " .. para.recovery ..
    " --include_descriptors_from_image  " .. para.dtb ..
    " --oldvbmeta " .. para.oldVbmeta ..
    " --algorithm SHA256_RSA2048 --key " .. para.keyPath ..
    " " .. extraPara ..
    ' --output ' .. para.output
    MsgP('cmd[%s]\n', cmd)
    local terminated, sta, rcode = os.execute(cmd)
    MsgP('rcode=%d\n', rcode)
    return rcode
end -- local function avb_create_new_vbmeta(para)


--[[
--step 1, check has avb info footer or not
--step 2, back boot and recovery
--step 3, erase original boot/recovery avb footer
--]]
local function avb_before_sign()
    local hasAvbFooter = hasBoot and has_avbfooter(boot) or has_avbfooter(recovery)
    if not hasAvbFooter then
        MsgP("Has nott avb info footer\n")
        os.exit(0x10)
    end
    MsgP("DO Has avb info footer\n")
    if hasBoot then 
        if not copy_file(boot, BackBoot) then os.exit(false); end
        if not avb_erase_footer(boot) then os.exit(false); end
    end
    if hasRecovery then 
        if not copy_file(recovery, BackRecovery) then os.exit(false); end; 
        if not avb_erase_footer(recovery) then os.exit(false); end
    end
    if hasDtb then if not copy_file(dtb, BackDtb) then os.exit(false); end; end
    os.exit()
end -- local function avb_before_sign

local keyPath = arg[4]
local function avb_after_sign()
    local hasBackBoot, hasBackRecovery, hasBackDtb = file_exist(BackBoot), file_exist(BackRecovery), file_exist(BackDtb)
    if not hasBackBoot then
        os.exit(false)
    end
    if hasBackBoot then
        if not avb_add_hash_footer(boot, hasBackBoot, 'boot') then os.exit(false); end
        os.remove(BackBoot)
    end
    if hasBackRecovery then
        if not avb_add_hash_footer(recovery, hasBackRecovery, 'recovery') then os.exit(false); end
        os.remove(BackRecovery)
    end
    if not isOtaPkg then dtb = dtb .. '.encrypt' end
    if hasBackDtb then
        if not avb_add_hash_footer(dtb, 262144, 'dtb') then os.exit(false); end
        os.remove(BackDtb)
    end
    os.rename(vbmeta, BackVbmeta)
    local ret = avb_create_new_vbmeta{
        boot        = boot,
        recovery    = recovery,
        dtb         = dtb,
        keyPath     = keyPath,
        oldVbmeta   = BackVbmeta,
        output      = vbmeta,
    }
    if not avb_erase_footer(dtb) then os.exit(false); end
    os.remove(BackVbmeta)
    os.exit(ret == 0)
end -- local function avb_after_sign()

if 'check_avb' == subCmd then
--    MsgP("check_avb")
    local hasAvbFooter = hasBoot and has_avbfooter(boot) or has_avbfooter(recovery)
	MsgP("0x%x", hasAvbFooter and 0x20 or 0x10)
    os.exit(hasAvbFooter and 0x20 or 0x10)
end

if 'before_sign' == subCmd then
    avb_before_sign()
end

if 'after_sign' == subCmd then
    if not file_exist(keyPath) then 
        MsgP('file[%s] not exist\n', keyPath); os.exit(false); 
    end
    avb_after_sign()
end

