@echo off
SETLOCAL enabledelayedexpansion

set key_folder=%1
set RSA_key_bits=%2
set binDir=%~dp0
set tool_key_gen=%~dp0%3
set sub_key_folders=userkey,rootkey_1,rootkey_2,rootkey_3,rootkey_4
set RSA_Expoent=0x10001
set rootkeymax=%key_folder%/aml-rootkeymax.sig
set amlUserKey=%key_folder%/aml-user-key.sig
set amlEfusePatten=%key_folder%/SECURE_BOOT_SET

if "%key_folder%" == "" (
    echo "Must specify the key folder"
    goto EOF
)
if "%RSA_key_bits%" == "" (
    echo "RSA LEN not specified, set to default 1024"
    set RSA_key_bits=1024
)

if NOT "%RSA_key_bits%" == "1024" (
        if NOT "%RSA_key_bits%" == "2048" (
            echo "RSA LEN(%RSA_key_bits%) illegal, must be 2014 or 2048"
            goto EOF
        )
)
REM if exist %key_folder% (
    REM echo "Sorry[%key_folder% already existed], must specify a folder not existed"
    REM goto EOF
REM ) 
REM mkdir %key_folder%

::key gen
::IMPORTANT: the cmd rsagen can not do more times after you burned the EFUSE mirror to chip, otherwise you need a new GXL chip for new efuse burning again

echo ######Building %amlUserKey% for Amlogic Secure boot Start##### 

for %%i in (%sub_key_folders%) do (
        set the_sub_key_folder=%key_folder%%key_save_folder%\%%i
        if exist !the_sub_key_folder! (
            echo "folder !the_sub_key_folder! already existed"
            echo "Please clean new folder" 
            GOTO EOF
        )
        mkdir !the_sub_key_folder!
        if not exist !the_sub_key_folder! (
            echo "Fail to gen dir !the_sub_key_folder!"
            GOTO EOF
        )
        pushd !the_sub_key_folder!
            %tool_key_gen% --rsagen  --keylen %RSA_key_bits%   --exp %RSA_Expoent%  ^
                    --ned key.kxa --nex key.kxe --nxd key.kxd --txt key.txt --aes key.aes
        popd
        if NOT ERRORLEVEL 0 (                        
            echo "Fail in gen rsa key in folder ^(!the_sub_key_folder!^)"
            GOTO EOF
            )
        echo "OK in gen rsa key in folder ^(!the_sub_key_folder!^)"
)

::key signature
%tool_key_gen% --keysig ^
            --rkey1 %key_folder%/rootkey_1/key.kxe ^
            --rkey2 %key_folder%/rootkey_2/key.kxe ^
            --rkey3 %key_folder%/rootkey_3/key.kxe ^
            --rkey4 %key_folder%/rootkey_4/key.kxe ^
            --ukey1 %key_folder%/userkey/key.kxe           ^
            --skey  %key_folder%/rootkey_1/key.kxa ^
            --output %rootkeymax%
if not ERRORLEVEL 0 (
    echo "error occur when generate keymax"
    goto EOF
)
if not exist %rootkeymax% (
    echo "fail to generate keymax"
    goto EOF
)

::key binding
%tool_key_gen% --keybnd ^
        --ukey          %key_folder%/userkey/key.kxa ^
        --rootkeymax    %rootkeymax% ^
        --aeskey        %key_folder%/userkey/key.aes ^
        --output        %amluserkey%
if not ERRORLEVEL 0 (
    echo "error occur when generate amluserkey"
    goto EOF
)
if not exist %amluserkey% (
    echo "fail to generate amluserkey"
    goto EOF
)

::efuse generate
%tool_key_gen% --efsgen ^
                --amluserkey %amlUserKey% ^
                --output     %amlEfusePatten%
if not ERRORLEVEL 0 (
    echo "error occur when generate amlEfusePatten"
    goto EOF
)
if not exist %amlEfusePatten% (
    echo "fail to generate amlEfusePatten"
    goto EOF
)

echo ######Building amlUserKey and amlEfusePatten for Amlogic Secure boot OK##### 
exit 0
REM pause

:EOF
exit 1
REM pause

