/*
 * Decompiled with CFR 0.152.
 */
package com.android.verity;

import com.android.verity.Utils;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class VeritySigner {
    private static void usage() {
        System.err.println("usage: VeritySigner <contentfile> <key.pk8> <sigfile> | <contentfile> <certificate.x509.pem> <sigfile> -verify");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            VeritySigner.usage();
            return;
        }
        Security.addProvider(new BouncyCastleProvider());
        byte[] content = Utils.read(args[0]);
        if (args.length > 3 && "-verify".equals(args[3])) {
            X509Certificate cert = Utils.loadPEMCertificate(args[1]);
            PublicKey publicKey = cert.getPublicKey();
            byte[] signature = Utils.read(args[2]);
            try {
                if (Utils.verify(publicKey, content, signature, Utils.getSignatureAlgorithmIdentifier(publicKey))) {
                    System.err.println("Signature is VALID");
                    System.exit(0);
                } else {
                    System.err.println("Signature is INVALID");
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            System.exit(1);
        } else {
            PrivateKey privateKey = Utils.loadDERPrivateKey(Utils.read(args[1]));
            byte[] signature = Utils.sign(privateKey, content);
            Utils.write(signature, args[2]);
        }
    }
}

