/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt.ct;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.conscrypt.ct.SerializationException;

public class Serialization {
    private static final int DER_TAG_MASK = 63;
    private static final int DER_TAG_OCTET_STRING = 4;
    private static final int DER_LENGTH_LONG_FORM_FLAG = 128;

    private Serialization() {
    }

    public static byte[] readDEROctetString(byte[] byArray) throws SerializationException {
        return Serialization.readDEROctetString(new ByteArrayInputStream(byArray));
    }

    public static byte[] readDEROctetString(InputStream inputStream) throws SerializationException {
        int n = Serialization.readByte(inputStream) & 0x3F;
        if (n != 4) {
            throw new SerializationException("Wrong DER tag, expected OCTET STRING, got " + n);
        }
        int n2 = Serialization.readNumber(inputStream, 1);
        int n3 = (n2 & 0x80) != 0 ? Serialization.readNumber(inputStream, n2 & 0xFFFFFF7F) : n2;
        return Serialization.readFixedBytes(inputStream, n3);
    }

    public static byte[][] readList(byte[] byArray, int n, int n2) throws SerializationException {
        return Serialization.readList(new ByteArrayInputStream(byArray), n, n2);
    }

    public static byte[][] readList(InputStream inputStream, int n, int n2) throws SerializationException {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        byte[] byArray = Serialization.readVariableBytes(inputStream, n);
        inputStream = new ByteArrayInputStream(byArray);
        try {
            while (inputStream.available() > 0) {
                arrayList.add(Serialization.readVariableBytes(inputStream, n2));
            }
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
        return (byte[][])arrayList.toArray((T[])new byte[arrayList.size()][]);
    }

    public static byte[] readVariableBytes(InputStream inputStream, int n) throws SerializationException {
        int n2 = Serialization.readNumber(inputStream, n);
        return Serialization.readFixedBytes(inputStream, n2);
    }

    public static byte[] readFixedBytes(InputStream inputStream, int n) throws SerializationException {
        try {
            if (n < 0) {
                throw new SerializationException("Negative length: " + n);
            }
            byte[] byArray = new byte[n];
            int n2 = inputStream.read(byArray);
            if (n2 < n) {
                throw new SerializationException("Premature end of input, expected " + n + " bytes, only read " + n2);
            }
            return byArray;
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }

    public static int readNumber(InputStream inputStream, int n) throws SerializationException {
        if (n > 4 || n < 0) {
            throw new SerializationException("Invalid width: " + n);
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = n2 << 8 | Serialization.readByte(inputStream) & 0xFF;
        }
        return n2;
    }

    public static long readLong(InputStream inputStream, int n) throws SerializationException {
        if (n > 8 || n < 0) {
            throw new IllegalArgumentException("Invalid width: " + n);
        }
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            l = l << 8 | (long)(Serialization.readByte(inputStream) & 0xFF);
        }
        return l;
    }

    public static byte readByte(InputStream inputStream) throws SerializationException {
        try {
            int n = inputStream.read();
            if (n == -1) {
                throw new SerializationException("Premature end of input, could not read byte.");
            }
            return (byte)n;
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }

    public static void writeVariableBytes(OutputStream outputStream, byte[] byArray, int n) throws SerializationException {
        Serialization.writeNumber(outputStream, byArray.length, n);
        Serialization.writeFixedBytes(outputStream, byArray);
    }

    public static void writeFixedBytes(OutputStream outputStream, byte[] byArray) throws SerializationException {
        try {
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }

    public static void writeNumber(OutputStream outputStream, long l, int n) throws SerializationException {
        if (n < 0) {
            throw new SerializationException("Negative width: " + n);
        }
        if (n < 8 && l >= 1L << 8 * n) {
            throw new SerializationException("Number too large, " + l + " does not fit in " + n + " bytes");
        }
        try {
            while (n > 0) {
                long l2 = (long)(n - 1) * 8L;
                if (l2 < 64L) {
                    outputStream.write((byte)(l >> (int)l2 & 0xFFL));
                } else {
                    outputStream.write(0);
                }
                --n;
            }
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }
}

