/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt.ct;

import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.conscrypt.NativeCrypto;
import org.conscrypt.OpenSSLX509Certificate;
import org.conscrypt.ct.CTLogInfo;
import org.conscrypt.ct.CTLogStore;
import org.conscrypt.ct.CTVerificationResult;
import org.conscrypt.ct.CertificateEntry;
import org.conscrypt.ct.Serialization;
import org.conscrypt.ct.SerializationException;
import org.conscrypt.ct.SignedCertificateTimestamp;
import org.conscrypt.ct.VerifiedSCT;

public class CTVerifier {
    private final CTLogStore store;

    public CTVerifier(CTLogStore cTLogStore) {
        this.store = cTLogStore;
    }

    public CTVerificationResult verifySignedCertificateTimestamps(List<X509Certificate> list, byte[] byArray, byte[] byArray2) throws CertificateEncodingException {
        OpenSSLX509Certificate[] openSSLX509CertificateArray = new OpenSSLX509Certificate[list.size()];
        int n = 0;
        for (X509Certificate x509Certificate : list) {
            openSSLX509CertificateArray[n++] = OpenSSLX509Certificate.fromCertificate(x509Certificate);
        }
        return this.verifySignedCertificateTimestamps(openSSLX509CertificateArray, byArray, byArray2);
    }

    public CTVerificationResult verifySignedCertificateTimestamps(OpenSSLX509Certificate[] openSSLX509CertificateArray, byte[] byArray, byte[] byArray2) throws CertificateEncodingException {
        if (openSSLX509CertificateArray.length == 0) {
            throw new IllegalArgumentException("Chain of certificates mustn't be empty.");
        }
        OpenSSLX509Certificate openSSLX509Certificate = openSSLX509CertificateArray[0];
        CTVerificationResult cTVerificationResult = new CTVerificationResult();
        List<SignedCertificateTimestamp> list = this.getSCTsFromTLSExtension(byArray);
        this.verifyExternalSCTs(list, openSSLX509Certificate, cTVerificationResult);
        List<SignedCertificateTimestamp> list2 = this.getSCTsFromOCSPResponse(byArray2, openSSLX509CertificateArray);
        this.verifyExternalSCTs(list2, openSSLX509Certificate, cTVerificationResult);
        List<SignedCertificateTimestamp> list3 = this.getSCTsFromX509Extension(openSSLX509CertificateArray[0]);
        this.verifyEmbeddedSCTs(list3, openSSLX509CertificateArray, cTVerificationResult);
        return cTVerificationResult;
    }

    private void verifyEmbeddedSCTs(List<SignedCertificateTimestamp> list, OpenSSLX509Certificate[] openSSLX509CertificateArray, CTVerificationResult cTVerificationResult) {
        if (list.isEmpty()) {
            return;
        }
        CertificateEntry certificateEntry = null;
        if (openSSLX509CertificateArray.length >= 2) {
            OpenSSLX509Certificate openSSLX509Certificate = openSSLX509CertificateArray[0];
            OpenSSLX509Certificate object = openSSLX509CertificateArray[1];
            try {
                certificateEntry = CertificateEntry.createForPrecertificate(openSSLX509Certificate, object);
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        if (certificateEntry == null) {
            this.markSCTsAsInvalid(list, cTVerificationResult);
            return;
        }
        for (SignedCertificateTimestamp signedCertificateTimestamp : list) {
            VerifiedSCT.Status status = this.verifySingleSCT(signedCertificateTimestamp, certificateEntry);
            cTVerificationResult.add(new VerifiedSCT(signedCertificateTimestamp, status));
        }
    }

    private void verifyExternalSCTs(List<SignedCertificateTimestamp> list, OpenSSLX509Certificate openSSLX509Certificate, CTVerificationResult cTVerificationResult) {
        CertificateEntry certificateEntry;
        if (list.isEmpty()) {
            return;
        }
        try {
            certificateEntry = CertificateEntry.createForX509Certificate(openSSLX509Certificate);
        }
        catch (CertificateException certificateException) {
            this.markSCTsAsInvalid(list, cTVerificationResult);
            return;
        }
        for (SignedCertificateTimestamp signedCertificateTimestamp : list) {
            VerifiedSCT.Status status = this.verifySingleSCT(signedCertificateTimestamp, certificateEntry);
            cTVerificationResult.add(new VerifiedSCT(signedCertificateTimestamp, status));
        }
    }

    private VerifiedSCT.Status verifySingleSCT(SignedCertificateTimestamp signedCertificateTimestamp, CertificateEntry certificateEntry) {
        CTLogInfo cTLogInfo = this.store.getKnownLog(signedCertificateTimestamp.getLogID());
        if (cTLogInfo == null) {
            return VerifiedSCT.Status.UNKNOWN_LOG;
        }
        return cTLogInfo.verifySingleSCT(signedCertificateTimestamp, certificateEntry);
    }

    private void markSCTsAsInvalid(List<SignedCertificateTimestamp> list, CTVerificationResult cTVerificationResult) {
        for (SignedCertificateTimestamp signedCertificateTimestamp : list) {
            cTVerificationResult.add(new VerifiedSCT(signedCertificateTimestamp, VerifiedSCT.Status.INVALID_SCT));
        }
    }

    private List<SignedCertificateTimestamp> getSCTsFromSCTList(byte[] byArray, SignedCertificateTimestamp.Origin origin) {
        byte[][] byArray2;
        if (byArray == null) {
            return Collections.emptyList();
        }
        try {
            byArray2 = Serialization.readList(byArray, 2, 2);
        }
        catch (SerializationException serializationException) {
            return Collections.emptyList();
        }
        ArrayList<SignedCertificateTimestamp> arrayList = new ArrayList<SignedCertificateTimestamp>();
        for (byte[] byArray3 : byArray2) {
            try {
                SignedCertificateTimestamp signedCertificateTimestamp = SignedCertificateTimestamp.decode(byArray3, origin);
                arrayList.add(signedCertificateTimestamp);
            }
            catch (SerializationException serializationException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    private List<SignedCertificateTimestamp> getSCTsFromTLSExtension(byte[] byArray) {
        return this.getSCTsFromSCTList(byArray, SignedCertificateTimestamp.Origin.TLS_EXTENSION);
    }

    private List<SignedCertificateTimestamp> getSCTsFromOCSPResponse(byte[] byArray, OpenSSLX509Certificate[] openSSLX509CertificateArray) {
        if (byArray == null || openSSLX509CertificateArray.length < 2) {
            return Collections.emptyList();
        }
        byte[] byArray2 = NativeCrypto.get_ocsp_single_extension(byArray, "1.3.6.1.4.1.11129.2.4.5", openSSLX509CertificateArray[0].getContext(), openSSLX509CertificateArray[0], openSSLX509CertificateArray[1].getContext(), openSSLX509CertificateArray[1]);
        if (byArray2 == null) {
            return Collections.emptyList();
        }
        try {
            return this.getSCTsFromSCTList(Serialization.readDEROctetString(Serialization.readDEROctetString(byArray2)), SignedCertificateTimestamp.Origin.OCSP_RESPONSE);
        }
        catch (SerializationException serializationException) {
            return Collections.emptyList();
        }
    }

    private List<SignedCertificateTimestamp> getSCTsFromX509Extension(OpenSSLX509Certificate openSSLX509Certificate) {
        byte[] byArray = openSSLX509Certificate.getExtensionValue("1.3.6.1.4.1.11129.2.4.2");
        if (byArray == null) {
            return Collections.emptyList();
        }
        try {
            return this.getSCTsFromSCTList(Serialization.readDEROctetString(Serialization.readDEROctetString(byArray)), SignedCertificateTimestamp.Origin.EMBEDDED);
        }
        catch (SerializationException serializationException) {
            return Collections.emptyList();
        }
    }
}

