/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.security.PublicKey;
import java.util.Arrays;

final class X509PublicKey
implements PublicKey {
    private static final long serialVersionUID = -8610156854731664298L;
    private final String algorithm;
    private final byte[] encoded;

    X509PublicKey(String string, byte[] byArray) {
        this.algorithm = string;
        this.encoded = byArray;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        return this.encoded;
    }

    public String toString() {
        return "X509PublicKey [algorithm=" + this.algorithm + ", encoded=" + Arrays.toString(this.encoded) + "]";
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.algorithm == null ? 0 : this.algorithm.hashCode());
        n = 31 * n + Arrays.hashCode(this.encoded);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        X509PublicKey x509PublicKey = (X509PublicKey)object;
        if (this.algorithm == null ? x509PublicKey.algorithm != null : !this.algorithm.equals(x509PublicKey.algorithm)) {
            return false;
        }
        return Arrays.equals(this.encoded, x509PublicKey.encoded);
    }
}

