/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXParameters;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedTrustManager;
import org.conscrypt.CertBlacklist;
import org.conscrypt.CertPinManager;
import org.conscrypt.CertificatePriorityComparator;
import org.conscrypt.ChainStrengthAnalyzer;
import org.conscrypt.ConscryptCertStore;
import org.conscrypt.ConscryptHostnameVerifier;
import org.conscrypt.ConscryptSession;
import org.conscrypt.Platform;
import org.conscrypt.TrustedCertificateIndex;
import org.conscrypt.ct.CTLogStore;
import org.conscrypt.ct.CTPolicy;
import org.conscrypt.ct.CTVerificationResult;
import org.conscrypt.ct.CTVerifier;

public final class TrustManagerImpl
extends X509ExtendedTrustManager {
    private static final Logger logger = Logger.getLogger(TrustManagerImpl.class.getName());
    private static final TrustAnchorComparator TRUST_ANCHOR_COMPARATOR = new TrustAnchorComparator();
    private static ConscryptHostnameVerifier defaultHostnameVerifier;
    private final KeyStore rootKeyStore;
    private CertPinManager pinManager;
    private final ConscryptCertStore trustedCertificateStore;
    private final CertPathValidator validator;
    private final TrustedCertificateIndex trustedCertificateIndex;
    private final TrustedCertificateIndex intermediateIndex;
    private final X509Certificate[] acceptedIssuers;
    private final Exception err;
    private final CertificateFactory factory;
    private final CertBlacklist blacklist;
    private CTVerifier ctVerifier;
    private CTPolicy ctPolicy;
    private ConscryptHostnameVerifier hostnameVerifier;
    private boolean ctEnabledOverride;

    public TrustManagerImpl(KeyStore keyStore) {
        this(keyStore, null);
    }

    public TrustManagerImpl(KeyStore keyStore, CertPinManager certPinManager) {
        this(keyStore, certPinManager, null);
    }

    public TrustManagerImpl(KeyStore keyStore, CertPinManager certPinManager, ConscryptCertStore conscryptCertStore) {
        this(keyStore, certPinManager, conscryptCertStore, null);
    }

    public TrustManagerImpl(KeyStore keyStore, CertPinManager certPinManager, ConscryptCertStore conscryptCertStore, CertBlacklist certBlacklist) {
        this(keyStore, certPinManager, conscryptCertStore, certBlacklist, null, null, null);
    }

    public TrustManagerImpl(KeyStore keyStore, CertPinManager certPinManager, ConscryptCertStore conscryptCertStore, CertBlacklist certBlacklist, CTLogStore cTLogStore, CTVerifier cTVerifier, CTPolicy cTPolicy) {
        CertPathValidator certPathValidator = null;
        CertificateFactory certificateFactory = null;
        KeyStore keyStore2 = null;
        ConscryptCertStore conscryptCertStore2 = null;
        TrustedCertificateIndex trustedCertificateIndex = null;
        X509Certificate[] x509CertificateArray = null;
        Exception exception = null;
        try {
            certPathValidator = CertPathValidator.getInstance("PKIX");
            certificateFactory = CertificateFactory.getInstance("X509");
            if ("AndroidCAStore".equals(keyStore.getType()) && Platform.supportsConscryptCertStore()) {
                keyStore2 = keyStore;
                conscryptCertStore2 = conscryptCertStore != null ? conscryptCertStore : Platform.newDefaultCertStore();
                x509CertificateArray = null;
                trustedCertificateIndex = new TrustedCertificateIndex();
            } else {
                keyStore2 = null;
                conscryptCertStore2 = conscryptCertStore;
                x509CertificateArray = TrustManagerImpl.acceptedIssuers(keyStore);
                trustedCertificateIndex = new TrustedCertificateIndex(TrustManagerImpl.trustAnchors(x509CertificateArray));
            }
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if (certBlacklist == null) {
            certBlacklist = Platform.newDefaultBlacklist();
        }
        if (cTLogStore == null) {
            cTLogStore = Platform.newDefaultLogStore();
        }
        if (cTPolicy == null) {
            cTPolicy = Platform.newDefaultPolicy(cTLogStore);
        }
        this.pinManager = certPinManager;
        this.rootKeyStore = keyStore2;
        this.trustedCertificateStore = conscryptCertStore2;
        this.validator = certPathValidator;
        this.factory = certificateFactory;
        this.trustedCertificateIndex = trustedCertificateIndex;
        this.intermediateIndex = new TrustedCertificateIndex();
        this.acceptedIssuers = x509CertificateArray;
        this.err = exception;
        this.blacklist = certBlacklist;
        this.ctVerifier = new CTVerifier(cTLogStore);
        this.ctPolicy = cTPolicy;
    }

    private static X509Certificate[] acceptedIssuers(KeyStore keyStore) {
        try {
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
                if (x509Certificate == null) continue;
                arrayList.add(x509Certificate);
            }
            return arrayList.toArray(new X509Certificate[arrayList.size()]);
        }
        catch (KeyStoreException keyStoreException) {
            return new X509Certificate[0];
        }
    }

    private static Set<TrustAnchor> trustAnchors(X509Certificate[] x509CertificateArray) {
        HashSet<TrustAnchor> hashSet = new HashSet<TrustAnchor>(x509CertificateArray.length);
        for (X509Certificate x509Certificate : x509CertificateArray) {
            hashSet.add(new TrustAnchor(x509Certificate, null));
        }
        return hashSet;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, null, null, true);
    }

    public List<X509Certificate> checkClientTrusted(X509Certificate[] x509CertificateArray, String string, String string2) throws CertificateException {
        return this.checkTrusted(x509CertificateArray, null, null, string, string2, true);
    }

    private static SSLSession getHandshakeSessionOrThrow(SSLSocket sSLSocket) throws CertificateException {
        SSLSession sSLSession = sSLSocket.getHandshakeSession();
        if (sSLSession == null) {
            throw new CertificateException("Not in handshake; no session available");
        }
        return sSLSession;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        SSLSession sSLSession = null;
        SSLParameters sSLParameters = null;
        if (socket instanceof SSLSocket) {
            SSLSocket sSLSocket = (SSLSocket)socket;
            sSLSession = TrustManagerImpl.getHandshakeSessionOrThrow(sSLSocket);
            sSLParameters = sSLSocket.getSSLParameters();
        }
        this.checkTrusted(x509CertificateArray, string, sSLSession, sSLParameters, true);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        SSLSession sSLSession = sSLEngine.getHandshakeSession();
        if (sSLSession == null) {
            throw new CertificateException("Not in handshake; no session available");
        }
        this.checkTrusted(x509CertificateArray, string, sSLSession, sSLEngine.getSSLParameters(), true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, null, null, false);
    }

    public List<X509Certificate> checkServerTrusted(X509Certificate[] x509CertificateArray, String string, String string2) throws CertificateException {
        return this.checkTrusted(x509CertificateArray, null, null, string, string2, false);
    }

    public List<X509Certificate> getTrustedChainForServer(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        SSLSession sSLSession = null;
        SSLParameters sSLParameters = null;
        if (socket instanceof SSLSocket) {
            SSLSocket sSLSocket = (SSLSocket)socket;
            sSLSession = TrustManagerImpl.getHandshakeSessionOrThrow(sSLSocket);
            sSLParameters = sSLSocket.getSSLParameters();
        }
        return this.checkTrusted(x509CertificateArray, string, sSLSession, sSLParameters, false);
    }

    public List<X509Certificate> getTrustedChainForServer(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        SSLSession sSLSession = sSLEngine.getHandshakeSession();
        if (sSLSession == null) {
            throw new CertificateException("Not in handshake; no session available");
        }
        return this.checkTrusted(x509CertificateArray, string, sSLSession, sSLEngine.getSSLParameters(), false);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        this.getTrustedChainForServer(x509CertificateArray, string, socket);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        this.getTrustedChainForServer(x509CertificateArray, string, sSLEngine);
    }

    public List<X509Certificate> checkServerTrusted(X509Certificate[] x509CertificateArray, String string, SSLSession sSLSession) throws CertificateException {
        return this.checkTrusted(x509CertificateArray, string, sSLSession, null, false);
    }

    public void handleTrustStorageUpdate() {
        if (this.acceptedIssuers == null) {
            this.trustedCertificateIndex.reset();
        } else {
            this.trustedCertificateIndex.reset(TrustManagerImpl.trustAnchors(this.acceptedIssuers));
        }
    }

    private List<X509Certificate> checkTrusted(X509Certificate[] x509CertificateArray, String string, SSLSession sSLSession, SSLParameters sSLParameters, boolean bl) throws CertificateException {
        ConscryptHostnameVerifier conscryptHostnameVerifier;
        String string2;
        byte[] byArray = null;
        byte[] byArray2 = null;
        String string3 = null;
        if (sSLSession != null) {
            string3 = sSLSession.getPeerHost();
            byArray = this.getOcspDataFromSession(sSLSession);
            byArray2 = this.getTlsSctDataFromSession(sSLSession);
        }
        if (sSLSession != null && sSLParameters != null && "HTTPS".equalsIgnoreCase(string2 = sSLParameters.getEndpointIdentificationAlgorithm()) && !(conscryptHostnameVerifier = this.getHttpsVerifier()).verify(string3, sSLSession)) {
            throw new CertificateException("No subjectAltNames on the certificate match");
        }
        return this.checkTrusted(x509CertificateArray, byArray, byArray2, string, string3, bl);
    }

    private byte[] getOcspDataFromSession(SSLSession sSLSession) {
        List list = null;
        if (sSLSession instanceof ConscryptSession) {
            ConscryptSession conscryptSession = (ConscryptSession)sSLSession;
            list = conscryptSession.getStatusResponses();
        } else {
            try {
                Method method = sSLSession.getClass().getDeclaredMethod("getStatusResponses", new Class[0]);
                method.setAccessible(true);
                Object object = method.invoke((Object)sSLSession, new Object[0]);
                if (object instanceof List) {
                    list = (List)object;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException.getCause());
            }
        }
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    private byte[] getTlsSctDataFromSession(SSLSession sSLSession) {
        if (sSLSession instanceof ConscryptSession) {
            ConscryptSession conscryptSession = (ConscryptSession)sSLSession;
            return conscryptSession.getPeerSignedCertificateTimestamp();
        }
        byte[] byArray = null;
        try {
            Method method = sSLSession.getClass().getDeclaredMethod("getPeerSignedCertificateTimestamp", new Class[0]);
            method.setAccessible(true);
            Object object = method.invoke((Object)sSLSession, new Object[0]);
            if (object instanceof byte[]) {
                byArray = (byte[])object;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException.getCause());
        }
        return byArray;
    }

    private List<X509Certificate> checkTrusted(X509Certificate[] x509CertificateArray, byte[] byArray, byte[] byArray2, String string, String string2, boolean bl) throws CertificateException {
        if (x509CertificateArray == null || x509CertificateArray.length == 0 || string == null || string.length() == 0) {
            throw new IllegalArgumentException("null or zero-length parameter");
        }
        if (this.err != null) {
            throw new CertificateException(this.err);
        }
        HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>();
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        ArrayList<TrustAnchor> arrayList2 = new ArrayList<TrustAnchor>();
        X509Certificate x509Certificate = x509CertificateArray[0];
        TrustAnchor trustAnchor = this.findTrustAnchorBySubjectAndPublicKey(x509Certificate);
        if (trustAnchor != null) {
            arrayList2.add(trustAnchor);
            hashSet.add(trustAnchor.getTrustedCert());
        } else {
            arrayList.add(x509Certificate);
        }
        hashSet.add(x509Certificate);
        return this.checkTrustedRecursive(x509CertificateArray, byArray, byArray2, string2, bl, arrayList, arrayList2, hashSet);
    }

    private List<X509Certificate> checkTrustedRecursive(X509Certificate[] x509CertificateArray, byte[] byArray, byte[] byArray2, String string, boolean bl, ArrayList<X509Certificate> arrayList, ArrayList<TrustAnchor> arrayList2, Set<X509Certificate> set) throws CertificateException {
        CertificateException certificateException = null;
        X509Certificate x509Certificate = arrayList2.isEmpty() ? arrayList.get(arrayList.size() - 1) : arrayList2.get(arrayList2.size() - 1).getTrustedCert();
        this.checkBlacklist(x509Certificate);
        if (x509Certificate.getIssuerDN().equals(x509Certificate.getSubjectDN())) {
            return this.verifyChain(arrayList, arrayList2, string, bl, byArray, byArray2);
        }
        Set<TrustAnchor> set2 = this.findAllTrustAnchorsByIssuerAndSignature(x509Certificate);
        boolean bl2 = false;
        for (TrustAnchor object2 : TrustManagerImpl.sortPotentialAnchors(set2)) {
            X509Certificate x509Certificate2 = object2.getTrustedCert();
            if (set.contains(x509Certificate2)) continue;
            bl2 = true;
            set.add(x509Certificate2);
            arrayList2.add(object2);
            try {
                return this.checkTrustedRecursive(x509CertificateArray, byArray, byArray2, string, bl, arrayList, arrayList2, set);
            }
            catch (CertificateException certificateException2) {
                certificateException = certificateException2;
                arrayList2.remove(arrayList2.size() - 1);
                set.remove(x509Certificate2);
            }
        }
        if (!arrayList2.isEmpty()) {
            if (!bl2) {
                return this.verifyChain(arrayList, arrayList2, string, bl, byArray, byArray2);
            }
            throw certificateException;
        }
        for (int i = 1; i < x509CertificateArray.length; ++i) {
            X509Certificate x509Certificate3 = x509CertificateArray[i];
            if (set.contains(x509Certificate3) || !x509Certificate.getIssuerDN().equals(x509Certificate3.getSubjectDN())) continue;
            try {
                x509Certificate3.checkValidity();
                ChainStrengthAnalyzer.checkCert(x509Certificate3);
            }
            catch (CertificateException certificateException3) {
                certificateException = new CertificateException("Unacceptable certificate: " + x509Certificate3.getSubjectX500Principal(), certificateException3);
                continue;
            }
            set.add(x509Certificate3);
            arrayList.add(x509Certificate3);
            try {
                return this.checkTrustedRecursive(x509CertificateArray, byArray, byArray2, string, bl, arrayList, arrayList2, set);
            }
            catch (CertificateException certificateException4) {
                certificateException = certificateException4;
                set.remove(x509Certificate3);
                arrayList.remove(arrayList.size() - 1);
            }
        }
        Set<TrustAnchor> set3 = this.intermediateIndex.findAllByIssuerAndSignature(x509Certificate);
        for (TrustAnchor trustAnchor : TrustManagerImpl.sortPotentialAnchors(set3)) {
            X509Certificate x509Certificate4 = trustAnchor.getTrustedCert();
            if (set.contains(x509Certificate4)) continue;
            set.add(x509Certificate4);
            arrayList.add(x509Certificate4);
            try {
                return this.checkTrustedRecursive(x509CertificateArray, byArray, byArray2, string, bl, arrayList, arrayList2, set);
            }
            catch (CertificateException certificateException5) {
                certificateException = certificateException5;
                arrayList.remove(arrayList.size() - 1);
                set.remove(x509Certificate4);
            }
        }
        if (certificateException != null) {
            throw certificateException;
        }
        CertPath certPath = this.factory.generateCertPath(arrayList);
        throw new CertificateException(new CertPathValidatorException("Trust anchor for certification path not found.", null, certPath, -1));
    }

    private List<X509Certificate> verifyChain(List<X509Certificate> list, List<TrustAnchor> list2, String string, boolean bl, byte[] byArray, byte[] byArray2) throws CertificateException {
        try {
            CertPath certPath = this.factory.generateCertPath(list);
            if (list2.isEmpty()) {
                throw new CertificateException(new CertPathValidatorException("Trust anchor for certification path not found.", null, certPath, -1));
            }
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            arrayList.addAll(list);
            for (TrustAnchor object : list2) {
                arrayList.add(object.getTrustedCert());
            }
            if (this.pinManager != null) {
                this.pinManager.checkChainPinning(string, arrayList);
            }
            for (X509Certificate x509Certificate : arrayList) {
                this.checkBlacklist(x509Certificate);
            }
            if (!bl && (this.ctEnabledOverride || string != null && Platform.isCTVerificationRequired(string))) {
                this.checkCT(string, arrayList, byArray, byArray2);
            }
            if (list.isEmpty()) {
                return arrayList;
            }
            ChainStrengthAnalyzer.check(list);
            try {
                HashSet hashSet = new HashSet();
                hashSet.add(list2.get(0));
                PKIXParameters pKIXParameters = new PKIXParameters(hashSet);
                pKIXParameters.setRevocationEnabled(false);
                X509Certificate x509Certificate = list.get(0);
                this.setOcspResponses(pKIXParameters, x509Certificate, byArray);
                pKIXParameters.addCertPathChecker(new ExtendedKeyUsagePKIXCertPathChecker(bl, x509Certificate));
                this.validator.validate(certPath, pKIXParameters);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new CertificateException("Chain validation failed", invalidAlgorithmParameterException);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new CertificateException("Chain validation failed", certPathValidatorException);
            }
            for (int i = 1; i < list.size(); ++i) {
                this.intermediateIndex.index(list.get(i));
            }
            return arrayList;
        }
        catch (CertificateException certificateException) {
            logger.fine("Rejected candidate cert chain due to error: " + certificateException.getMessage());
            throw certificateException;
        }
    }

    private void checkBlacklist(X509Certificate x509Certificate) throws CertificateException {
        if (this.blacklist != null && this.blacklist.isPublicKeyBlackListed(x509Certificate.getPublicKey())) {
            throw new CertificateException("Certificate blacklisted by public key: " + x509Certificate);
        }
    }

    private void checkCT(String string, List<X509Certificate> list, byte[] byArray, byte[] byArray2) throws CertificateException {
        CTVerificationResult cTVerificationResult = this.ctVerifier.verifySignedCertificateTimestamps(list, byArray2, byArray);
        if (!this.ctPolicy.doesResultConformToPolicy(cTVerificationResult, string, list.toArray(new X509Certificate[list.size()]))) {
            throw new CertificateException("Certificate chain does not conform to required transparency policy.");
        }
    }

    private void setOcspResponses(PKIXParameters pKIXParameters, X509Certificate x509Certificate, byte[] byArray) {
        if (byArray == null) {
            return;
        }
        PKIXRevocationChecker pKIXRevocationChecker = null;
        ArrayList<PKIXCertPathChecker> arrayList = new ArrayList<PKIXCertPathChecker>(pKIXParameters.getCertPathCheckers());
        for (PKIXCertPathChecker pKIXCertPathChecker : arrayList) {
            if (!(pKIXCertPathChecker instanceof PKIXRevocationChecker)) continue;
            pKIXRevocationChecker = (PKIXRevocationChecker)pKIXCertPathChecker;
            break;
        }
        if (pKIXRevocationChecker == null) {
            try {
                pKIXRevocationChecker = (PKIXRevocationChecker)this.validator.getRevocationChecker();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                return;
            }
            arrayList.add(pKIXRevocationChecker);
            pKIXRevocationChecker.setOptions(Collections.singleton(PKIXRevocationChecker.Option.ONLY_END_ENTITY));
        }
        pKIXRevocationChecker.setOcspResponses(Collections.singletonMap(x509Certificate, byArray));
        pKIXParameters.setCertPathCheckers(arrayList);
    }

    private static Collection<TrustAnchor> sortPotentialAnchors(Set<TrustAnchor> set) {
        if (set.size() <= 1) {
            return set;
        }
        ArrayList<TrustAnchor> arrayList = new ArrayList<TrustAnchor>(set);
        Collections.sort(arrayList, TRUST_ANCHOR_COMPARATOR);
        return arrayList;
    }

    private Set<TrustAnchor> findAllTrustAnchorsByIssuerAndSignature(X509Certificate x509Certificate) {
        Set<TrustAnchor> set = this.trustedCertificateIndex.findAllByIssuerAndSignature(x509Certificate);
        if (!set.isEmpty() || this.trustedCertificateStore == null) {
            return set;
        }
        Set<X509Certificate> set2 = this.trustedCertificateStore.findAllIssuers(x509Certificate);
        if (set2.isEmpty()) {
            return set;
        }
        HashSet<TrustAnchor> hashSet = new HashSet<TrustAnchor>(set2.size());
        for (X509Certificate x509Certificate2 : set2) {
            hashSet.add(this.trustedCertificateIndex.index(x509Certificate2));
        }
        return hashSet;
    }

    private TrustAnchor findTrustAnchorBySubjectAndPublicKey(X509Certificate x509Certificate) {
        TrustAnchor trustAnchor = this.trustedCertificateIndex.findBySubjectAndPublicKey(x509Certificate);
        if (trustAnchor != null) {
            return trustAnchor;
        }
        if (this.trustedCertificateStore == null) {
            return null;
        }
        X509Certificate x509Certificate2 = this.trustedCertificateStore.getTrustAnchor(x509Certificate);
        if (x509Certificate2 != null) {
            return new TrustAnchor(x509Certificate2, null);
        }
        return null;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.acceptedIssuers != null ? (X509Certificate[])this.acceptedIssuers.clone() : TrustManagerImpl.acceptedIssuers(this.rootKeyStore);
    }

    static synchronized void setDefaultHostnameVerifier(ConscryptHostnameVerifier conscryptHostnameVerifier) {
        defaultHostnameVerifier = conscryptHostnameVerifier;
    }

    static synchronized ConscryptHostnameVerifier getDefaultHostnameVerifier() {
        return defaultHostnameVerifier;
    }

    void setHostnameVerifier(ConscryptHostnameVerifier conscryptHostnameVerifier) {
        this.hostnameVerifier = conscryptHostnameVerifier;
    }

    ConscryptHostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    private ConscryptHostnameVerifier getHttpsVerifier() {
        if (this.hostnameVerifier != null) {
            return this.hostnameVerifier;
        }
        ConscryptHostnameVerifier conscryptHostnameVerifier = TrustManagerImpl.getDefaultHostnameVerifier();
        if (conscryptHostnameVerifier != null) {
            return conscryptHostnameVerifier;
        }
        return GlobalHostnameVerifierAdapter.INSTANCE;
    }

    public void setCTEnabledOverride(boolean bl) {
        this.ctEnabledOverride = bl;
    }

    public void setCTVerifier(CTVerifier cTVerifier) {
        this.ctVerifier = cTVerifier;
    }

    public void setCTPolicy(CTPolicy cTPolicy) {
        this.ctPolicy = cTPolicy;
    }

    private static enum GlobalHostnameVerifierAdapter implements ConscryptHostnameVerifier
    {
        INSTANCE;


        @Override
        public boolean verify(String string, SSLSession sSLSession) {
            return HttpsURLConnection.getDefaultHostnameVerifier().verify(string, sSLSession);
        }
    }

    private static class ExtendedKeyUsagePKIXCertPathChecker
    extends PKIXCertPathChecker {
        private static final String EKU_OID = "2.5.29.37";
        private static final String EKU_anyExtendedKeyUsage = "2.5.29.37.0";
        private static final String EKU_clientAuth = "1.3.6.1.5.5.7.3.2";
        private static final String EKU_serverAuth = "1.3.6.1.5.5.7.3.1";
        private static final String EKU_nsSGC = "2.16.840.1.113730.4.1";
        private static final String EKU_msSGC = "1.3.6.1.4.1.311.10.3.3";
        private static final Set<String> SUPPORTED_EXTENSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("2.5.29.37")));
        private final boolean clientAuth;
        private final X509Certificate leaf;

        private ExtendedKeyUsagePKIXCertPathChecker(boolean bl, X509Certificate x509Certificate) {
            this.clientAuth = bl;
            this.leaf = x509Certificate;
        }

        @Override
        public void init(boolean bl) throws CertPathValidatorException {
        }

        @Override
        public boolean isForwardCheckingSupported() {
            return true;
        }

        @Override
        public Set<String> getSupportedExtensions() {
            return SUPPORTED_EXTENSIONS;
        }

        @Override
        public void check(Certificate certificate, Collection<String> collection) throws CertPathValidatorException {
            List<String> list;
            if (certificate != this.leaf) {
                return;
            }
            try {
                list = this.leaf.getExtendedKeyUsage();
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new CertPathValidatorException(certificateParsingException);
            }
            if (list == null) {
                return;
            }
            boolean bl = false;
            for (String string : list) {
                if (string.equals(EKU_anyExtendedKeyUsage)) {
                    bl = true;
                    break;
                }
                if (this.clientAuth) {
                    if (!string.equals(EKU_clientAuth)) continue;
                    bl = true;
                    break;
                }
                if (string.equals(EKU_serverAuth)) {
                    bl = true;
                    break;
                }
                if (string.equals(EKU_nsSGC)) {
                    bl = true;
                    break;
                }
                if (!string.equals(EKU_msSGC)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new CertPathValidatorException("End-entity certificate does not have a valid extendedKeyUsage.");
            }
            collection.remove(EKU_OID);
        }
    }

    private static class TrustAnchorComparator
    implements Comparator<TrustAnchor> {
        private static final CertificatePriorityComparator CERT_COMPARATOR = new CertificatePriorityComparator();

        private TrustAnchorComparator() {
        }

        @Override
        public int compare(TrustAnchor trustAnchor, TrustAnchor trustAnchor2) {
            X509Certificate x509Certificate = trustAnchor.getTrustedCert();
            X509Certificate x509Certificate2 = trustAnchor2.getTrustedCert();
            return CERT_COMPARATOR.compare(x509Certificate, x509Certificate2);
        }
    }
}

