/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import org.conscrypt.AbstractSessionContext;
import org.conscrypt.NativeCrypto;
import org.conscrypt.NativeSslSession;
import org.conscrypt.SSLServerSessionCache;

public final class ServerSessionContext
extends AbstractSessionContext {
    private SSLServerSessionCache persistentCache;

    ServerSessionContext() {
        super(100);
        NativeCrypto.SSL_CTX_set_session_id_context(this.sslCtxNativePointer, this, new byte[]{32});
    }

    public void setPersistentCache(SSLServerSessionCache sSLServerSessionCache) {
        this.persistentCache = sSLServerSessionCache;
    }

    @Override
    NativeSslSession getSessionFromPersistentCache(byte[] byArray) {
        NativeSslSession nativeSslSession;
        byte[] byArray2;
        if (this.persistentCache != null && (byArray2 = this.persistentCache.getSessionData(byArray)) != null && (nativeSslSession = NativeSslSession.newInstance(this, byArray2, null, -1)) != null && nativeSslSession.isValid()) {
            this.cacheSession(nativeSslSession);
            return nativeSslSession;
        }
        return null;
    }

    @Override
    void onBeforeAddSession(NativeSslSession nativeSslSession) {
        byte[] byArray;
        if (this.persistentCache != null && (byArray = nativeSslSession.toBytes()) != null) {
            this.persistentCache.putSessionData(nativeSslSession.toSSLSession(), byArray);
        }
    }

    @Override
    void onBeforeRemoveSession(NativeSslSession nativeSslSession) {
    }
}

