/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509CRLEntry;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.conscrypt.NativeCrypto;
import org.conscrypt.OpenSSLX509CRL;
import org.conscrypt.OpenSSLX509CertificateFactory;

final class OpenSSLX509CRLEntry
extends X509CRLEntry {
    private final long mContext;
    private final Date revocationDate;

    OpenSSLX509CRLEntry(long l) throws OpenSSLX509CertificateFactory.ParsingException {
        this.mContext = l;
        this.revocationDate = OpenSSLX509CRL.toDate(NativeCrypto.get_X509_REVOKED_revocationDate(this.mContext));
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        String[] stringArray = NativeCrypto.get_X509_REVOKED_ext_oids(this.mContext, 1);
        if (stringArray.length == 0 && NativeCrypto.get_X509_REVOKED_ext_oids(this.mContext, 0).length == 0) {
            return null;
        }
        return new HashSet<String>(Arrays.asList(stringArray));
    }

    @Override
    public byte[] getExtensionValue(String string) {
        return NativeCrypto.X509_REVOKED_get_ext_oid(this.mContext, string);
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        String[] stringArray = NativeCrypto.get_X509_REVOKED_ext_oids(this.mContext, 0);
        if (stringArray.length == 0 && NativeCrypto.get_X509_REVOKED_ext_oids(this.mContext, 1).length == 0) {
            return null;
        }
        return new HashSet<String>(Arrays.asList(stringArray));
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        String[] stringArray;
        for (String string : stringArray = NativeCrypto.get_X509_REVOKED_ext_oids(this.mContext, 1)) {
            long l = NativeCrypto.X509_REVOKED_get_ext(this.mContext, string);
            if (NativeCrypto.X509_supported_extension(l) == 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte[] getEncoded() throws CRLException {
        return NativeCrypto.i2d_X509_REVOKED(this.mContext);
    }

    @Override
    public BigInteger getSerialNumber() {
        return new BigInteger(NativeCrypto.X509_REVOKED_get_serialNumber(this.mContext));
    }

    @Override
    public Date getRevocationDate() {
        return (Date)this.revocationDate.clone();
    }

    @Override
    public boolean hasExtensions() {
        return NativeCrypto.get_X509_REVOKED_ext_oids(this.mContext, 0).length != 0 || NativeCrypto.get_X509_REVOKED_ext_oids(this.mContext, 1).length != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        long l = NativeCrypto.create_BIO_OutputStream(byteArrayOutputStream);
        try {
            NativeCrypto.X509_REVOKED_print(l, this.mContext);
            String string = byteArrayOutputStream.toString();
            return string;
        }
        finally {
            NativeCrypto.BIO_free_all(l);
        }
    }
}

