/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import org.conscrypt.NativeCrypto;
import org.conscrypt.OpenSSLKey;
import org.conscrypt.OpenSSLRSAPrivateKey;
import org.conscrypt.OpenSSLRSAPublicKey;

public final class OpenSSLRSAKeyPairGenerator
extends KeyPairGeneratorSpi {
    private byte[] publicExponent = new byte[]{1, 0, 1};
    private int modulusBits = 2048;

    @Override
    public KeyPair generateKeyPair() {
        OpenSSLKey openSSLKey = new OpenSSLKey(NativeCrypto.RSA_generate_key_ex(this.modulusBits, this.publicExponent));
        OpenSSLRSAPrivateKey openSSLRSAPrivateKey = OpenSSLRSAPrivateKey.getInstance(openSSLKey);
        OpenSSLRSAPublicKey openSSLRSAPublicKey = new OpenSSLRSAPublicKey(openSSLKey);
        return new KeyPair(openSSLRSAPublicKey, openSSLRSAPrivateKey);
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        this.modulusBits = n;
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof RSAKeyGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Only RSAKeyGenParameterSpec supported");
        }
        RSAKeyGenParameterSpec rSAKeyGenParameterSpec = (RSAKeyGenParameterSpec)algorithmParameterSpec;
        BigInteger bigInteger = rSAKeyGenParameterSpec.getPublicExponent();
        if (bigInteger != null) {
            this.publicExponent = bigInteger.toByteArray();
        }
        this.modulusBits = rSAKeyGenParameterSpec.getKeysize();
    }
}

