/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.conscrypt.NativeCrypto;
import org.conscrypt.OpenSSLECGroupContext;
import org.conscrypt.OpenSSLECPrivateKey;
import org.conscrypt.OpenSSLECPublicKey;
import org.conscrypt.OpenSSLKey;

public final class OpenSSLECKeyPairGenerator
extends KeyPairGenerator {
    private static final String ALGORITHM = "EC";
    private static final int DEFAULT_KEY_SIZE = 256;
    private static final Map<Integer, String> SIZE_TO_CURVE_NAME = new HashMap<Integer, String>();
    private OpenSSLECGroupContext group;

    public OpenSSLECKeyPairGenerator() {
        super(ALGORITHM);
    }

    @Override
    public KeyPair generateKeyPair() {
        Object object;
        if (this.group == null) {
            object = SIZE_TO_CURVE_NAME.get(256);
            this.group = OpenSSLECGroupContext.getCurveByName((String)object);
            if (this.group == null) {
                throw new RuntimeException("Curve not recognized: " + (String)object);
            }
        }
        object = new OpenSSLKey(NativeCrypto.EC_KEY_generate_key(this.group.getNativeRef()));
        return new KeyPair(new OpenSSLECPublicKey(this.group, (OpenSSLKey)object), new OpenSSLECPrivateKey(this.group, (OpenSSLKey)object));
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        String string = SIZE_TO_CURVE_NAME.get(n);
        if (string == null) {
            throw new InvalidParameterException("unknown key size " + n);
        }
        OpenSSLECGroupContext openSSLECGroupContext = OpenSSLECGroupContext.getCurveByName(string);
        if (openSSLECGroupContext == null) {
            throw new InvalidParameterException("unknown curve " + string);
        }
        this.group = openSSLECGroupContext;
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof ECParameterSpec) {
            ECParameterSpec eCParameterSpec = (ECParameterSpec)algorithmParameterSpec;
            this.group = OpenSSLECGroupContext.getInstance(eCParameterSpec);
        } else if (algorithmParameterSpec instanceof ECGenParameterSpec) {
            ECGenParameterSpec eCGenParameterSpec = (ECGenParameterSpec)algorithmParameterSpec;
            String string = eCGenParameterSpec.getName();
            OpenSSLECGroupContext openSSLECGroupContext = OpenSSLECGroupContext.getCurveByName(string);
            if (openSSLECGroupContext == null) {
                throw new InvalidAlgorithmParameterException("unknown curve name: " + string);
            }
            this.group = openSSLECGroupContext;
        } else {
            throw new InvalidAlgorithmParameterException("parameter must be ECParameterSpec or ECGenParameterSpec");
        }
    }

    public static void assertCurvesAreValid() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : SIZE_TO_CURVE_NAME.values()) {
            if (OpenSSLECGroupContext.getCurveByName(string) != null) continue;
            arrayList.add(string);
        }
        if (arrayList.size() > 0) {
            throw new AssertionError((Object)("Invalid curve names: " + Arrays.toString(arrayList.toArray())));
        }
    }

    static {
        SIZE_TO_CURVE_NAME.put(224, "secp224r1");
        SIZE_TO_CURVE_NAME.put(256, "prime256v1");
        SIZE_TO_CURVE_NAME.put(384, "secp384r1");
        SIZE_TO_CURVE_NAME.put(521, "secp521r1");
    }
}

