/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import org.conscrypt.ArrayUtils;
import org.conscrypt.GCMParameters;
import org.conscrypt.NativeCrypto;
import org.conscrypt.OpenSSLCipher;
import org.conscrypt.Platform;
import org.conscrypt.ShortBufferWithoutStackTraceException;

public abstract class OpenSSLAeadCipher
extends OpenSSLCipher {
    static final int DEFAULT_TAG_SIZE_BITS = 128;
    private static int lastGlobalMessageSize = 32;
    private byte[] previousKey;
    private byte[] previousIv;
    private boolean mustInitialize;
    byte[] buf;
    int bufCount;
    long evpAead;
    private byte[] aad;
    int tagLengthInBytes;

    public OpenSSLAeadCipher(OpenSSLCipher.Mode mode) {
        super(mode, OpenSSLCipher.Padding.NOPADDING);
    }

    private void checkInitialization() {
        if (this.mustInitialize) {
            throw new IllegalStateException("Cannot re-use same key and IV for multiple encryptions");
        }
    }

    private boolean arraysAreEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n |= byArray[i] ^ byArray2[i];
        }
        return n == 0;
    }

    private void expand(int n) {
        if (this.bufCount + n <= this.buf.length) {
            return;
        }
        byte[] byArray = new byte[(this.bufCount + n) * 2];
        System.arraycopy(this.buf, 0, byArray, 0, this.bufCount);
        this.buf = byArray;
    }

    private void reset() {
        this.aad = null;
        int n = lastGlobalMessageSize;
        if (this.buf == null) {
            this.buf = new byte[n];
        } else if (this.bufCount > 0 && this.bufCount != n) {
            lastGlobalMessageSize = this.bufCount;
            if (this.buf.length != this.bufCount) {
                this.buf = new byte[this.bufCount];
            }
        }
        this.bufCount = 0;
    }

    @Override
    void engineInitInternal(byte[] byArray, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        int n;
        byte[] byArray2;
        if (algorithmParameterSpec == null) {
            byArray2 = null;
            n = 128;
        } else {
            GCMParameters gCMParameters = Platform.fromGCMParameterSpec(algorithmParameterSpec);
            if (gCMParameters != null) {
                byArray2 = gCMParameters.getIV();
                n = gCMParameters.getTLen();
            } else if (algorithmParameterSpec instanceof IvParameterSpec) {
                IvParameterSpec ivParameterSpec = (IvParameterSpec)algorithmParameterSpec;
                byArray2 = ivParameterSpec.getIV();
                n = 128;
            } else {
                byArray2 = null;
                n = 128;
            }
        }
        this.checkSupportedTagLength(n);
        this.tagLengthInBytes = n / 8;
        boolean bl = this.isEncrypting();
        this.evpAead = this.getEVP_AEAD(byArray.length);
        int n2 = NativeCrypto.EVP_AEAD_nonce_length(this.evpAead);
        if (byArray2 == null && n2 != 0) {
            if (!bl) {
                throw new InvalidAlgorithmParameterException("IV must be specified in " + (Object)((Object)this.mode) + " mode");
            }
            byArray2 = new byte[n2];
            if (secureRandom != null) {
                secureRandom.nextBytes(byArray2);
            } else {
                NativeCrypto.RAND_bytes(byArray2);
            }
        } else {
            if (n2 == 0 && byArray2 != null) {
                throw new InvalidAlgorithmParameterException("IV not used in " + (Object)((Object)this.mode) + " mode");
            }
            if (byArray2 != null && byArray2.length != n2) {
                throw new InvalidAlgorithmParameterException("Expected IV length of " + n2 + " but was " + byArray2.length);
            }
        }
        if (this.isEncrypting() && byArray2 != null && !this.allowsNonceReuse()) {
            if (this.previousKey != null && this.previousIv != null && this.arraysAreEqual(this.previousKey, byArray) && this.arraysAreEqual(this.previousIv, byArray2)) {
                this.mustInitialize = true;
                throw new InvalidAlgorithmParameterException("When using AEAD key and IV must not be re-used");
            }
            this.previousKey = byArray;
            this.previousIv = byArray2;
        }
        this.mustInitialize = false;
        this.iv = byArray2;
        this.reset();
    }

    void checkSupportedTagLength(int n) throws InvalidAlgorithmParameterException {
        if (n % 8 != 0) {
            throw new InvalidAlgorithmParameterException("Tag length must be a multiple of 8; was " + n);
        }
    }

    boolean allowsNonceReuse() {
        return false;
    }

    @Override
    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (byArray2 != null && this.getOutputSizeForFinal(n2) > byArray2.length - n3) {
            throw new ShortBufferWithoutStackTraceException("Insufficient output space");
        }
        return super.engineDoFinal(byArray, n, n2, byArray2, n3);
    }

    @Override
    int updateInternal(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws ShortBufferException {
        this.checkInitialization();
        if (this.buf == null) {
            throw new IllegalStateException("Cipher not initialized");
        }
        ArrayUtils.checkOffsetAndCount(byArray.length, n, n2);
        if (n2 > 0) {
            this.expand(n2);
            System.arraycopy(byArray, n, this.buf, this.bufCount, n2);
            this.bufCount += n2;
        }
        return 0;
    }

    private void throwAEADBadTagExceptionIfAvailable(String string, Throwable throwable) throws BadPaddingException {
        Constructor<?> constructor;
        try {
            constructor = Class.forName("javax.crypto.AEADBadTagException").getConstructor(String.class);
        }
        catch (Exception exception) {
            return;
        }
        BadPaddingException badPaddingException = null;
        try {
            badPaddingException = (BadPaddingException)constructor.newInstance(string);
            badPaddingException.initCause(throwable);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            throw (BadPaddingException)new BadPaddingException().initCause(invocationTargetException.getTargetException());
        }
        if (badPaddingException != null) {
            throw badPaddingException;
        }
    }

    @Override
    int doFinalInternal(byte[] byArray, int n, int n2) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n3;
        this.checkInitialization();
        try {
            n3 = this.isEncrypting() ? NativeCrypto.EVP_AEAD_CTX_seal(this.evpAead, this.encodedKey, this.tagLengthInBytes, byArray, n, this.iv, this.buf, 0, this.bufCount, this.aad) : NativeCrypto.EVP_AEAD_CTX_open(this.evpAead, this.encodedKey, this.tagLengthInBytes, byArray, n, this.iv, this.buf, 0, this.bufCount, this.aad);
        }
        catch (BadPaddingException badPaddingException) {
            this.throwAEADBadTagExceptionIfAvailable(badPaddingException.getMessage(), badPaddingException.getCause());
            throw badPaddingException;
        }
        if (this.isEncrypting()) {
            this.mustInitialize = true;
        }
        this.reset();
        return n3;
    }

    @Override
    void checkSupportedPadding(OpenSSLCipher.Padding padding) throws NoSuchPaddingException {
        if (padding != OpenSSLCipher.Padding.NOPADDING) {
            throw new NoSuchPaddingException("Must be NoPadding for AEAD ciphers");
        }
    }

    @Override
    int getOutputSizeForUpdate(int n) {
        return 0;
    }

    @Override
    int getOutputSizeForFinal(int n) {
        return this.bufCount + n + (this.isEncrypting() ? NativeCrypto.EVP_AEAD_max_overhead(this.evpAead) : 0);
    }

    @Override
    protected void engineUpdateAAD(byte[] byArray, int n, int n2) {
        this.checkInitialization();
        if (this.aad == null) {
            this.aad = Arrays.copyOfRange(byArray, n, n + n2);
        } else {
            int n3 = this.aad.length + n2;
            byte[] byArray2 = new byte[n3];
            System.arraycopy(this.aad, 0, byArray2, 0, this.aad.length);
            System.arraycopy(byArray, n, byArray2, this.aad.length, n2);
            this.aad = byArray2;
        }
    }

    @Override
    protected void engineUpdateAAD(ByteBuffer byteBuffer) {
        this.checkInitialization();
        if (this.aad == null) {
            this.aad = new byte[byteBuffer.remaining()];
            byteBuffer.get(this.aad);
        } else {
            int n = this.aad.length + byteBuffer.remaining();
            byte[] byArray = new byte[n];
            System.arraycopy(this.aad, 0, byArray, 0, this.aad.length);
            byteBuffer.get(byArray, this.aad.length, byteBuffer.remaining());
            this.aad = byArray;
        }
    }

    abstract long getEVP_AEAD(int var1) throws InvalidKeyException;
}

