/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;
import org.conscrypt.SSLClientSessionCache;
import org.conscrypt.io.IoUtils;

public final class FileClientSessionCache {
    private static final Logger logger = Logger.getLogger(FileClientSessionCache.class.getName());
    public static final int MAX_SIZE = 12;
    static final Map<File, Impl> caches = new HashMap<File, Impl>();

    private FileClientSessionCache() {
    }

    public static synchronized SSLClientSessionCache usingDirectory(File file) throws IOException {
        Impl impl = caches.get(file);
        if (impl == null) {
            impl = new Impl(file);
            caches.put(file, impl);
        }
        return impl;
    }

    static synchronized void reset() {
        caches.clear();
    }

    static class CacheFile
    extends File {
        final String name;
        long lastModified = -1L;

        CacheFile(File file, String string) {
            super(file, string);
            this.name = string;
        }

        @Override
        public long lastModified() {
            long l = this.lastModified;
            if (l == -1L) {
                l = this.lastModified = super.lastModified();
            }
            return l;
        }

        @Override
        public int compareTo(File file) {
            long l = this.lastModified() - file.lastModified();
            if (l == 0L) {
                return super.compareTo(file);
            }
            return l < 0L ? -1 : 1;
        }
    }

    static class Impl
    implements SSLClientSessionCache {
        final File directory;
        Map<String, File> accessOrder = Impl.newAccessOrder();
        int size;
        String[] initialFiles;

        Impl(File file) throws IOException {
            boolean bl = file.exists();
            if (bl && !file.isDirectory()) {
                throw new IOException(file + " exists but is not a directory.");
            }
            if (bl) {
                this.initialFiles = file.list();
                if (this.initialFiles == null) {
                    throw new IOException(file + " exists but cannot list contents.");
                }
                Arrays.sort(this.initialFiles);
                this.size = this.initialFiles.length;
            } else {
                if (!file.mkdirs()) {
                    throw new IOException("Creation of " + file + " directory failed.");
                }
                this.size = 0;
            }
            this.directory = file;
        }

        private static Map<String, File> newAccessOrder() {
            return new LinkedHashMap<String, File>(12, 0.75f, true);
        }

        private static String fileName(String string, int n) {
            if (string == null) {
                throw new NullPointerException("host == null");
            }
            return string + "." + n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized byte[] getSessionData(String string, int n) {
            FileInputStream fileInputStream;
            String string2 = Impl.fileName(string, n);
            File file = this.accessOrder.get(string2);
            if (file == null) {
                if (this.initialFiles == null) {
                    return null;
                }
                if (Arrays.binarySearch(this.initialFiles, string2) < 0) {
                    return null;
                }
                file = new File(this.directory, string2);
                this.accessOrder.put(string2, file);
            }
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Impl.logReadError(string, file, fileNotFoundException);
                return null;
            }
            try {
                int n2 = (int)file.length();
                byte[] byArray = new byte[n2];
                new DataInputStream(fileInputStream).readFully(byArray);
                byte[] byArray2 = byArray;
                return byArray2;
            }
            catch (IOException iOException) {
                Impl.logReadError(string, file, iOException);
                byte[] byArray = null;
                return byArray;
            }
            finally {
                IoUtils.closeQuietly(fileInputStream);
            }
        }

        static void logReadError(String string, File file, Throwable throwable) {
            logger.log(Level.WARNING, "FileClientSessionCache: Error reading session data for " + string + " from " + file + ".", throwable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public synchronized void putSessionData(SSLSession sSLSession, byte[] byArray) {
            FileOutputStream fileOutputStream;
            String string = sSLSession.getPeerHost();
            if (byArray == null) {
                throw new NullPointerException("sessionData == null");
            }
            String string2 = Impl.fileName(string, sSLSession.getPeerPort());
            File file = new File(this.directory, string2);
            boolean bl = file.exists();
            try {
                fileOutputStream = new FileOutputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Impl.logWriteError(string, file, fileNotFoundException);
                return;
            }
            if (!bl) {
                ++this.size;
                this.makeRoom();
            }
            boolean bl2 = false;
            try {
                fileOutputStream.write(byArray);
                bl2 = true;
                return;
            }
            catch (IOException iOException) {
                Impl.logWriteError(string, file, iOException);
                return;
            }
            finally {
                boolean bl3 = false;
                try {
                    fileOutputStream.close();
                    bl3 = true;
                }
                catch (IOException iOException) {
                    Impl.logWriteError(string, file, iOException);
                }
                finally {
                    if (!bl2 || !bl3) {
                        this.delete(file);
                    } else {
                        this.accessOrder.put(string2, file);
                    }
                }
            }
        }

        private void makeRoom() {
            if (this.size <= 12) {
                return;
            }
            this.indexFiles();
            int n = this.size - 12;
            Iterator<File> iterator = this.accessOrder.values().iterator();
            do {
                this.delete(iterator.next());
                iterator.remove();
            } while (--n > 0);
        }

        private void indexFiles() {
            String[] stringArray = this.initialFiles;
            if (stringArray != null) {
                this.initialFiles = null;
                TreeSet<CacheFile> treeSet = new TreeSet<CacheFile>();
                for (String string : stringArray) {
                    if (this.accessOrder.containsKey(string)) continue;
                    treeSet.add(new CacheFile(this.directory, string));
                }
                if (!treeSet.isEmpty()) {
                    Map<String, File> map = Impl.newAccessOrder();
                    for (CacheFile cacheFile : treeSet) {
                        map.put(cacheFile.name, cacheFile);
                    }
                    map.putAll(this.accessOrder);
                    this.accessOrder = map;
                }
            }
        }

        private void delete(File file) {
            if (!file.delete()) {
                IOException iOException = new IOException("FileClientSessionCache: Failed to delete " + file + ".");
                logger.log(Level.WARNING, iOException.getMessage(), iOException);
            }
            --this.size;
        }

        static void logWriteError(String string, File file, Throwable throwable) {
            logger.log(Level.WARNING, "FileClientSessionCache: Error writing session data for " + string + " to " + file + ".", throwable);
        }
    }
}

