/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.conscrypt.Conscrypt;

final class CryptoUpcalls {
    private static final Logger logger = Logger.getLogger(CryptoUpcalls.class.getName());

    private CryptoUpcalls() {
    }

    private static ArrayList<Provider> getExternalProviders(String string) {
        ArrayList<Provider> arrayList = new ArrayList<Provider>(1);
        for (Provider provider : Security.getProviders(string)) {
            if (Conscrypt.isConscrypt(provider)) continue;
            arrayList.add(provider);
        }
        if (arrayList.isEmpty()) {
            logger.warning("Could not find external provider for algorithm: " + string);
        }
        return arrayList;
    }

    static byte[] ecSignDigestWithPrivateKey(PrivateKey privateKey, byte[] byArray) {
        String string = privateKey.getAlgorithm();
        if (!"EC".equals(string)) {
            throw new RuntimeException("Unexpected key type: " + privateKey.toString());
        }
        return CryptoUpcalls.signDigestWithPrivateKey(privateKey, byArray, "NONEwithECDSA");
    }

    private static byte[] signDigestWithPrivateKey(PrivateKey privateKey, byte[] byArray, String string) {
        Signature signature;
        try {
            signature = Signature.getInstance(string);
            signature.initSign(privateKey);
            if (Conscrypt.isConscrypt(signature.getProvider())) {
                signature = null;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.warning("Unsupported signature algorithm: " + string);
            return null;
        }
        catch (InvalidKeyException invalidKeyException) {
            logger.warning("Preferred provider doesn't support key:");
            invalidKeyException.printStackTrace();
            signature = null;
        }
        if (signature == null) {
            ArrayList<Provider> arrayList = CryptoUpcalls.getExternalProviders("Signature." + string);
            RuntimeException runtimeException = null;
            for (Provider provider : arrayList) {
                try {
                    signature = Signature.getInstance(string, provider);
                    signature.initSign(privateKey);
                    break;
                }
                catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
                    signature = null;
                }
                catch (RuntimeException runtimeException2) {
                    signature = null;
                    if (runtimeException != null) continue;
                    runtimeException = runtimeException2;
                }
            }
            if (signature == null) {
                if (runtimeException != null) {
                    throw runtimeException;
                }
                logger.warning("Could not find provider for algorithm: " + string);
                return null;
            }
        }
        try {
            signature.update(byArray);
            return signature.sign();
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Exception while signing message with " + privateKey.getAlgorithm() + " private key:", exception);
            return null;
        }
    }

    static byte[] rsaSignDigestWithPrivateKey(PrivateKey privateKey, int n, byte[] byArray) {
        return CryptoUpcalls.rsaOpWithPrivateKey(privateKey, n, 1, byArray);
    }

    static byte[] rsaDecryptWithPrivateKey(PrivateKey privateKey, int n, byte[] byArray) {
        return CryptoUpcalls.rsaOpWithPrivateKey(privateKey, n, 2, byArray);
    }

    private static byte[] rsaOpWithPrivateKey(PrivateKey privateKey, int n, int n2, byte[] byArray) {
        String string;
        String string2 = privateKey.getAlgorithm();
        if (!"RSA".equals(string2)) {
            logger.warning("Unexpected key type: " + string2);
            return null;
        }
        switch (n) {
            case 1: {
                string = "PKCS1Padding";
                break;
            }
            case 3: {
                string = "NoPadding";
                break;
            }
            case 4: {
                string = "OAEPPadding";
                break;
            }
            default: {
                logger.warning("Unsupported OpenSSL/BoringSSL padding: " + n);
                return null;
            }
        }
        String string3 = "RSA/ECB/" + string;
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(string3);
            cipher.init(n2, privateKey);
            if (Conscrypt.isConscrypt(cipher.getProvider())) {
                cipher = null;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.warning("Unsupported cipher algorithm: " + string3);
            return null;
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            logger.warning("Unsupported cipher algorithm: " + string3);
            return null;
        }
        catch (InvalidKeyException invalidKeyException) {
            logger.log(Level.WARNING, "Preferred provider doesn't support key:", invalidKeyException);
            cipher = null;
        }
        if (cipher == null) {
            ArrayList<Provider> arrayList = CryptoUpcalls.getExternalProviders("Cipher." + string3);
            for (Provider provider : arrayList) {
                try {
                    cipher = Cipher.getInstance(string3, provider);
                    cipher.init(n2, privateKey);
                    break;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    cipher = null;
                }
                catch (InvalidKeyException invalidKeyException) {
                    cipher = null;
                }
                catch (NoSuchPaddingException noSuchPaddingException) {
                    cipher = null;
                }
            }
            if (cipher == null) {
                logger.warning("Could not find provider for algorithm: " + string3);
                return null;
            }
        }
        try {
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Exception while decrypting message with " + privateKey.getAlgorithm() + " private key using " + string3 + ":", exception);
            return null;
        }
    }
}

