/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.List;

public final class ChainStrengthAnalyzer {
    private static final int MIN_RSA_MODULUS_LEN_BITS = 1024;
    private static final int MIN_EC_FIELD_SIZE_BITS = 160;
    private static final int MIN_DSA_P_LEN_BITS = 1024;
    private static final int MIN_DSA_Q_LEN_BITS = 160;
    private static final String[] SIGNATURE_ALGORITHM_OID_BLACKLIST = new String[]{"1.2.840.113549.1.1.2", "1.2.840.113549.1.1.3", "1.2.840.113549.1.1.4", "1.2.840.113549.1.1.5", "1.2.840.10040.4.3", "1.2.840.10045.4.1"};

    public static final void check(X509Certificate[] x509CertificateArray) throws CertificateException {
        for (X509Certificate x509Certificate : x509CertificateArray) {
            try {
                ChainStrengthAnalyzer.checkCert(x509Certificate);
            }
            catch (CertificateException certificateException) {
                throw new CertificateException("Unacceptable certificate: " + x509Certificate.getSubjectX500Principal(), certificateException);
            }
        }
    }

    public static final void check(List<X509Certificate> list) throws CertificateException {
        for (X509Certificate x509Certificate : list) {
            try {
                ChainStrengthAnalyzer.checkCert(x509Certificate);
            }
            catch (CertificateException certificateException) {
                throw new CertificateException("Unacceptable certificate: " + x509Certificate.getSubjectX500Principal(), certificateException);
            }
        }
    }

    public static final void checkCert(X509Certificate x509Certificate) throws CertificateException {
        ChainStrengthAnalyzer.checkKeyLength(x509Certificate);
        ChainStrengthAnalyzer.checkSignatureAlgorithm(x509Certificate);
    }

    private static void checkKeyLength(X509Certificate x509Certificate) throws CertificateException {
        PublicKey publicKey = x509Certificate.getPublicKey();
        if (publicKey instanceof RSAPublicKey) {
            int n = ((RSAPublicKey)publicKey).getModulus().bitLength();
            if (n < 1024) {
                throw new CertificateException("RSA modulus is < 1024 bits");
            }
        } else if (publicKey instanceof ECPublicKey) {
            int n = ((ECPublicKey)publicKey).getParams().getCurve().getField().getFieldSize();
            if (n < 160) {
                throw new CertificateException("EC key field size is < 160 bits");
            }
        } else if (publicKey instanceof DSAPublicKey) {
            int n = ((DSAPublicKey)publicKey).getParams().getP().bitLength();
            int n2 = ((DSAPublicKey)publicKey).getParams().getQ().bitLength();
            if (n < 1024 || n2 < 160) {
                throw new CertificateException("DSA key length is < (1024, 160) bits");
            }
        } else {
            throw new CertificateException("Rejecting unknown key class " + publicKey.getClass().getName());
        }
    }

    private static void checkSignatureAlgorithm(X509Certificate x509Certificate) throws CertificateException {
        String string = x509Certificate.getSigAlgOID();
        for (String string2 : SIGNATURE_ALGORITHM_OID_BLACKLIST) {
            if (!string.equals(string2)) continue;
            throw new CertificateException("Signature uses an insecure hash function: " + string);
        }
    }
}

