/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.symmetric.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.asn1.cms.GCMParameters;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.CCMBlockCipher;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.modes.CTSBlockCipher;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.modes.OFBBlockCipher;
import org.bouncycastle.crypto.modes.SICBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.ISO10126d2Padding;
import org.bouncycastle.crypto.paddings.ISO7816d4Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.paddings.TBCPadding;
import org.bouncycastle.crypto.paddings.X923Padding;
import org.bouncycastle.crypto.paddings.ZeroBytePadding;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jcajce.PKCS12Key;
import org.bouncycastle.jcajce.PKCS12KeyWithParameters;
import org.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import org.bouncycastle.jcajce.provider.symmetric.util.BaseWrapCipher;
import org.bouncycastle.jcajce.provider.symmetric.util.BlockCipherProvider;
import org.bouncycastle.jcajce.provider.symmetric.util.ClassUtil;
import org.bouncycastle.jcajce.provider.symmetric.util.PBE;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;
import org.bouncycastle.util.Strings;

public class BaseBlockCipher
extends BaseWrapCipher
implements PBE {
    private static final Class gcmSpecClass = ClassUtil.loadClass(BaseBlockCipher.class, "javax.crypto.spec.GCMParameterSpec");
    private Class[] availableSpecs = new Class[]{gcmSpecClass, IvParameterSpec.class, PBEParameterSpec.class};
    private BlockCipher baseEngine;
    private BlockCipherProvider engineProvider;
    private GenericBlockCipher cipher;
    private ParametersWithIV ivParam;
    private AEADParameters aeadParams;
    private int keySizeInBits;
    private int scheme = -1;
    private int digest;
    private int ivLength = 0;
    private boolean padded;
    private boolean fixedIv = true;
    private PBEParameterSpec pbeSpec = null;
    private String pbeAlgorithm = null;
    private String modeName = null;

    protected BaseBlockCipher(BlockCipher blockCipher) {
        this.baseEngine = blockCipher;
        this.cipher = new BufferedGenericBlockCipher(blockCipher);
    }

    protected BaseBlockCipher(BlockCipher blockCipher, int n, int n2, int n3, int n4) {
        this.baseEngine = blockCipher;
        this.scheme = n;
        this.digest = n2;
        this.keySizeInBits = n3;
        this.ivLength = n4;
        this.cipher = new BufferedGenericBlockCipher(blockCipher);
    }

    protected BaseBlockCipher(BlockCipherProvider blockCipherProvider) {
        this.baseEngine = blockCipherProvider.get();
        this.engineProvider = blockCipherProvider;
        this.cipher = new BufferedGenericBlockCipher(blockCipherProvider.get());
    }

    protected BaseBlockCipher(AEADBlockCipher aEADBlockCipher) {
        this.baseEngine = aEADBlockCipher.getUnderlyingCipher();
        this.ivLength = this.baseEngine.getBlockSize();
        this.cipher = new AEADGenericBlockCipher(aEADBlockCipher);
    }

    protected BaseBlockCipher(AEADBlockCipher aEADBlockCipher, boolean bl, int n) {
        this.baseEngine = aEADBlockCipher.getUnderlyingCipher();
        this.fixedIv = bl;
        this.ivLength = n;
        this.cipher = new AEADGenericBlockCipher(aEADBlockCipher);
    }

    protected BaseBlockCipher(BlockCipher blockCipher, int n) {
        this(blockCipher, true, n);
    }

    protected BaseBlockCipher(BlockCipher blockCipher, boolean bl, int n) {
        this.baseEngine = blockCipher;
        this.fixedIv = bl;
        this.cipher = new BufferedGenericBlockCipher(blockCipher);
        this.ivLength = n / 8;
    }

    protected BaseBlockCipher(BufferedBlockCipher bufferedBlockCipher, int n) {
        this(bufferedBlockCipher, true, n);
    }

    protected BaseBlockCipher(BufferedBlockCipher bufferedBlockCipher, boolean bl, int n) {
        this.baseEngine = bufferedBlockCipher.getUnderlyingCipher();
        this.cipher = new BufferedGenericBlockCipher(bufferedBlockCipher);
        this.fixedIv = bl;
        this.ivLength = n / 8;
    }

    @Override
    protected int engineGetBlockSize() {
        return this.baseEngine.getBlockSize();
    }

    @Override
    protected byte[] engineGetIV() {
        if (this.aeadParams != null) {
            return this.aeadParams.getNonce();
        }
        return this.ivParam != null ? this.ivParam.getIV() : null;
    }

    @Override
    protected int engineGetKeySize(Key key) {
        return key.getEncoded().length * 8;
    }

    @Override
    protected int engineGetOutputSize(int n) {
        return this.cipher.getOutputSize(n);
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null) {
            if (this.pbeSpec != null) {
                try {
                    this.engineParams = this.createParametersInstance(this.pbeAlgorithm);
                    this.engineParams.init(this.pbeSpec);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            if (this.aeadParams != null) {
                try {
                    this.engineParams = this.createParametersInstance("GCM");
                    this.engineParams.init(new GCMParameters(this.aeadParams.getNonce(), this.aeadParams.getMacSize() / 8).getEncoded());
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.toString());
                }
            }
            if (this.ivParam != null) {
                String string = this.cipher.getUnderlyingCipher().getAlgorithmName();
                if (string.indexOf(47) >= 0) {
                    string = string.substring(0, string.indexOf(47));
                }
                try {
                    this.engineParams = this.createParametersInstance(string);
                    this.engineParams.init(new IvParameterSpec(this.ivParam.getIV()));
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.toString());
                }
            }
        }
        return this.engineParams;
    }

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        this.modeName = Strings.toUpperCase(string);
        if (this.modeName.equalsIgnoreCase("ECB")) {
            this.ivLength = 0;
            this.cipher = new BufferedGenericBlockCipher(this.baseEngine);
        } else if (this.modeName.equalsIgnoreCase("CBC")) {
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = new BufferedGenericBlockCipher(new CBCBlockCipher(this.baseEngine));
        } else if (this.modeName.equalsIgnoreCase("OFB")) {
            this.ivLength = this.baseEngine.getBlockSize();
            if (this.modeName.length() != 3) {
                int n = Integer.parseInt(this.modeName.substring(3));
                this.cipher = new BufferedGenericBlockCipher(new OFBBlockCipher(this.baseEngine, n));
            } else {
                this.cipher = new BufferedGenericBlockCipher(new OFBBlockCipher(this.baseEngine, 8 * this.baseEngine.getBlockSize()));
            }
        } else if (this.modeName.equalsIgnoreCase("CFB")) {
            this.ivLength = this.baseEngine.getBlockSize();
            if (this.modeName.length() != 3) {
                int n = Integer.parseInt(this.modeName.substring(3));
                this.cipher = new BufferedGenericBlockCipher(new CFBBlockCipher(this.baseEngine, n));
            } else {
                this.cipher = new BufferedGenericBlockCipher(new CFBBlockCipher(this.baseEngine, 8 * this.baseEngine.getBlockSize()));
            }
        } else if (this.modeName.equalsIgnoreCase("CTR")) {
            this.ivLength = this.baseEngine.getBlockSize();
            this.fixedIv = false;
            this.cipher = new BufferedGenericBlockCipher(new BufferedBlockCipher(new SICBlockCipher(this.baseEngine)));
        } else if (this.modeName.equalsIgnoreCase("CTS")) {
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = new BufferedGenericBlockCipher(new CTSBlockCipher(new CBCBlockCipher(this.baseEngine)));
        } else if (this.modeName.equalsIgnoreCase("CCM")) {
            this.ivLength = 12;
            this.cipher = new AEADGenericBlockCipher(new CCMBlockCipher(this.baseEngine));
        } else if (this.modeName.equalsIgnoreCase("GCM")) {
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = new AEADGenericBlockCipher(new GCMBlockCipher(this.baseEngine));
        } else {
            throw new NoSuchAlgorithmException("can't support mode " + string);
        }
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        String string2 = Strings.toUpperCase(string);
        if (string2.equals("NOPADDING")) {
            if (this.cipher.wrapOnNoPadding()) {
                this.cipher = new BufferedGenericBlockCipher(new BufferedBlockCipher(this.cipher.getUnderlyingCipher()));
            }
        } else if (string2.equals("WITHCTS") || string2.equals("CTSPADDING") || string2.equals("CS3PADDING")) {
            this.cipher = new BufferedGenericBlockCipher(new CTSBlockCipher(this.cipher.getUnderlyingCipher()));
        } else {
            this.padded = true;
            if (this.isAEADModeName(this.modeName)) {
                throw new NoSuchPaddingException("Only NoPadding can be used with AEAD modes.");
            }
            if (string2.equals("PKCS5PADDING") || string2.equals("PKCS7PADDING")) {
                this.cipher = new BufferedGenericBlockCipher(this.cipher.getUnderlyingCipher());
            } else if (string2.equals("ZEROBYTEPADDING")) {
                this.cipher = new BufferedGenericBlockCipher(this.cipher.getUnderlyingCipher(), new ZeroBytePadding());
            } else if (string2.equals("ISO10126PADDING") || string2.equals("ISO10126-2PADDING")) {
                this.cipher = new BufferedGenericBlockCipher(this.cipher.getUnderlyingCipher(), new ISO10126d2Padding());
            } else if (string2.equals("X9.23PADDING") || string2.equals("X923PADDING")) {
                this.cipher = new BufferedGenericBlockCipher(this.cipher.getUnderlyingCipher(), new X923Padding());
            } else if (string2.equals("ISO7816-4PADDING") || string2.equals("ISO9797-1PADDING")) {
                this.cipher = new BufferedGenericBlockCipher(this.cipher.getUnderlyingCipher(), new ISO7816d4Padding());
            } else if (string2.equals("TBCPADDING")) {
                this.cipher = new BufferedGenericBlockCipher(this.cipher.getUnderlyingCipher(), new TBCPadding());
            } else {
                throw new NoSuchPaddingException("Padding " + string + " unknown.");
            }
        }
    }

    private boolean isBCPBEKeyWithoutIV(Key key) {
        return key instanceof BCPBEKey && !(((BCPBEKey)key).getParam() instanceof ParametersWithIV);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Object object;
        Object object2;
        Object object3;
        this.pbeSpec = null;
        this.pbeAlgorithm = null;
        this.engineParams = null;
        this.aeadParams = null;
        if (!(key instanceof SecretKey)) {
            String string;
            StringBuilder stringBuilder = new StringBuilder().append("Key for algorithm ");
            if (key != null) {
                string = key.getAlgorithm();
                throw new InvalidKeyException(stringBuilder.append(string).append(" not suitable for symmetric enryption.").toString());
            }
            string = null;
            throw new InvalidKeyException(stringBuilder.append(string).append(" not suitable for symmetric enryption.").toString());
        }
        if (algorithmParameterSpec == null && this.baseEngine.getAlgorithmName().startsWith("RC5-64")) {
            throw new InvalidAlgorithmParameterException("RC5 requires an RC5ParametersSpec to be passed in.");
        }
        if ((this.scheme == 2 || key instanceof PKCS12Key) && !this.isBCPBEKeyWithoutIV(key)) {
            try {
                object3 = (SecretKey)key;
            }
            catch (Exception exception) {
                throw new InvalidKeyException("PKCS12 requires a SecretKey/PBEKey");
            }
            if (algorithmParameterSpec instanceof PBEParameterSpec) {
                this.pbeSpec = (PBEParameterSpec)algorithmParameterSpec;
            }
            if (object3 instanceof PBEKey && this.pbeSpec == null) {
                object2 = (PBEKey)object3;
                if (object2.getSalt() == null) {
                    throw new InvalidAlgorithmParameterException("PBEKey requires parameters to specify salt");
                }
                this.pbeSpec = new PBEParameterSpec(object2.getSalt(), object2.getIterationCount());
            }
            if (this.pbeSpec == null && !(object3 instanceof PBEKey)) {
                throw new InvalidKeyException("Algorithm requires a PBE key");
            }
            if (key instanceof BCPBEKey) {
                object2 = ((BCPBEKey)key).getParam();
                if (!(object2 instanceof ParametersWithIV)) {
                    if (object2 != null) throw new InvalidKeyException("Algorithm requires a PBE key suitable for PKCS12");
                    throw new AssertionError((Object)"Unreachable code");
                }
                object = object2;
            } else {
                object = PBE.Util.makePBEParameters(object3.getEncoded(), 2, this.digest, this.keySizeInBits, this.ivLength * 8, this.pbeSpec, this.cipher.getAlgorithmName());
            }
            if (object instanceof ParametersWithIV) {
                this.ivParam = (ParametersWithIV)object;
            }
        } else if (key instanceof BCPBEKey) {
            object3 = (BCPBEKey)key;
            this.pbeAlgorithm = ((BCPBEKey)object3).getOID() != null ? ((BCPBEKey)object3).getOID().getId() : ((BCPBEKey)object3).getAlgorithm();
            if (((BCPBEKey)object3).getParam() != null) {
                object = this.adjustParameters(algorithmParameterSpec, ((BCPBEKey)object3).getParam());
            } else {
                if (!(algorithmParameterSpec instanceof PBEParameterSpec)) throw new InvalidAlgorithmParameterException("PBE requires PBE parameters to be set.");
                this.pbeSpec = (PBEParameterSpec)algorithmParameterSpec;
                if (this.pbeSpec.getSalt().length != 0 && this.pbeSpec.getIterationCount() > 0) {
                    object3 = new BCPBEKey(((BCPBEKey)object3).getAlgorithm(), ((BCPBEKey)object3).getOID(), ((BCPBEKey)object3).getType(), ((BCPBEKey)object3).getDigest(), ((BCPBEKey)object3).getKeySize(), ((BCPBEKey)object3).getIvSize(), new PBEKeySpec(((BCPBEKey)object3).getPassword(), this.pbeSpec.getSalt(), this.pbeSpec.getIterationCount(), ((BCPBEKey)object3).getKeySize()), null);
                }
                object = PBE.Util.makePBEParameters((BCPBEKey)object3, algorithmParameterSpec, this.cipher.getUnderlyingCipher().getAlgorithmName());
            }
            if (object instanceof ParametersWithIV) {
                this.ivParam = (ParametersWithIV)object;
            }
        } else if (key instanceof PBEKey) {
            object3 = (PBEKey)key;
            this.pbeSpec = (PBEParameterSpec)algorithmParameterSpec;
            if (object3 instanceof PKCS12KeyWithParameters && this.pbeSpec == null) {
                this.pbeSpec = new PBEParameterSpec(object3.getSalt(), object3.getIterationCount());
            }
            if ((object = PBE.Util.makePBEParameters(object3.getEncoded(), this.scheme, this.digest, this.keySizeInBits, this.ivLength * 8, this.pbeSpec, this.cipher.getAlgorithmName())) instanceof ParametersWithIV) {
                this.ivParam = (ParametersWithIV)object;
            }
        } else {
            if (this.scheme == 0) throw new InvalidKeyException("Algorithm requires a PBE key");
            if (this.scheme == 4) throw new InvalidKeyException("Algorithm requires a PBE key");
            if (this.scheme == 1) throw new InvalidKeyException("Algorithm requires a PBE key");
            if (this.scheme == 5) {
                throw new InvalidKeyException("Algorithm requires a PBE key");
            }
            object = new KeyParameter(key.getEncoded());
        }
        if (algorithmParameterSpec instanceof AEADParameterSpec) {
            if (!this.isAEADModeName(this.modeName) && !(this.cipher instanceof AEADGenericBlockCipher)) {
                throw new InvalidAlgorithmParameterException("AEADParameterSpec can only be used with AEAD modes.");
            }
            object3 = (AEADParameterSpec)algorithmParameterSpec;
            object2 = object instanceof ParametersWithIV ? (KeyParameter)((ParametersWithIV)object).getParameters() : (KeyParameter)object;
            this.aeadParams = new AEADParameters((KeyParameter)object2, ((AEADParameterSpec)object3).getMacSizeInBits(), ((AEADParameterSpec)object3).getNonce(), ((AEADParameterSpec)object3).getAssociatedData());
            object = this.aeadParams;
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            if (this.ivLength != 0) {
                object3 = (IvParameterSpec)algorithmParameterSpec;
                if (((IvParameterSpec)object3).getIV().length != this.ivLength && !(this.cipher instanceof AEADGenericBlockCipher) && this.fixedIv) {
                    throw new InvalidAlgorithmParameterException("IV must be " + this.ivLength + " bytes long.");
                }
                object = object instanceof ParametersWithIV ? new ParametersWithIV(((ParametersWithIV)object).getParameters(), ((IvParameterSpec)object3).getIV()) : new ParametersWithIV((CipherParameters)object, ((IvParameterSpec)object3).getIV());
                this.ivParam = (ParametersWithIV)object;
            } else if (this.modeName != null && this.modeName.equals("ECB")) {
                throw new InvalidAlgorithmParameterException("ECB mode does not use an IV");
            }
        } else if (gcmSpecClass != null && gcmSpecClass.isInstance(algorithmParameterSpec)) {
            if (!this.isAEADModeName(this.modeName) && !(this.cipher instanceof AEADGenericBlockCipher)) {
                throw new InvalidAlgorithmParameterException("GCMParameterSpec can only be used with AEAD modes.");
            }
            try {
                object3 = gcmSpecClass.getDeclaredMethod("getTLen", new Class[0]);
                object2 = gcmSpecClass.getDeclaredMethod("getIV", new Class[0]);
                KeyParameter keyParameter = object instanceof ParametersWithIV ? (KeyParameter)((ParametersWithIV)object).getParameters() : (KeyParameter)object;
                this.aeadParams = new AEADParameters(keyParameter, (Integer)((Method)object3).invoke((Object)algorithmParameterSpec, new Object[0]), (byte[])((Method)object2).invoke((Object)algorithmParameterSpec, new Object[0]));
                object = this.aeadParams;
            }
            catch (Exception exception) {
                throw new InvalidAlgorithmParameterException("Cannot process GCMParameterSpec.");
            }
        } else if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof PBEParameterSpec)) {
            throw new InvalidAlgorithmParameterException("unknown parameter type.");
        }
        if (this.ivLength != 0 && !(object instanceof ParametersWithIV) && !(object instanceof AEADParameters)) {
            object3 = secureRandom;
            if (object3 == null) {
                object3 = CryptoServicesRegistrar.getSecureRandom();
            }
            if (n == 1 || n == 3) {
                object2 = new byte[this.ivLength];
                if (!this.isBCPBEKeyWithoutIV(key)) {
                    ((SecureRandom)object3).nextBytes((byte[])object2);
                } else {
                    System.err.println(" ******** DEPRECATED FUNCTIONALITY ********");
                    System.err.println(" * You have initialized a cipher with a PBE key with no IV and");
                    System.err.println(" * have not provided an IV in the AlgorithmParameterSpec.  This");
                    System.err.println(" * configuration is deprecated.  The cipher will be initialized");
                    System.err.println(" * with an all-zero IV, but in a future release this call will");
                    System.err.println(" * throw an exception.");
                    new InvalidAlgorithmParameterException("No IV set when using PBE key").printStackTrace(System.err);
                }
                object = new ParametersWithIV((CipherParameters)object, (byte[])object2);
                this.ivParam = (ParametersWithIV)object;
            } else if (this.cipher.getUnderlyingCipher().getAlgorithmName().indexOf("PGPCFB") < 0) {
                if (!this.isBCPBEKeyWithoutIV(key)) {
                    throw new InvalidAlgorithmParameterException("no IV set when one expected");
                }
                System.err.println(" ******** DEPRECATED FUNCTIONALITY ********");
                System.err.println(" * You have initialized a cipher with a PBE key with no IV and");
                System.err.println(" * have not provided an IV in the AlgorithmParameterSpec.  This");
                System.err.println(" * configuration is deprecated.  The cipher will be initialized");
                System.err.println(" * with an all-zero IV, but in a future release this call will");
                System.err.println(" * throw an exception.");
                new InvalidAlgorithmParameterException("No IV set when using PBE key").printStackTrace(System.err);
                object = new ParametersWithIV((CipherParameters)object, new byte[this.ivLength]);
                this.ivParam = (ParametersWithIV)object;
            }
        }
        if (secureRandom != null && this.padded) {
            object = new ParametersWithRandom((CipherParameters)object, secureRandom);
        }
        try {
            switch (n) {
                case 1: 
                case 3: {
                    this.cipher.init(true, (CipherParameters)object);
                    break;
                }
                case 2: 
                case 4: {
                    this.cipher.init(false, (CipherParameters)object);
                    break;
                }
                default: {
                    throw new InvalidParameterException("unknown opmode " + n + " passed");
                }
            }
            if (!(this.cipher instanceof AEADGenericBlockCipher)) return;
            if (this.aeadParams != null) return;
            object3 = ((AEADGenericBlockCipher)this.cipher).cipher;
            this.aeadParams = new AEADParameters((KeyParameter)this.ivParam.getParameters(), object3.getMac().length * 8, this.ivParam.getIV());
            return;
        }
        catch (Exception exception) {
            throw new BaseWrapCipher.InvalidKeyOrParametersException(exception.getMessage(), exception);
        }
    }

    private CipherParameters adjustParameters(AlgorithmParameterSpec algorithmParameterSpec, CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithIV) {
            CipherParameters cipherParameters2 = ((ParametersWithIV)cipherParameters).getParameters();
            if (algorithmParameterSpec instanceof IvParameterSpec) {
                IvParameterSpec ivParameterSpec = (IvParameterSpec)algorithmParameterSpec;
                this.ivParam = new ParametersWithIV(cipherParameters2, ivParameterSpec.getIV());
                cipherParameters = this.ivParam;
            }
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            IvParameterSpec ivParameterSpec = (IvParameterSpec)algorithmParameterSpec;
            this.ivParam = new ParametersWithIV(cipherParameters, ivParameterSpec.getIV());
            cipherParameters = this.ivParam;
        }
        return cipherParameters;
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        if (algorithmParameters != null) {
            for (int i = 0; i != this.availableSpecs.length; ++i) {
                if (this.availableSpecs[i] == null) continue;
                try {
                    algorithmParameterSpec = (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(this.availableSpecs[i]);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (algorithmParameterSpec == null) {
                throw new InvalidAlgorithmParameterException("can't handle parameter " + algorithmParameters.toString());
            }
        }
        this.engineInit(n, key, algorithmParameterSpec, secureRandom);
        this.engineParams = algorithmParameters;
    }

    @Override
    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(n, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
    }

    @Override
    protected void engineUpdateAAD(byte[] byArray, int n, int n2) {
        this.cipher.updateAAD(byArray, n, n2);
    }

    @Override
    protected void engineUpdateAAD(ByteBuffer byteBuffer) {
        int n = byteBuffer.arrayOffset() + byteBuffer.position();
        int n2 = byteBuffer.limit() - byteBuffer.position();
        this.engineUpdateAAD(byteBuffer.array(), n, n2);
    }

    @Override
    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        int n3 = this.cipher.getUpdateOutputSize(n2);
        if (n3 > 0) {
            byte[] byArray2 = new byte[n3];
            int n4 = this.cipher.processBytes(byArray, n, n2, byArray2, 0);
            if (n4 == 0) {
                return null;
            }
            if (n4 != byArray2.length) {
                byte[] byArray3 = new byte[n4];
                System.arraycopy(byArray2, 0, byArray3, 0, n4);
                return byArray3;
            }
            return byArray2;
        }
        this.cipher.processBytes(byArray, n, n2, null, 0);
        return null;
    }

    @Override
    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        if (n3 + this.cipher.getUpdateOutputSize(n2) > byArray2.length) {
            throw new ShortBufferException("output buffer too short for input.");
        }
        try {
            return this.cipher.processBytes(byArray, n, n2, byArray2, n3);
        }
        catch (DataLengthException dataLengthException) {
            throw new IllegalStateException(dataLengthException.toString());
        }
    }

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        int n3 = 0;
        byte[] byArray2 = new byte[this.engineGetOutputSize(n2)];
        if (n2 != 0) {
            n3 = this.cipher.processBytes(byArray, n, n2, byArray2, 0);
        }
        try {
            n3 += this.cipher.doFinal(byArray2, n3);
        }
        catch (DataLengthException dataLengthException) {
            throw new IllegalBlockSizeException(dataLengthException.getMessage());
        }
        if (n3 == byArray2.length) {
            return byArray2;
        }
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray2, 0, byArray3, 0, n3);
        return byArray3;
    }

    @Override
    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        int n4 = 0;
        if (n3 + this.engineGetOutputSize(n2) > byArray2.length) {
            throw new ShortBufferException("output buffer too short for input.");
        }
        try {
            if (n2 != 0) {
                n4 = this.cipher.processBytes(byArray, n, n2, byArray2, n3);
            }
            return n4 + this.cipher.doFinal(byArray2, n3 + n4);
        }
        catch (OutputLengthException outputLengthException) {
            throw new IllegalBlockSizeException(outputLengthException.getMessage());
        }
        catch (DataLengthException dataLengthException) {
            throw new IllegalBlockSizeException(dataLengthException.getMessage());
        }
    }

    private boolean isAEADModeName(String string) {
        return "CCM".equals(string) || "GCM".equals(string);
    }

    private static class AEADGenericBlockCipher
    implements GenericBlockCipher {
        private static final Constructor aeadBadTagConstructor;
        private AEADBlockCipher cipher;

        private static Constructor findExceptionConstructor(Class clazz) {
            try {
                return clazz.getConstructor(String.class);
            }
            catch (Exception exception) {
                return null;
            }
        }

        AEADGenericBlockCipher(AEADBlockCipher aEADBlockCipher) {
            this.cipher = aEADBlockCipher;
        }

        @Override
        public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
            this.cipher.init(bl, cipherParameters);
        }

        @Override
        public String getAlgorithmName() {
            return this.cipher.getUnderlyingCipher().getAlgorithmName();
        }

        @Override
        public boolean wrapOnNoPadding() {
            return false;
        }

        @Override
        public BlockCipher getUnderlyingCipher() {
            return this.cipher.getUnderlyingCipher();
        }

        @Override
        public int getOutputSize(int n) {
            return this.cipher.getOutputSize(n);
        }

        @Override
        public int getUpdateOutputSize(int n) {
            return this.cipher.getUpdateOutputSize(n);
        }

        @Override
        public void updateAAD(byte[] byArray, int n, int n2) {
            this.cipher.processAADBytes(byArray, n, n2);
        }

        @Override
        public int processByte(byte by, byte[] byArray, int n) throws DataLengthException {
            return this.cipher.processByte(by, byArray, n);
        }

        @Override
        public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException {
            return this.cipher.processBytes(byArray, n, n2, byArray2, n3);
        }

        @Override
        public int doFinal(byte[] byArray, int n) throws IllegalStateException, BadPaddingException {
            try {
                return this.cipher.doFinal(byArray, n);
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                if (aeadBadTagConstructor != null) {
                    BadPaddingException badPaddingException = null;
                    try {
                        badPaddingException = (BadPaddingException)aeadBadTagConstructor.newInstance(invalidCipherTextException.getMessage());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (badPaddingException != null) {
                        throw badPaddingException;
                    }
                }
                throw new BadPaddingException(invalidCipherTextException.getMessage());
            }
        }

        static {
            Class clazz = ClassUtil.loadClass(BaseBlockCipher.class, "javax.crypto.AEADBadTagException");
            aeadBadTagConstructor = clazz != null ? AEADGenericBlockCipher.findExceptionConstructor(clazz) : null;
        }
    }

    private static class BufferedGenericBlockCipher
    implements GenericBlockCipher {
        private BufferedBlockCipher cipher;

        BufferedGenericBlockCipher(BufferedBlockCipher bufferedBlockCipher) {
            this.cipher = bufferedBlockCipher;
        }

        BufferedGenericBlockCipher(BlockCipher blockCipher) {
            this.cipher = new PaddedBufferedBlockCipher(blockCipher);
        }

        BufferedGenericBlockCipher(BlockCipher blockCipher, BlockCipherPadding blockCipherPadding) {
            this.cipher = new PaddedBufferedBlockCipher(blockCipher, blockCipherPadding);
        }

        @Override
        public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
            this.cipher.init(bl, cipherParameters);
        }

        @Override
        public boolean wrapOnNoPadding() {
            return !(this.cipher instanceof CTSBlockCipher);
        }

        @Override
        public String getAlgorithmName() {
            return this.cipher.getUnderlyingCipher().getAlgorithmName();
        }

        @Override
        public BlockCipher getUnderlyingCipher() {
            return this.cipher.getUnderlyingCipher();
        }

        @Override
        public int getOutputSize(int n) {
            return this.cipher.getOutputSize(n);
        }

        @Override
        public int getUpdateOutputSize(int n) {
            return this.cipher.getUpdateOutputSize(n);
        }

        @Override
        public void updateAAD(byte[] byArray, int n, int n2) {
            throw new UnsupportedOperationException("AAD is not supported in the current mode.");
        }

        @Override
        public int processByte(byte by, byte[] byArray, int n) throws DataLengthException {
            return this.cipher.processByte(by, byArray, n);
        }

        @Override
        public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException {
            return this.cipher.processBytes(byArray, n, n2, byArray2, n3);
        }

        @Override
        public int doFinal(byte[] byArray, int n) throws IllegalStateException, BadPaddingException {
            try {
                return this.cipher.doFinal(byArray, n);
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                throw new BadPaddingException(invalidCipherTextException.getMessage());
            }
        }
    }

    private static interface GenericBlockCipher {
        public void init(boolean var1, CipherParameters var2) throws IllegalArgumentException;

        public boolean wrapOnNoPadding();

        public String getAlgorithmName();

        public BlockCipher getUnderlyingCipher();

        public int getOutputSize(int var1);

        public int getUpdateOutputSize(int var1);

        public void updateAAD(byte[] var1, int var2, int var3);

        public int processByte(byte var1, byte[] var2, int var3) throws DataLengthException;

        public int processBytes(byte[] var1, int var2, int var3, byte[] var4, int var5) throws DataLengthException;

        public int doFinal(byte[] var1, int var2) throws IllegalStateException, BadPaddingException;
    }
}

