/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.symmetric;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Enumeration;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.bouncycastle.asn1.pkcs.PBES2Parameters;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameters;
import org.bouncycastle.jcajce.provider.symmetric.util.PBE;
import org.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public class PBES2AlgorithmParameters {
    private PBES2AlgorithmParameters() {
    }

    private static PBEParameterSpec createPBEParameterSpec(byte[] byArray, int n, byte[] byArray2) {
        try {
            Class<?> clazz = PBES2AlgorithmParameters.class.getClassLoader().loadClass("javax.crypto.spec.PBEParameterSpec");
            Constructor<?> constructor = clazz.getConstructor(byte[].class, Integer.TYPE, AlgorithmParameterSpec.class);
            return (PBEParameterSpec)constructor.newInstance(byArray, n, new IvParameterSpec(byArray2));
        }
        catch (Exception exception) {
            throw new IllegalStateException("Requested creation PBES2 parameters in an SDK that doesn't support them", exception);
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = PBES2AlgorithmParameters.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            int[] nArray = new int[]{128, 256};
            int[] nArray2 = new int[]{1, 224, 256, 384, 512};
            for (int n : nArray) {
                for (int n2 : nArray2) {
                    configurableProvider.addAlgorithm("AlgorithmParameters.PBEWithHmacSHA" + n2 + "AndAES_" + n, PREFIX + "$PBEWithHmacSHA" + n2 + "AES" + n + "AlgorithmParameters");
                }
            }
        }
    }

    public static class PBEWithHmacSHA512AES256AlgorithmParameters
    extends BasePBEWithHmacAlgorithmParameters {
        public PBEWithHmacSHA512AES256AlgorithmParameters() {
            super(PKCSObjectIdentifiers.id_hmacWithSHA512, "HmacSHA512", 32, NISTObjectIdentifiers.id_aes256_CBC, "AES256");
        }
    }

    public static class PBEWithHmacSHA384AES256AlgorithmParameters
    extends BasePBEWithHmacAlgorithmParameters {
        public PBEWithHmacSHA384AES256AlgorithmParameters() {
            super(PKCSObjectIdentifiers.id_hmacWithSHA384, "HmacSHA384", 32, NISTObjectIdentifiers.id_aes256_CBC, "AES256");
        }
    }

    public static class PBEWithHmacSHA256AES256AlgorithmParameters
    extends BasePBEWithHmacAlgorithmParameters {
        public PBEWithHmacSHA256AES256AlgorithmParameters() {
            super(PKCSObjectIdentifiers.id_hmacWithSHA256, "HmacSHA256", 32, NISTObjectIdentifiers.id_aes256_CBC, "AES256");
        }
    }

    public static class PBEWithHmacSHA224AES256AlgorithmParameters
    extends BasePBEWithHmacAlgorithmParameters {
        public PBEWithHmacSHA224AES256AlgorithmParameters() {
            super(PKCSObjectIdentifiers.id_hmacWithSHA224, "HmacSHA224", 32, NISTObjectIdentifiers.id_aes256_CBC, "AES256");
        }
    }

    public static class PBEWithHmacSHA1AES256AlgorithmParameters
    extends BasePBEWithHmacAlgorithmParameters {
        public PBEWithHmacSHA1AES256AlgorithmParameters() {
            super(PKCSObjectIdentifiers.id_hmacWithSHA1, "HmacSHA1", 32, NISTObjectIdentifiers.id_aes256_CBC, "AES256");
        }
    }

    public static class PBEWithHmacSHA512AES128AlgorithmParameters
    extends BasePBEWithHmacAlgorithmParameters {
        public PBEWithHmacSHA512AES128AlgorithmParameters() {
            super(PKCSObjectIdentifiers.id_hmacWithSHA512, "HmacSHA512", 16, NISTObjectIdentifiers.id_aes128_CBC, "AES128");
        }
    }

    public static class PBEWithHmacSHA384AES128AlgorithmParameters
    extends BasePBEWithHmacAlgorithmParameters {
        public PBEWithHmacSHA384AES128AlgorithmParameters() {
            super(PKCSObjectIdentifiers.id_hmacWithSHA384, "HmacSHA384", 16, NISTObjectIdentifiers.id_aes128_CBC, "AES128");
        }
    }

    public static class PBEWithHmacSHA256AES128AlgorithmParameters
    extends BasePBEWithHmacAlgorithmParameters {
        public PBEWithHmacSHA256AES128AlgorithmParameters() {
            super(PKCSObjectIdentifiers.id_hmacWithSHA256, "HmacSHA256", 16, NISTObjectIdentifiers.id_aes128_CBC, "AES128");
        }
    }

    public static class PBEWithHmacSHA224AES128AlgorithmParameters
    extends BasePBEWithHmacAlgorithmParameters {
        public PBEWithHmacSHA224AES128AlgorithmParameters() {
            super(PKCSObjectIdentifiers.id_hmacWithSHA224, "HmacSHA224", 16, NISTObjectIdentifiers.id_aes128_CBC, "AES128");
        }
    }

    public static class PBEWithHmacSHA1AES128AlgorithmParameters
    extends BasePBEWithHmacAlgorithmParameters {
        public PBEWithHmacSHA1AES128AlgorithmParameters() {
            super(PKCSObjectIdentifiers.id_hmacWithSHA1, "HmacSHA1", 16, NISTObjectIdentifiers.id_aes128_CBC, "AES128");
        }
    }

    private static abstract class BasePBEWithHmacAlgorithmParameters
    extends BaseAlgorithmParameters {
        private final AlgorithmIdentifier kdf;
        private final String kdfShortName;
        private final int keySize;
        private final ASN1ObjectIdentifier cipherAlgorithm;
        private final String cipherAlgorithmShortName;
        private PBES2Parameters params;

        private BasePBEWithHmacAlgorithmParameters(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string, int n, ASN1ObjectIdentifier aSN1ObjectIdentifier2, String string2) {
            this.kdf = new AlgorithmIdentifier(aSN1ObjectIdentifier, DERNull.INSTANCE);
            this.kdfShortName = string;
            this.keySize = n;
            this.cipherAlgorithm = aSN1ObjectIdentifier2;
            this.cipherAlgorithmShortName = string2;
        }

        @Override
        protected byte[] engineGetEncoded() {
            try {
                return new DERSequence(new ASN1Encodable[]{PKCSObjectIdentifiers.id_PBES2, this.params}).getEncoded();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Unable to read PBES2 parameters: " + iOException.toString());
            }
        }

        @Override
        protected byte[] engineGetEncoded(String string) {
            if (this.isASN1FormatString(string)) {
                return this.engineGetEncoded();
            }
            return null;
        }

        @Override
        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == PBEParameterSpec.class) {
                PBKDF2Params pBKDF2Params = (PBKDF2Params)this.params.getKeyDerivationFunc().getParameters();
                byte[] byArray = ((ASN1OctetString)this.params.getEncryptionScheme().getParameters()).getOctets();
                return PBES2AlgorithmParameters.createPBEParameterSpec(pBKDF2Params.getSalt(), pBKDF2Params.getIterationCount().intValue(), byArray);
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to PBES2 parameters object.");
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
                throw new InvalidParameterSpecException("PBEParameterSpec required to initialise PBES2 algorithm parameters");
            }
            PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
            AlgorithmParameterSpec algorithmParameterSpec2 = PBE.Util.getParameterSpecFromPBEParameterSpec(pBEParameterSpec);
            if (!(algorithmParameterSpec2 instanceof IvParameterSpec)) {
                throw new IllegalArgumentException("Expecting an IV as a parameter");
            }
            byte[] byArray = ((IvParameterSpec)algorithmParameterSpec2).getIV();
            this.params = new PBES2Parameters(new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, new PBKDF2Params(pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount(), this.keySize, this.kdf)), new EncryptionScheme(this.cipherAlgorithm, new DEROctetString(byArray)));
        }

        @Override
        protected void engineInit(byte[] byArray) throws IOException {
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(ASN1Primitive.fromByteArray(byArray));
            Enumeration enumeration = aSN1Sequence.getObjects();
            ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
            if (!aSN1ObjectIdentifier.getId().equals(PKCSObjectIdentifiers.id_PBES2.getId())) {
                throw new IllegalArgumentException("Invalid PBES2 parameters");
            }
            this.params = PBES2Parameters.getInstance(enumeration.nextElement());
        }

        @Override
        protected void engineInit(byte[] byArray, String string) throws IOException {
            if (this.isASN1FormatString(string)) {
                this.engineInit(byArray);
                return;
            }
            throw new IOException("Unknown parameters format in PBES2 parameters object");
        }

        @Override
        protected String engineToString() {
            return "PBES2 " + this.kdfShortName + " " + this.cipherAlgorithmShortName + " Parameters";
        }
    }
}

