/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import java.security.Security;
import java.util.Locale;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.AndroidDigestFactoryBouncyCastle;
import org.bouncycastle.crypto.digests.AndroidDigestFactoryInterface;
import org.bouncycastle.crypto.digests.AndroidDigestFactoryOpenSSL;

public final class AndroidDigestFactory {
    private static final AndroidDigestFactoryInterface CONSCRYPT;
    private static final AndroidDigestFactoryInterface BC;

    public static Digest getMD5() {
        if (CONSCRYPT != null) {
            try {
                return CONSCRYPT.getMD5();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return BC.getMD5();
    }

    public static Digest getSHA1() {
        if (CONSCRYPT != null) {
            try {
                return CONSCRYPT.getSHA1();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return BC.getSHA1();
    }

    public static Digest getSHA224() {
        if (CONSCRYPT != null) {
            try {
                return CONSCRYPT.getSHA224();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return BC.getSHA224();
    }

    public static Digest getSHA256() {
        if (CONSCRYPT != null) {
            try {
                return CONSCRYPT.getSHA256();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return BC.getSHA256();
    }

    public static Digest getSHA384() {
        if (CONSCRYPT != null) {
            try {
                return CONSCRYPT.getSHA384();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return BC.getSHA384();
    }

    public static Digest getSHA512() {
        if (CONSCRYPT != null) {
            try {
                return CONSCRYPT.getSHA512();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return BC.getSHA512();
    }

    static {
        BC = new AndroidDigestFactoryBouncyCastle();
        if (Security.getProvider("AndroidOpenSSL") != null) {
            CONSCRYPT = new AndroidDigestFactoryOpenSSL();
        } else {
            if (System.getProperty("java.vendor", "").toLowerCase(Locale.US).contains("android")) {
                throw new AssertionError((Object)"Provider AndroidOpenSSL must exist");
            }
            CONSCRYPT = null;
        }
    }
}

