/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BEROctetStringGenerator;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.cert.X509AttributeCertificateHolder;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.NullOutputStream;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.io.Streams;
import org.bouncycastle.util.io.TeeInputStream;
import org.bouncycastle.util.io.TeeOutputStream;

class CMSUtils {
    private static final Set<String> des = new HashSet<String>();
    private static final Set mqvAlgs = new HashSet();
    private static final Set ecAlgs = new HashSet();
    private static final Set gostAlgs = new HashSet();

    CMSUtils() {
    }

    static boolean isMQV(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return mqvAlgs.contains(aSN1ObjectIdentifier);
    }

    static boolean isEC(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return ecAlgs.contains(aSN1ObjectIdentifier);
    }

    static boolean isGOST(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return gostAlgs.contains(aSN1ObjectIdentifier);
    }

    static boolean isDES(String string) {
        String string2 = Strings.toUpperCase(string);
        return des.contains(string2);
    }

    static boolean isEquivalent(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2) {
        if (algorithmIdentifier == null || algorithmIdentifier2 == null) {
            return false;
        }
        if (!algorithmIdentifier.getAlgorithm().equals(algorithmIdentifier2.getAlgorithm())) {
            return false;
        }
        ASN1Encodable aSN1Encodable = algorithmIdentifier.getParameters();
        ASN1Encodable aSN1Encodable2 = algorithmIdentifier2.getParameters();
        if (aSN1Encodable != null) {
            return aSN1Encodable.equals(aSN1Encodable2) || aSN1Encodable.equals(DERNull.INSTANCE) && aSN1Encodable2 == null;
        }
        return aSN1Encodable2 == null || aSN1Encodable2.equals(DERNull.INSTANCE);
    }

    static ContentInfo readContentInfo(byte[] byArray) throws CMSException {
        return CMSUtils.readContentInfo(new ASN1InputStream(byArray));
    }

    static ContentInfo readContentInfo(InputStream inputStream) throws CMSException {
        return CMSUtils.readContentInfo(new ASN1InputStream(inputStream));
    }

    static List getCertificatesFromStore(Store store) throws CMSException {
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        try {
            for (X509CertificateHolder x509CertificateHolder : store.getMatches(null)) {
                arrayList.add(x509CertificateHolder.toASN1Structure());
            }
            return arrayList;
        }
        catch (ClassCastException classCastException) {
            throw new CMSException("error processing certs", classCastException);
        }
    }

    static List getAttributeCertificatesFromStore(Store store) throws CMSException {
        ArrayList<DERTaggedObject> arrayList = new ArrayList<DERTaggedObject>();
        try {
            for (X509AttributeCertificateHolder x509AttributeCertificateHolder : store.getMatches(null)) {
                arrayList.add(new DERTaggedObject(false, 2, x509AttributeCertificateHolder.toASN1Structure()));
            }
            return arrayList;
        }
        catch (ClassCastException classCastException) {
            throw new CMSException("error processing certs", classCastException);
        }
    }

    static List getCRLsFromStore(Store store) throws CMSException {
        ArrayList<CertificateList> arrayList = new ArrayList<CertificateList>();
        try {
            for (Object t : store.getMatches(null)) {
                if (t instanceof X509CRLHolder) {
                    X509CRLHolder x509CRLHolder = (X509CRLHolder)t;
                    arrayList.add(x509CRLHolder.toASN1Structure());
                    continue;
                }
                if (!(t instanceof ASN1TaggedObject)) continue;
                arrayList.add((CertificateList)t);
            }
            return arrayList;
        }
        catch (ClassCastException classCastException) {
            throw new CMSException("error processing certs", classCastException);
        }
    }

    static ASN1Set createBerSetFromList(List list) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            aSN1EncodableVector.add((ASN1Encodable)iterator.next());
        }
        return new BERSet(aSN1EncodableVector);
    }

    static ASN1Set createDerSetFromList(List list) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            aSN1EncodableVector.add((ASN1Encodable)iterator.next());
        }
        return new DERSet(aSN1EncodableVector);
    }

    static OutputStream createBEROctetOutputStream(OutputStream outputStream, int n, boolean bl, int n2) throws IOException {
        BEROctetStringGenerator bEROctetStringGenerator = new BEROctetStringGenerator(outputStream, n, bl);
        if (n2 != 0) {
            return bEROctetStringGenerator.getOctetOutputStream(new byte[n2]);
        }
        return bEROctetStringGenerator.getOctetOutputStream();
    }

    private static ContentInfo readContentInfo(ASN1InputStream aSN1InputStream) throws CMSException {
        try {
            ContentInfo contentInfo = ContentInfo.getInstance(aSN1InputStream.readObject());
            if (contentInfo == null) {
                throw new CMSException("No content found.");
            }
            return contentInfo;
        }
        catch (IOException iOException) {
            throw new CMSException("IOException reading content.", iOException);
        }
        catch (ClassCastException classCastException) {
            throw new CMSException("Malformed content.", classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("Malformed content.", illegalArgumentException);
        }
    }

    public static byte[] streamToByteArray(InputStream inputStream) throws IOException {
        return Streams.readAll(inputStream);
    }

    public static byte[] streamToByteArray(InputStream inputStream, int n) throws IOException {
        return Streams.readAllLimited(inputStream, n);
    }

    static InputStream attachDigestsToInputStream(Collection collection, InputStream inputStream) {
        InputStream inputStream2 = inputStream;
        for (DigestCalculator digestCalculator : collection) {
            inputStream2 = new TeeInputStream(inputStream2, digestCalculator.getOutputStream());
        }
        return inputStream2;
    }

    static OutputStream attachSignersToOutputStream(Collection collection, OutputStream outputStream) {
        OutputStream outputStream2 = outputStream;
        for (SignerInfoGenerator signerInfoGenerator : collection) {
            outputStream2 = CMSUtils.getSafeTeeOutputStream(outputStream2, signerInfoGenerator.getCalculatingOutputStream());
        }
        return outputStream2;
    }

    static OutputStream getSafeOutputStream(OutputStream outputStream) {
        return outputStream == null ? new NullOutputStream() : outputStream;
    }

    static OutputStream getSafeTeeOutputStream(OutputStream outputStream, OutputStream outputStream2) {
        return outputStream == null ? CMSUtils.getSafeOutputStream(outputStream2) : (outputStream2 == null ? CMSUtils.getSafeOutputStream(outputStream) : new TeeOutputStream(outputStream, outputStream2));
    }

    static {
        des.add("DES");
        des.add("DESEDE");
    }
}

