/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.util;

import com.android.apksig.internal.util.ByteBufferDataSource;
import com.android.apksig.internal.util.FileChannelDataSource;
import com.android.apksig.util.DataSource;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public abstract class DataSources {
    private DataSources() {
    }

    public static DataSource asDataSource(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        return new ByteBufferDataSource(byteBuffer);
    }

    public static DataSource asDataSource(RandomAccessFile randomAccessFile) {
        return DataSources.asDataSource(randomAccessFile.getChannel());
    }

    public static DataSource asDataSource(RandomAccessFile randomAccessFile, long l, long l2) {
        return DataSources.asDataSource(randomAccessFile.getChannel(), l, l2);
    }

    public static DataSource asDataSource(FileChannel fileChannel) {
        if (fileChannel == null) {
            throw new NullPointerException();
        }
        return new FileChannelDataSource(fileChannel);
    }

    public static DataSource asDataSource(FileChannel fileChannel, long l, long l2) {
        if (fileChannel == null) {
            throw new NullPointerException();
        }
        return new FileChannelDataSource(fileChannel, l, l2);
    }
}

