/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.util;

import com.android.apksig.internal.util.ByteBufferSink;
import com.android.apksig.internal.util.ChainedDataSource;
import com.android.apksig.internal.zip.ZipUtils;
import com.android.apksig.util.DataSink;
import com.android.apksig.util.DataSource;
import com.android.apksig.util.DataSources;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Phaser;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class VerityTreeBuilder
implements AutoCloseable {
    private static final int CHUNK_SIZE = 4096;
    private static final int DIGEST_PARALLELISM = Math.min(32, Runtime.getRuntime().availableProcessors());
    private static final int MAX_OUTSTANDING_CHUNKS = 4;
    private static final int MAX_PREFETCH_CHUNKS = 1024;
    private static final int MIN_CHUNKS_PER_WORKER = 8;
    private static final String JCA_ALGORITHM = "SHA-256";
    private final byte[] mSalt;
    private final MessageDigest mMd;
    private final ExecutorService mExecutor = new ThreadPoolExecutor(DIGEST_PARALLELISM, DIGEST_PARALLELISM, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(4), new ThreadPoolExecutor.CallerRunsPolicy());

    public VerityTreeBuilder(byte[] byArray) throws NoSuchAlgorithmException {
        this.mSalt = byArray;
        this.mMd = VerityTreeBuilder.getNewMessageDigest();
    }

    @Override
    public void close() {
        this.mExecutor.shutdownNow();
    }

    public byte[] generateVerityTreeRootHash(DataSource dataSource, DataSource dataSource2, DataSource dataSource3) throws IOException {
        if (dataSource.size() % 4096L != 0L) {
            throw new IllegalStateException("APK Signing Block size not a multiple of 4096: " + dataSource.size());
        }
        long l = dataSource.size();
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)dataSource3.size());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        dataSource3.copyTo(0L, (int)dataSource3.size(), byteBuffer);
        byteBuffer.flip();
        ZipUtils.setZipEocdCentralDirectoryOffset(byteBuffer, l);
        return this.generateVerityTreeRootHash(new ChainedDataSource(dataSource, dataSource2, DataSources.asDataSource(byteBuffer)));
    }

    public byte[] generateVerityTreeRootHash(DataSource dataSource) throws IOException {
        ByteBuffer byteBuffer = this.generateVerityTree(dataSource);
        return this.getRootHashFromTree(byteBuffer);
    }

    public ByteBuffer generateVerityTree(DataSource dataSource) throws IOException {
        int n = this.mMd.getDigestLength();
        int[] nArray = VerityTreeBuilder.calculateLevelOffset(dataSource.size(), n);
        ByteBuffer byteBuffer = ByteBuffer.allocate(nArray[nArray.length - 1]);
        for (int i = nArray.length - 2; i >= 0; --i) {
            DataSource dataSource2;
            ByteBufferSink byteBufferSink = new ByteBufferSink(VerityTreeBuilder.slice(byteBuffer, nArray[i], nArray[i + 1]));
            if (i == nArray.length - 2) {
                dataSource2 = dataSource;
                this.digestDataByChunks(dataSource2, byteBufferSink);
            } else {
                dataSource2 = DataSources.asDataSource(VerityTreeBuilder.slice(byteBuffer.asReadOnlyBuffer(), nArray[i + 1], nArray[i + 2]));
                this.digestDataByChunks(dataSource2, byteBufferSink);
            }
            long l = VerityTreeBuilder.divideRoundup(dataSource2.size(), 4096L) * (long)n;
            int n2 = (int)(l % 4096L);
            if (n2 <= 0) continue;
            byte[] byArray = new byte[4096 - n2];
            byteBufferSink.consume(byArray, 0, byArray.length);
        }
        return byteBuffer;
    }

    public byte[] getRootHashFromTree(ByteBuffer byteBuffer) throws IOException {
        ByteBuffer byteBuffer2 = VerityTreeBuilder.slice(byteBuffer.asReadOnlyBuffer(), 0, 4096);
        return this.saltedDigest(byteBuffer2);
    }

    private static int[] calculateLevelOffset(long l, int n) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        while (true) {
            long l2 = VerityTreeBuilder.divideRoundup(l, 4096L);
            long l3 = 4096L * VerityTreeBuilder.divideRoundup(l2 * (long)n, 4096L);
            arrayList.add(l3);
            if (l2 * (long)n <= 4096L) break;
            l = l2 * (long)n;
        }
        int[] nArray = new int[arrayList.size() + 1];
        nArray[0] = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            nArray[i + 1] = nArray[i] + Math.toIntExact((Long)arrayList.get(arrayList.size() - i - 1));
        }
        return nArray;
    }

    private void digestDataByChunks(DataSource dataSource, DataSink dataSink) throws IOException {
        int n;
        long l = dataSource.size();
        int n2 = (int)VerityTreeBuilder.divideRoundup(l, 4096L);
        byte[][] byArrayArray = new byte[n2][];
        Phaser phaser = new Phaser(1);
        int n3 = 0;
        for (long i = 0L; i < l; i += (long)n) {
            long l2 = Math.min(i + 0x400000L, l);
            n = (int)(l2 - i);
            int n4 = (int)VerityTreeBuilder.divideRoundup(n, 4096L);
            ByteBuffer byteBuffer = ByteBuffer.allocate(n4 * 4096);
            dataSource.copyTo(i, n, byteBuffer);
            byteBuffer.rewind();
            int n5 = n3;
            Runnable runnable = () -> {
                MessageDigest messageDigest = this.cloneMessageDigest();
                int n2 = 0;
                int n3 = byteBuffer.capacity();
                int n4 = n5;
                while (n2 < n3) {
                    ByteBuffer byteBuffer2 = VerityTreeBuilder.slice(byteBuffer, n2, n2 + 4096);
                    byArray[n4] = this.saltedDigest(messageDigest, byteBuffer2);
                    n2 += 4096;
                    ++n4;
                }
                phaser.arriveAndDeregister();
            };
            phaser.register();
            this.mExecutor.execute(runnable);
            n3 += n4;
        }
        phaser.arriveAndAwaitAdvance();
        for (byte[] byArray : byArrayArray) {
            dataSink.consume(byArray, 0, byArray.length);
        }
    }

    private byte[] saltedDigest(ByteBuffer byteBuffer) {
        return this.saltedDigest(this.mMd, byteBuffer);
    }

    private byte[] saltedDigest(MessageDigest messageDigest, ByteBuffer byteBuffer) {
        messageDigest.reset();
        if (this.mSalt != null) {
            messageDigest.update(this.mSalt);
        }
        messageDigest.update(byteBuffer);
        return messageDigest.digest();
    }

    private static long divideRoundup(long l, long l2) {
        return (l + l2 - 1L) / l2;
    }

    private static ByteBuffer slice(ByteBuffer byteBuffer, int n, int n2) {
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        byteBuffer2.position(0);
        byteBuffer2.limit(n2);
        byteBuffer2.position(n);
        return byteBuffer2.slice();
    }

    private static MessageDigest getNewMessageDigest() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(JCA_ALGORITHM);
    }

    private MessageDigest cloneMessageDigest() {
        try {
            return (MessageDigest)this.mMd.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            try {
                return VerityTreeBuilder.getNewMessageDigest();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IllegalStateException("Failed to obtain an instance of a previously available message digest", noSuchAlgorithmException);
            }
        }
    }
}

