/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.util;

import com.android.apksig.util.DataSink;
import com.android.apksig.util.DataSource;
import com.android.apksig.util.ReadableDataSink;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ByteArrayDataSink
implements ReadableDataSink {
    private static final int MAX_READ_CHUNK_SIZE = 65536;
    private byte[] mArray;
    private int mSize;

    public ByteArrayDataSink() {
        this(65536);
    }

    public ByteArrayDataSink(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("initial capacity: " + n);
        }
        this.mArray = new byte[n];
    }

    @Override
    public void consume(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0) {
            throw new IndexOutOfBoundsException("offset: " + n);
        }
        if (n > byArray.length) {
            throw new IndexOutOfBoundsException("offset: " + n + ", buf.length: " + byArray.length);
        }
        if (n2 == 0) {
            return;
        }
        this.ensureAvailable(n2);
        System.arraycopy(byArray, n, this.mArray, this.mSize, n2);
        this.mSize += n2;
    }

    @Override
    public void consume(ByteBuffer byteBuffer) throws IOException {
        if (!byteBuffer.hasRemaining()) {
            return;
        }
        if (byteBuffer.hasArray()) {
            this.consume(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            byteBuffer.position(byteBuffer.limit());
            return;
        }
        this.ensureAvailable(byteBuffer.remaining());
        byte[] byArray = new byte[Math.min(byteBuffer.remaining(), 65536)];
        while (byteBuffer.hasRemaining()) {
            int n = Math.min(byteBuffer.remaining(), byArray.length);
            byteBuffer.get(byArray, 0, n);
            System.arraycopy(byArray, 0, this.mArray, this.mSize, n);
            this.mSize += n;
        }
    }

    private void ensureAvailable(int n) throws IOException {
        if (n <= 0) {
            return;
        }
        long l = (long)this.mSize + (long)n;
        if (l <= (long)this.mArray.length) {
            return;
        }
        if (l > Integer.MAX_VALUE) {
            throw new IOException("Required capacity too large: " + l + ", max: " + Integer.MAX_VALUE);
        }
        int n2 = (int)Math.min((long)this.mArray.length * 2L, Integer.MAX_VALUE);
        int n3 = (int)Math.max(l, (long)n2);
        this.mArray = Arrays.copyOf(this.mArray, n3);
    }

    @Override
    public long size() {
        return this.mSize;
    }

    @Override
    public ByteBuffer getByteBuffer(long l, int n) {
        this.checkChunkValid(l, n);
        return ByteBuffer.wrap(this.mArray, (int)l, n).slice();
    }

    @Override
    public void feed(long l, long l2, DataSink dataSink) throws IOException {
        this.checkChunkValid(l, l2);
        dataSink.consume(this.mArray, (int)l, (int)l2);
    }

    @Override
    public void copyTo(long l, int n, ByteBuffer byteBuffer) throws IOException {
        this.checkChunkValid(l, n);
        byteBuffer.put(this.mArray, (int)l, n);
    }

    private void checkChunkValid(long l, long l2) {
        if (l < 0L) {
            throw new IndexOutOfBoundsException("offset: " + l);
        }
        if (l2 < 0L) {
            throw new IndexOutOfBoundsException("size: " + l2);
        }
        if (l > (long)this.mSize) {
            throw new IndexOutOfBoundsException("offset (" + l + ") > source size (" + this.mSize + ")");
        }
        long l3 = l + l2;
        if (l3 < l) {
            throw new IndexOutOfBoundsException("offset (" + l + ") + size (" + l2 + ") overflow");
        }
        if (l3 > (long)this.mSize) {
            throw new IndexOutOfBoundsException("offset (" + l + ") + size (" + l2 + ") > source size (" + this.mSize + ")");
        }
    }

    @Override
    public DataSource slice(long l, long l2) {
        this.checkChunkValid(l, l2);
        return new SliceDataSource((int)l, (int)l2);
    }

    private class SliceDataSource
    implements DataSource {
        private final int mSliceOffset;
        private final int mSliceSize;

        private SliceDataSource(int n, int n2) {
            this.mSliceOffset = n;
            this.mSliceSize = n2;
        }

        @Override
        public long size() {
            return this.mSliceSize;
        }

        @Override
        public void feed(long l, long l2, DataSink dataSink) throws IOException {
            this.checkChunkValid(l, l2);
            dataSink.consume(ByteArrayDataSink.this.mArray, (int)((long)this.mSliceOffset + l), (int)l2);
        }

        @Override
        public ByteBuffer getByteBuffer(long l, int n) throws IOException {
            this.checkChunkValid(l, n);
            return ByteBuffer.wrap(ByteArrayDataSink.this.mArray, (int)((long)this.mSliceOffset + l), n).slice();
        }

        @Override
        public void copyTo(long l, int n, ByteBuffer byteBuffer) throws IOException {
            this.checkChunkValid(l, n);
            byteBuffer.put(ByteArrayDataSink.this.mArray, (int)((long)this.mSliceOffset + l), n);
        }

        @Override
        public DataSource slice(long l, long l2) {
            this.checkChunkValid(l, l2);
            return new SliceDataSource((int)((long)this.mSliceOffset + l), (int)l2);
        }

        private void checkChunkValid(long l, long l2) {
            if (l < 0L) {
                throw new IndexOutOfBoundsException("offset: " + l);
            }
            if (l2 < 0L) {
                throw new IndexOutOfBoundsException("size: " + l2);
            }
            if (l > (long)this.mSliceSize) {
                throw new IndexOutOfBoundsException("offset (" + l + ") > source size (" + this.mSliceSize + ")");
            }
            long l3 = l + l2;
            if (l3 < l) {
                throw new IndexOutOfBoundsException("offset (" + l + ") + size (" + l2 + ") overflow");
            }
            if (l3 > (long)this.mSliceSize) {
                throw new IndexOutOfBoundsException("offset (" + l + ") + size (" + l2 + ") > source size (" + this.mSliceSize + ")");
            }
        }
    }
}

