/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.v4;

import com.android.apksig.ApkVerifier;
import com.android.apksig.internal.apk.ApkSigningBlockUtils;
import com.android.apksig.internal.apk.ContentDigestAlgorithm;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.apk.v4.V4Signature;
import com.android.apksig.internal.util.GuaranteedEncodedFormX509Certificate;
import com.android.apksig.internal.util.X509CertificateUtils;
import com.android.apksig.util.DataSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;

public abstract class V4SchemeVerifier {
    private V4SchemeVerifier() {
    }

    public static ApkSigningBlockUtils.Result verify(DataSource dataSource, File file) throws IOException, NoSuchAlgorithmException {
        byte[] byArray;
        V4Signature v4Signature;
        try (Object object = new FileInputStream(file);){
            v4Signature = V4Signature.readFrom((InputStream)object);
            byArray = V4Signature.readBytes((InputStream)object);
        }
        object = new ApkSigningBlockUtils.Result(4);
        if (v4Signature == null) {
            ((ApkSigningBlockUtils.Result)object).addError(ApkVerifier.Issue.V4_SIG_NO_SIGNATURES, "Signature file does not contain a v4 signature.");
            return object;
        }
        if (v4Signature.version != 2) {
            ((ApkSigningBlockUtils.Result)object).addWarning(ApkVerifier.Issue.V4_SIG_VERSION_NOT_CURRENT, v4Signature.version, 2);
        }
        V4Signature.HashingInfo hashingInfo = V4Signature.HashingInfo.fromByteArray(v4Signature.hashingInfo);
        V4Signature.SigningInfo signingInfo = V4Signature.SigningInfo.fromByteArray(v4Signature.signingInfo);
        byte[] byArray2 = V4Signature.getSigningData(dataSource.size(), hashingInfo, signingInfo);
        ApkSigningBlockUtils.Result.SignerInfo signerInfo = V4SchemeVerifier.parseAndVerifySignatureBlock(signingInfo, byArray2);
        ((ApkSigningBlockUtils.Result)object).signers.add(signerInfo);
        if (((ApkSigningBlockUtils.Result)object).containsErrors()) {
            return object;
        }
        V4SchemeVerifier.verifyRootHashAndTree(dataSource, signerInfo, hashingInfo.rawRootHash, byArray);
        if (!((ApkSigningBlockUtils.Result)object).containsErrors()) {
            ((ApkSigningBlockUtils.Result)object).verified = true;
        }
        return object;
    }

    private static ApkSigningBlockUtils.Result.SignerInfo parseAndVerifySignatureBlock(V4Signature.SigningInfo signingInfo, byte[] byArray) throws NoSuchAlgorithmException {
        byte[] byArray2;
        Object object;
        PublicKey publicKey;
        ApkSigningBlockUtils.Result.SignerInfo signerInfo = new ApkSigningBlockUtils.Result.SignerInfo();
        signerInfo.index = 0;
        int n = signingInfo.signatureAlgorithmId;
        byte[] byArray3 = signingInfo.signature;
        signerInfo.signatures.add(new ApkSigningBlockUtils.Result.SignerInfo.Signature(n, byArray3));
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.findById(n);
        if (signatureAlgorithm == null) {
            signerInfo.addError(ApkVerifier.Issue.V4_SIG_UNKNOWN_SIG_ALGORITHM, n);
            return signerInfo;
        }
        String string = signatureAlgorithm.getJcaSignatureAlgorithmAndParams().getFirst();
        AlgorithmParameterSpec algorithmParameterSpec = signatureAlgorithm.getJcaSignatureAlgorithmAndParams().getSecond();
        String string2 = signatureAlgorithm.getJcaKeyAlgorithm();
        byte[] byArray4 = signingInfo.publicKey;
        try {
            publicKey = KeyFactory.getInstance(string2).generatePublic(new X509EncodedKeySpec(byArray4));
        }
        catch (Exception exception) {
            signerInfo.addError(ApkVerifier.Issue.V4_SIG_MALFORMED_PUBLIC_KEY, exception);
            return signerInfo;
        }
        try {
            object = Signature.getInstance(string);
            ((Signature)object).initVerify(publicKey);
            if (algorithmParameterSpec != null) {
                ((Signature)object).setParameter(algorithmParameterSpec);
            }
            ((Signature)object).update(byArray);
            if (!((Signature)object).verify(byArray3)) {
                signerInfo.addError(ApkVerifier.Issue.V4_SIG_DID_NOT_VERIFY, new Object[]{signatureAlgorithm});
                return signerInfo;
            }
            signerInfo.verifiedSignatures.put(signatureAlgorithm, byArray3);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | SignatureException generalSecurityException) {
            signerInfo.addError(ApkVerifier.Issue.V4_SIG_VERIFY_EXCEPTION, new Object[]{signatureAlgorithm, generalSecurityException});
            return signerInfo;
        }
        if (signingInfo.certificate == null) {
            signerInfo.addError(ApkVerifier.Issue.V4_SIG_NO_CERTIFICATE, new Object[0]);
            return signerInfo;
        }
        try {
            object = new GuaranteedEncodedFormX509Certificate(X509CertificateUtils.generateCertificate(signingInfo.certificate), signingInfo.certificate);
        }
        catch (CertificateException certificateException) {
            signerInfo.addError(ApkVerifier.Issue.V4_SIG_MALFORMED_CERTIFICATE, certificateException);
            return signerInfo;
        }
        signerInfo.certs.add(object);
        try {
            byArray2 = ApkSigningBlockUtils.encodePublicKey(((Certificate)object).getPublicKey());
        }
        catch (InvalidKeyException invalidKeyException) {
            System.out.println("Caught an exception encoding the public key: " + invalidKeyException);
            invalidKeyException.printStackTrace();
            byArray2 = ((Certificate)object).getPublicKey().getEncoded();
        }
        if (!Arrays.equals(byArray4, byArray2)) {
            signerInfo.addError(ApkVerifier.Issue.V4_SIG_PUBLIC_KEY_MISMATCH_BETWEEN_CERTIFICATE_AND_SIGNATURES_RECORD, ApkSigningBlockUtils.toHex(byArray2), ApkSigningBlockUtils.toHex(byArray4));
            return signerInfo;
        }
        ApkSigningBlockUtils.Result.SignerInfo.ContentDigest contentDigest = new ApkSigningBlockUtils.Result.SignerInfo.ContentDigest(0, signingInfo.apkDigest);
        signerInfo.contentDigests.add(contentDigest);
        return signerInfo;
    }

    private static void verifyRootHashAndTree(DataSource dataSource, ApkSigningBlockUtils.Result.SignerInfo signerInfo, byte[] byArray, byte[] byArray2) throws IOException, NoSuchAlgorithmException {
        ApkSigningBlockUtils.VerityTreeAndDigest verityTreeAndDigest = ApkSigningBlockUtils.computeChunkVerityTreeAndDigest(dataSource);
        ContentDigestAlgorithm contentDigestAlgorithm = verityTreeAndDigest.contentDigestAlgorithm;
        byte[] byArray3 = verityTreeAndDigest.rootHash;
        byte[] byArray4 = verityTreeAndDigest.tree;
        if (!Arrays.equals(byArray, byArray3)) {
            signerInfo.addError(ApkVerifier.Issue.V4_SIG_APK_ROOT_DID_NOT_VERIFY, new Object[]{contentDigestAlgorithm, ApkSigningBlockUtils.toHex(byArray), ApkSigningBlockUtils.toHex(byArray3)});
            return;
        }
        if (byArray2 != null && !Arrays.equals(byArray2, byArray4)) {
            signerInfo.addError(ApkVerifier.Issue.V4_SIG_APK_TREE_DID_NOT_VERIFY, new Object[]{contentDigestAlgorithm, ApkSigningBlockUtils.toHex(byArray), ApkSigningBlockUtils.toHex(byArray3)});
            return;
        }
        signerInfo.verifiedContentDigests.put(contentDigestAlgorithm, byArray3);
    }
}

