/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.v3;

import com.android.apksig.SigningCertificateLineage;
import com.android.apksig.internal.apk.ApkSigningBlockUtils;
import com.android.apksig.internal.apk.ContentDigestAlgorithm;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.util.Pair;
import com.android.apksig.util.DataSource;
import com.android.apksig.util.RunnablesExecutor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class V3SchemeSigner {
    public static final int APK_SIGNATURE_SCHEME_V3_BLOCK_ID = -262969152;
    public static final int PROOF_OF_ROTATION_ATTR_ID = 1000370060;

    private V3SchemeSigner() {
    }

    public static List<SignatureAlgorithm> getSuggestedSignatureAlgorithms(PublicKey publicKey, int n, boolean bl) throws InvalidKeyException {
        String string = publicKey.getAlgorithm();
        if ("RSA".equalsIgnoreCase(string)) {
            int n2 = ((RSAKey)((Object)publicKey)).getModulus().bitLength();
            if (n2 <= 3072) {
                ArrayList<SignatureAlgorithm> arrayList = new ArrayList<SignatureAlgorithm>();
                arrayList.add(SignatureAlgorithm.RSA_PKCS1_V1_5_WITH_SHA256);
                if (bl) {
                    arrayList.add(SignatureAlgorithm.VERITY_RSA_PKCS1_V1_5_WITH_SHA256);
                }
                return arrayList;
            }
            return Collections.singletonList(SignatureAlgorithm.RSA_PKCS1_V1_5_WITH_SHA512);
        }
        if ("DSA".equalsIgnoreCase(string)) {
            ArrayList<SignatureAlgorithm> arrayList = new ArrayList<SignatureAlgorithm>();
            arrayList.add(SignatureAlgorithm.DSA_WITH_SHA256);
            if (bl) {
                arrayList.add(SignatureAlgorithm.VERITY_DSA_WITH_SHA256);
            }
            return arrayList;
        }
        if ("EC".equalsIgnoreCase(string)) {
            int n3 = ((ECKey)((Object)publicKey)).getParams().getOrder().bitLength();
            if (n3 <= 256) {
                ArrayList<SignatureAlgorithm> arrayList = new ArrayList<SignatureAlgorithm>();
                arrayList.add(SignatureAlgorithm.ECDSA_WITH_SHA256);
                if (bl) {
                    arrayList.add(SignatureAlgorithm.VERITY_ECDSA_WITH_SHA256);
                }
                return arrayList;
            }
            return Collections.singletonList(SignatureAlgorithm.ECDSA_WITH_SHA512);
        }
        throw new InvalidKeyException("Unsupported key algorithm: " + string);
    }

    public static ApkSigningBlockUtils.SigningSchemeBlockAndDigests generateApkSignatureSchemeV3Block(RunnablesExecutor runnablesExecutor, DataSource dataSource, DataSource dataSource2, DataSource dataSource3, List<ApkSigningBlockUtils.SignerConfig> list) throws IOException, InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        Pair<List<ApkSigningBlockUtils.SignerConfig>, Map<ContentDigestAlgorithm, byte[]>> pair = ApkSigningBlockUtils.computeContentDigests(runnablesExecutor, dataSource, dataSource2, dataSource3, list);
        return new ApkSigningBlockUtils.SigningSchemeBlockAndDigests(V3SchemeSigner.generateApkSignatureSchemeV3Block(pair.getFirst(), pair.getSecond()), pair.getSecond());
    }

    public static byte[] generateV3SignerAttribute(SigningCertificateLineage signingCertificateLineage) {
        byte[] byArray = signingCertificateLineage.encodeSigningCertificateLineage();
        int n = 8 + byArray.length;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(4 + byArray.length);
        byteBuffer.putInt(1000370060);
        byteBuffer.put(byArray);
        return byteBuffer.array();
    }

    private static Pair<byte[], Integer> generateApkSignatureSchemeV3Block(List<ApkSigningBlockUtils.SignerConfig> list, Map<ContentDigestAlgorithm, byte[]> map) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(list.size());
        int n = 0;
        for (ApkSigningBlockUtils.SignerConfig signerConfig : list) {
            byte[] byArray;
            ++n;
            try {
                byArray = V3SchemeSigner.generateSignerBlock(signerConfig, map);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new InvalidKeyException("Signer #" + n + " failed", invalidKeyException);
            }
            catch (SignatureException signatureException) {
                throw new SignatureException("Signer #" + n + " failed", signatureException);
            }
            arrayList.add(byArray);
        }
        return Pair.of(ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedElements(new byte[][]{ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedElements(arrayList)}), -262969152);
    }

    private static byte[] generateSignerBlock(ApkSigningBlockUtils.SignerConfig signerConfig, Map<ContentDigestAlgorithm, byte[]> map) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (signerConfig.certificates.isEmpty()) {
            throw new SignatureException("No certificates configured for signer");
        }
        PublicKey publicKey = signerConfig.certificates.get(0).getPublicKey();
        byte[] byArray = ApkSigningBlockUtils.encodePublicKey(publicKey);
        V3SignatureSchemeBlock.SignedData signedData = new V3SignatureSchemeBlock.SignedData();
        try {
            signedData.certificates = ApkSigningBlockUtils.encodeCertificates(signerConfig.certificates);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new SignatureException("Failed to encode certificates", certificateEncodingException);
        }
        ArrayList<Pair<Integer, byte[]>> arrayList = new ArrayList<Pair<Integer, byte[]>>(signerConfig.signatureAlgorithms.size());
        for (SignatureAlgorithm signatureAlgorithm : signerConfig.signatureAlgorithms) {
            ContentDigestAlgorithm contentDigestAlgorithm = signatureAlgorithm.getContentDigestAlgorithm();
            byte[] byArray2 = map.get((Object)contentDigestAlgorithm);
            if (byArray2 == null) {
                throw new RuntimeException((Object)((Object)contentDigestAlgorithm) + " content digest for " + (Object)((Object)signatureAlgorithm) + " not computed");
            }
            arrayList.add(Pair.of(signatureAlgorithm.getId(), byArray2));
        }
        signedData.digests = arrayList;
        signedData.minSdkVersion = signerConfig.minSdkVersion;
        signedData.maxSdkVersion = signerConfig.maxSdkVersion;
        signedData.additionalAttributes = V3SchemeSigner.generateAdditionalAttributes(signerConfig);
        V3SignatureSchemeBlock.Signer signer = new V3SignatureSchemeBlock.Signer();
        signer.signedData = V3SchemeSigner.encodeSignedData(signedData);
        signer.minSdkVersion = signerConfig.minSdkVersion;
        signer.maxSdkVersion = signerConfig.maxSdkVersion;
        signer.publicKey = byArray;
        signer.signatures = ApkSigningBlockUtils.generateSignaturesOverData(signerConfig, signer.signedData);
        return V3SchemeSigner.encodeSigner(signer);
    }

    private static byte[] encodeSigner(V3SignatureSchemeBlock.Signer signer) {
        byte[] byArray = ApkSigningBlockUtils.encodeAsLengthPrefixedElement(signer.signedData);
        byte[] byArray2 = ApkSigningBlockUtils.encodeAsLengthPrefixedElement(ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(signer.signatures));
        byte[] byArray3 = ApkSigningBlockUtils.encodeAsLengthPrefixedElement(signer.publicKey);
        int n = byArray.length + 4 + 4 + byArray2.length + byArray3.length;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(byArray);
        byteBuffer.putInt(signer.minSdkVersion);
        byteBuffer.putInt(signer.maxSdkVersion);
        byteBuffer.put(byArray2);
        byteBuffer.put(byArray3);
        return byteBuffer.array();
    }

    private static byte[] encodeSignedData(V3SignatureSchemeBlock.SignedData signedData) {
        byte[] byArray = ApkSigningBlockUtils.encodeAsLengthPrefixedElement(ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(signedData.digests));
        byte[] byArray2 = ApkSigningBlockUtils.encodeAsLengthPrefixedElement(ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedElements(signedData.certificates));
        byte[] byArray3 = ApkSigningBlockUtils.encodeAsLengthPrefixedElement(signedData.additionalAttributes);
        int n = byArray.length + byArray2.length + 4 + 4 + byArray3.length;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(byArray);
        byteBuffer.put(byArray2);
        byteBuffer.putInt(signedData.minSdkVersion);
        byteBuffer.putInt(signedData.maxSdkVersion);
        byteBuffer.put(byArray3);
        return byteBuffer.array();
    }

    private static byte[] generateAdditionalAttributes(ApkSigningBlockUtils.SignerConfig signerConfig) {
        if (signerConfig.mSigningCertificateLineage == null) {
            return new byte[0];
        }
        return V3SchemeSigner.generateV3SignerAttribute(signerConfig.mSigningCertificateLineage);
    }

    private static final class V3SignatureSchemeBlock {
        private V3SignatureSchemeBlock() {
        }

        private static final class SignedData {
            public List<Pair<Integer, byte[]>> digests;
            public List<byte[]> certificates;
            public int minSdkVersion;
            public int maxSdkVersion;
            public byte[] additionalAttributes;

            private SignedData() {
            }
        }

        private static final class Signer {
            public byte[] signedData;
            public int minSdkVersion;
            public int maxSdkVersion;
            public List<Pair<Integer, byte[]>> signatures;
            public byte[] publicKey;

            private Signer() {
            }
        }
    }
}

