/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.v2;

import com.android.apksig.ApkVerifier;
import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.apk.ApkUtils;
import com.android.apksig.internal.apk.ApkSigningBlockUtils;
import com.android.apksig.internal.apk.ContentDigestAlgorithm;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.apk.SignatureInfo;
import com.android.apksig.internal.util.ByteBufferUtils;
import com.android.apksig.internal.util.GuaranteedEncodedFormX509Certificate;
import com.android.apksig.internal.util.X509CertificateUtils;
import com.android.apksig.util.DataSource;
import com.android.apksig.util.RunnablesExecutor;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class V2SchemeVerifier {
    private V2SchemeVerifier() {
    }

    public static ApkSigningBlockUtils.Result verify(RunnablesExecutor runnablesExecutor, DataSource dataSource, ApkUtils.ZipSections zipSections, Map<Integer, String> map, Set<Integer> set, int n, int n2) throws IOException, ApkFormatException, NoSuchAlgorithmException, ApkSigningBlockUtils.SignatureNotFoundException {
        ApkSigningBlockUtils.Result result = new ApkSigningBlockUtils.Result(2);
        SignatureInfo signatureInfo = ApkSigningBlockUtils.findSignature(dataSource, zipSections, 1896449818, result);
        DataSource dataSource2 = dataSource.slice(0L, signatureInfo.apkSigningBlockOffset);
        DataSource dataSource3 = dataSource.slice(signatureInfo.centralDirOffset, signatureInfo.eocdOffset - signatureInfo.centralDirOffset);
        ByteBuffer byteBuffer = signatureInfo.eocd;
        V2SchemeVerifier.verify(runnablesExecutor, dataSource2, signatureInfo.signatureBlock, dataSource3, byteBuffer, map, set, n, n2, result);
        return result;
    }

    private static void verify(RunnablesExecutor runnablesExecutor, DataSource dataSource, ByteBuffer byteBuffer, DataSource dataSource2, ByteBuffer byteBuffer2, Map<Integer, String> map, Set<Integer> set, int n, int n2, ApkSigningBlockUtils.Result result) throws IOException, NoSuchAlgorithmException {
        HashSet<ContentDigestAlgorithm> hashSet = new HashSet<ContentDigestAlgorithm>(1);
        V2SchemeVerifier.parseSigners(byteBuffer, hashSet, map, set, n, n2, result);
        if (result.containsErrors()) {
            return;
        }
        ApkSigningBlockUtils.verifyIntegrity(runnablesExecutor, dataSource, dataSource2, byteBuffer2, hashSet, result);
        if (!result.containsErrors()) {
            result.verified = true;
        }
    }

    public static void parseSigners(ByteBuffer byteBuffer, Set<ContentDigestAlgorithm> set, Map<Integer, String> map, Set<Integer> set2, int n, int n2, ApkSigningBlockUtils.Result result) throws NoSuchAlgorithmException {
        CertificateFactory certificateFactory;
        ByteBuffer byteBuffer2;
        try {
            byteBuffer2 = ApkSigningBlockUtils.getLengthPrefixedSlice(byteBuffer);
        }
        catch (ApkFormatException apkFormatException) {
            result.addError(ApkVerifier.Issue.V2_SIG_MALFORMED_SIGNERS, new Object[0]);
            return;
        }
        if (!byteBuffer2.hasRemaining()) {
            result.addError(ApkVerifier.Issue.V2_SIG_NO_SIGNERS, new Object[0]);
            return;
        }
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new RuntimeException("Failed to obtain X.509 CertificateFactory", certificateException);
        }
        int n3 = 0;
        while (byteBuffer2.hasRemaining()) {
            int n4 = n3++;
            ApkSigningBlockUtils.Result.SignerInfo signerInfo = new ApkSigningBlockUtils.Result.SignerInfo();
            signerInfo.index = n4;
            result.signers.add(signerInfo);
            try {
                ByteBuffer byteBuffer3 = ApkSigningBlockUtils.getLengthPrefixedSlice(byteBuffer2);
                V2SchemeVerifier.parseSigner(byteBuffer3, certificateFactory, signerInfo, set, map, set2, n, n2);
            }
            catch (ApkFormatException | BufferUnderflowException exception) {
                signerInfo.addError(ApkVerifier.Issue.V2_SIG_MALFORMED_SIGNER, new Object[0]);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void parseSigner(ByteBuffer byteBuffer, CertificateFactory certificateFactory, ApkSigningBlockUtils.Result.SignerInfo signerInfo, Set<ContentDigestAlgorithm> set, Map<Integer, String> map, Set<Integer> set2, int n, int n2) throws ApkFormatException, NoSuchAlgorithmException {
        Object object;
        int n3;
        Object object2;
        ArrayList<Integer> arrayList;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        ByteBuffer byteBuffer2 = ApkSigningBlockUtils.getLengthPrefixedSlice(byteBuffer);
        byte[] byArray = new byte[byteBuffer2.remaining()];
        byteBuffer2.get(byArray);
        byteBuffer2.flip();
        signerInfo.signedData = byArray;
        ByteBuffer byteBuffer3 = ApkSigningBlockUtils.getLengthPrefixedSlice(byteBuffer);
        byte[] byArray2 = ApkSigningBlockUtils.readLengthPrefixedByteArray(byteBuffer);
        int n4 = 0;
        ArrayList<ApkSigningBlockUtils.SupportedSignature> arrayList2 = new ArrayList<ApkSigningBlockUtils.SupportedSignature>(1);
        while (byteBuffer3.hasRemaining()) {
            ++n4;
            try {
                object8 = ApkSigningBlockUtils.getLengthPrefixedSlice(byteBuffer3);
                int n5 = ((ByteBuffer)object8).getInt();
                object7 = ApkSigningBlockUtils.readLengthPrefixedByteArray((ByteBuffer)object8);
                signerInfo.signatures.add(new ApkSigningBlockUtils.Result.SignerInfo.Signature(n5, (byte[])object7));
                object6 = SignatureAlgorithm.findById(n5);
                if (object6 == null) {
                    signerInfo.addWarning(ApkVerifier.Issue.V2_SIG_UNKNOWN_SIG_ALGORITHM, n5);
                    continue;
                }
                arrayList2.add(new ApkSigningBlockUtils.SupportedSignature((SignatureAlgorithm)((Object)object6), (byte[])object7));
            }
            catch (ApkFormatException | BufferUnderflowException exception) {
                signerInfo.addError(ApkVerifier.Issue.V2_SIG_MALFORMED_SIGNATURE, n4);
                return;
            }
        }
        if (signerInfo.signatures.isEmpty()) {
            signerInfo.addError(ApkVerifier.Issue.V2_SIG_NO_SIGNATURES, new Object[0]);
            return;
        }
        object8 = null;
        try {
            object8 = ApkSigningBlockUtils.getSignaturesToVerify(arrayList2, n, n2);
        }
        catch (ApkSigningBlockUtils.NoSupportedSignaturesException noSupportedSignaturesException) {
            signerInfo.addError(ApkVerifier.Issue.V2_SIG_NO_SUPPORTED_SIGNATURES, noSupportedSignaturesException);
            return;
        }
        Object object9 = object8.iterator();
        while (object9.hasNext()) {
            PublicKey publicKey;
            object7 = (ApkSigningBlockUtils.SupportedSignature)object9.next();
            object6 = ((ApkSigningBlockUtils.SupportedSignature)object7).algorithm;
            String string = ((SignatureAlgorithm)((Object)object6)).getJcaSignatureAlgorithmAndParams().getFirst();
            object5 = ((SignatureAlgorithm)((Object)object6)).getJcaSignatureAlgorithmAndParams().getSecond();
            object4 = ((SignatureAlgorithm)((Object)object6)).getJcaKeyAlgorithm();
            try {
                publicKey = KeyFactory.getInstance((String)object4).generatePublic(new X509EncodedKeySpec(byArray2));
            }
            catch (Exception exception) {
                signerInfo.addError(ApkVerifier.Issue.V2_SIG_MALFORMED_PUBLIC_KEY, exception);
                return;
            }
            try {
                arrayList = Signature.getInstance(string);
                ((Signature)((Object)arrayList)).initVerify(publicKey);
                if (object5 != null) {
                    ((Signature)((Object)arrayList)).setParameter((AlgorithmParameterSpec)object5);
                }
                byteBuffer2.position(0);
                ((Signature)((Object)arrayList)).update(byteBuffer2);
                byte[] byArray3 = ((ApkSigningBlockUtils.SupportedSignature)object7).signature;
                if (!((Signature)((Object)arrayList)).verify(byArray3)) {
                    signerInfo.addError(ApkVerifier.Issue.V2_SIG_DID_NOT_VERIFY, object6);
                    return;
                }
                signerInfo.verifiedSignatures.put((SignatureAlgorithm)((Object)object6), byArray3);
                set.add(((SignatureAlgorithm)((Object)object6)).getContentDigestAlgorithm());
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | SignatureException generalSecurityException) {
                signerInfo.addError(ApkVerifier.Issue.V2_SIG_VERIFY_EXCEPTION, object6, generalSecurityException);
                return;
            }
        }
        byteBuffer2.position(0);
        object9 = ApkSigningBlockUtils.getLengthPrefixedSlice(byteBuffer2);
        object7 = ApkSigningBlockUtils.getLengthPrefixedSlice(byteBuffer2);
        object6 = ApkSigningBlockUtils.getLengthPrefixedSlice(byteBuffer2);
        int n6 = -1;
        while (((Buffer)object7).hasRemaining()) {
            ++n6;
            object5 = ApkSigningBlockUtils.readLengthPrefixedByteArray((ByteBuffer)object7);
            try {
                object4 = X509CertificateUtils.generateCertificate((byte[])object5, certificateFactory);
            }
            catch (CertificateException certificateException) {
                signerInfo.addError(ApkVerifier.Issue.V2_SIG_MALFORMED_CERTIFICATE, n6, n6 + 1, certificateException);
                return;
            }
            object4 = new GuaranteedEncodedFormX509Certificate((X509Certificate)object4, (byte[])object5);
            signerInfo.certs.add(object4);
        }
        if (signerInfo.certs.isEmpty()) {
            signerInfo.addError(ApkVerifier.Issue.V2_SIG_NO_CERTIFICATES, new Object[0]);
            return;
        }
        object5 = (X509Certificate)signerInfo.certs.get(0);
        try {
            object4 = ApkSigningBlockUtils.encodePublicKey(((Certificate)object5).getPublicKey());
        }
        catch (InvalidKeyException invalidKeyException) {
            System.out.println("Caught an exception encoding the public key: " + invalidKeyException);
            invalidKeyException.printStackTrace();
            object4 = ((Certificate)object5).getPublicKey().getEncoded();
        }
        if (!Arrays.equals(byArray2, (byte[])object4)) {
            signerInfo.addError(ApkVerifier.Issue.V2_SIG_PUBLIC_KEY_MISMATCH_BETWEEN_CERTIFICATE_AND_SIGNATURES_RECORD, ApkSigningBlockUtils.toHex((byte[])object4), ApkSigningBlockUtils.toHex(byArray2));
            return;
        }
        int n7 = 0;
        while (((Buffer)object9).hasRemaining()) {
            ++n7;
            try {
                arrayList = ApkSigningBlockUtils.getLengthPrefixedSlice((ByteBuffer)object9);
                int n8 = ((ByteBuffer)((Object)arrayList)).getInt();
                byte[] object10 = ApkSigningBlockUtils.readLengthPrefixedByteArray(arrayList);
                signerInfo.contentDigests.add(new ApkSigningBlockUtils.Result.SignerInfo.ContentDigest(n8, object10));
            }
            catch (ApkFormatException | BufferUnderflowException exception) {
                signerInfo.addError(ApkVerifier.Issue.V2_SIG_MALFORMED_DIGEST, n7);
                return;
            }
        }
        arrayList = new ArrayList<Integer>(signerInfo.signatures.size());
        for (ApkSigningBlockUtils.Result.SignerInfo.Signature signature : signerInfo.signatures) {
            arrayList.add(signature.getAlgorithmId());
        }
        ArrayList arrayList3 = new ArrayList(signerInfo.contentDigests.size());
        for (ApkSigningBlockUtils.Result.SignerInfo.ContentDigest contentDigest : signerInfo.contentDigests) {
            arrayList3.add(contentDigest.getSignatureAlgorithmId());
        }
        if (!arrayList.equals(arrayList3)) {
            signerInfo.addError(ApkVerifier.Issue.V2_SIG_SIG_ALG_MISMATCH_BETWEEN_SIGNATURES_AND_DIGESTS_RECORDS, arrayList, arrayList3);
            return;
        }
        boolean bl = false;
        Set<Integer> set3 = map.keySet();
        HashSet<Integer> hashSet = new HashSet<Integer>(1);
        block25: while (((Buffer)object6).hasRemaining()) {
            void var24_41;
            ++var24_41;
            try {
                object2 = ApkSigningBlockUtils.getLengthPrefixedSlice((ByteBuffer)object6);
                n3 = ((ByteBuffer)object2).getInt();
                object = ByteBufferUtils.toByteArray((ByteBuffer)object2);
                signerInfo.additionalAttributes.add(new ApkSigningBlockUtils.Result.SignerInfo.AdditionalAttribute(n3, (byte[])object));
                switch (n3) {
                    case -1091571699: {
                        int n5 = ByteBuffer.wrap(object).order(ByteOrder.LITTLE_ENDIAN).getInt();
                        if (set3.contains(n5)) {
                            hashSet.add(n5);
                            continue block25;
                        }
                        signerInfo.addWarning(ApkVerifier.Issue.V2_SIG_UNKNOWN_APK_SIG_SCHEME_ID, signerInfo.index, n5);
                        continue block25;
                    }
                }
                signerInfo.addWarning(ApkVerifier.Issue.V2_SIG_UNKNOWN_ADDITIONAL_ATTRIBUTE, n3);
            }
            catch (ApkFormatException | BufferUnderflowException exception) {
                signerInfo.addError(ApkVerifier.Issue.V2_SIG_MALFORMED_ADDITIONAL_ATTRIBUTE, (int)var24_41);
                return;
            }
        }
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            n3 = (Integer)object2.next();
            if (set2.contains(n3)) continue;
            object = map.get(n3);
            signerInfo.addError(ApkVerifier.Issue.V2_SIG_MISSING_APK_SIG_REFERENCED, signerInfo.index, object);
        }
    }
}

