/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.stamp;

import com.android.apksig.ApkVerifier;
import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.apk.ApkUtils;
import com.android.apksig.internal.apk.ApkSigningBlockUtils;
import com.android.apksig.internal.apk.ContentDigestAlgorithm;
import com.android.apksig.internal.apk.SignatureInfo;
import com.android.apksig.internal.apk.stamp.SourceStampVerifier;
import com.android.apksig.internal.util.Pair;
import com.android.apksig.util.DataSource;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public abstract class V1SourceStampVerifier {
    private V1SourceStampVerifier() {
    }

    public static ApkSigningBlockUtils.Result verify(DataSource dataSource, ApkUtils.ZipSections zipSections, byte[] byArray, Map<ContentDigestAlgorithm, byte[]> map, int n, int n2) throws IOException, NoSuchAlgorithmException, ApkSigningBlockUtils.SignatureNotFoundException {
        ApkSigningBlockUtils.Result result = new ApkSigningBlockUtils.Result(0);
        SignatureInfo signatureInfo = ApkSigningBlockUtils.findSignature(dataSource, zipSections, 722016414, result);
        V1SourceStampVerifier.verify(signatureInfo.signatureBlock, byArray, map, n, n2, result);
        return result;
    }

    private static void verify(ByteBuffer byteBuffer, byte[] byArray, Map<ContentDigestAlgorithm, byte[]> map, int n, int n2, ApkSigningBlockUtils.Result result) throws NoSuchAlgorithmException {
        ApkSigningBlockUtils.Result.SignerInfo signerInfo = new ApkSigningBlockUtils.Result.SignerInfo();
        result.signers.add(signerInfo);
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ByteBuffer byteBuffer2 = ApkSigningBlockUtils.getLengthPrefixedSlice(byteBuffer);
            byte[] byArray2 = ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(V1SourceStampVerifier.getApkDigests(map));
            SourceStampVerifier.verifyV1SourceStamp(byteBuffer2, certificateFactory, signerInfo, byArray2, byArray, n, n2);
            result.verified = !result.containsErrors() && !result.containsWarnings();
        }
        catch (CertificateException certificateException) {
            throw new IllegalStateException("Failed to obtain X.509 CertificateFactory", certificateException);
        }
        catch (ApkFormatException | BufferUnderflowException exception) {
            signerInfo.addWarning(ApkVerifier.Issue.SOURCE_STAMP_MALFORMED_SIGNATURE, new Object[0]);
        }
    }

    private static List<Pair<Integer, byte[]>> getApkDigests(Map<ContentDigestAlgorithm, byte[]> map) {
        ArrayList<Pair<Integer, byte[]>> arrayList = new ArrayList<Pair<Integer, byte[]>>();
        for (Map.Entry<ContentDigestAlgorithm, byte[]> entry : map.entrySet()) {
            arrayList.add(Pair.of(entry.getKey().getId(), entry.getValue()));
        }
        Collections.sort(arrayList, Comparator.comparing(Pair::getFirst));
        return arrayList;
    }
}

