/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.apk;

import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.apk.ApkSigningBlockNotFoundException;
import com.android.apksig.apk.ApkUtilsLite;
import com.android.apksig.apk.CodenameMinSdkVersionException;
import com.android.apksig.apk.MinSdkVersionException;
import com.android.apksig.internal.apk.AndroidBinXmlParser;
import com.android.apksig.internal.apk.v1.V1SchemeVerifier;
import com.android.apksig.internal.util.Pair;
import com.android.apksig.internal.zip.CentralDirectoryRecord;
import com.android.apksig.internal.zip.LocalFileRecord;
import com.android.apksig.internal.zip.ZipUtils;
import com.android.apksig.util.DataSource;
import com.android.apksig.zip.ZipFormatException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public abstract class ApkUtils {
    public static final String ANDROID_MANIFEST_ZIP_ENTRY_NAME = "AndroidManifest.xml";
    public static final String SOURCE_STAMP_CERTIFICATE_HASH_ZIP_ENTRY_NAME = "stamp-cert-sha256";
    private static final int MIN_SDK_VERSION_ATTR_ID = 16843276;
    private static final int DEBUGGABLE_ATTR_ID = 0x101000F;
    private static final int TARGET_SANDBOX_VERSION_ATTR_ID = 16844108;
    private static final int TARGET_SDK_VERSION_ATTR_ID = 16843376;
    private static final String USES_SDK_ELEMENT_TAG = "uses-sdk";
    private static final int VERSION_CODE_ATTR_ID = 16843291;
    private static final String MANIFEST_ELEMENT_TAG = "manifest";
    private static final int VERSION_CODE_MAJOR_ATTR_ID = 16844150;

    private ApkUtils() {
    }

    public static ZipSections findZipSections(DataSource dataSource) throws IOException, ZipFormatException {
        com.android.apksig.zip.ZipSections zipSections = ApkUtilsLite.findZipSections(dataSource);
        return new ZipSections(zipSections.getZipCentralDirectoryOffset(), zipSections.getZipCentralDirectorySizeBytes(), zipSections.getZipCentralDirectoryRecordCount(), zipSections.getZipEndOfCentralDirectoryOffset(), zipSections.getZipEndOfCentralDirectory());
    }

    public static void setZipEocdCentralDirectoryOffset(ByteBuffer byteBuffer, long l) {
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        ZipUtils.setZipEocdCentralDirectoryOffset(byteBuffer2, l);
    }

    public static ApkSigningBlock findApkSigningBlock(DataSource dataSource, ZipSections zipSections) throws IOException, ApkSigningBlockNotFoundException {
        ApkUtilsLite.ApkSigningBlock apkSigningBlock = ApkUtilsLite.findApkSigningBlock(dataSource, zipSections);
        return new ApkSigningBlock(apkSigningBlock.getStartOffset(), apkSigningBlock.getContents());
    }

    public static ByteBuffer getAndroidManifest(DataSource dataSource) throws IOException, ApkFormatException {
        ZipSections zipSections;
        try {
            zipSections = ApkUtils.findZipSections(dataSource);
        }
        catch (ZipFormatException zipFormatException) {
            throw new ApkFormatException("Not a valid ZIP archive", zipFormatException);
        }
        List<CentralDirectoryRecord> list = V1SchemeVerifier.parseZipCentralDirectory(dataSource, zipSections);
        CentralDirectoryRecord centralDirectoryRecord = null;
        for (CentralDirectoryRecord centralDirectoryRecord2 : list) {
            if (!ANDROID_MANIFEST_ZIP_ENTRY_NAME.equals(centralDirectoryRecord2.getName())) continue;
            centralDirectoryRecord = centralDirectoryRecord2;
            break;
        }
        if (centralDirectoryRecord == null) {
            throw new ApkFormatException("Missing AndroidManifest.xml");
        }
        DataSource dataSource2 = dataSource.slice(0L, zipSections.getZipCentralDirectoryOffset());
        try {
            return ByteBuffer.wrap(LocalFileRecord.getUncompressedData(dataSource2, centralDirectoryRecord, dataSource2.size()));
        }
        catch (ZipFormatException zipFormatException) {
            throw new ApkFormatException("Failed to read AndroidManifest.xml", zipFormatException);
        }
    }

    public static int getMinSdkVersionFromBinaryAndroidManifest(ByteBuffer byteBuffer) throws MinSdkVersionException {
        try {
            int n = 1;
            AndroidBinXmlParser androidBinXmlParser = new AndroidBinXmlParser(byteBuffer);
            int n2 = androidBinXmlParser.getEventType();
            while (n2 != 2) {
                if (n2 == 3 && androidBinXmlParser.getDepth() == 2 && USES_SDK_ELEMENT_TAG.equals(androidBinXmlParser.getName()) && androidBinXmlParser.getNamespace().isEmpty()) {
                    int n3 = 1;
                    block7: for (int i = 0; i < androidBinXmlParser.getAttributeCount(); ++i) {
                        if (androidBinXmlParser.getAttributeNameResourceId(i) != 16843276) continue;
                        int n4 = androidBinXmlParser.getAttributeValueType(i);
                        switch (n4) {
                            case 2: {
                                n3 = androidBinXmlParser.getAttributeIntValue(i);
                                break block7;
                            }
                            case 1: {
                                n3 = ApkUtils.getMinSdkVersionForCodename(androidBinXmlParser.getAttributeStringValue(i));
                                break block7;
                            }
                            default: {
                                throw new MinSdkVersionException("Unable to determine APK's minimum supported Android: unsupported value type in AndroidManifest.xml's minSdkVersion. Only integer values supported.");
                            }
                        }
                    }
                    n = Math.max(n, n3);
                }
                n2 = androidBinXmlParser.next();
            }
            return n;
        }
        catch (AndroidBinXmlParser.XmlParserException xmlParserException) {
            throw new MinSdkVersionException("Unable to determine APK's minimum supported Android platform version: malformed binary resource: AndroidManifest.xml", xmlParserException);
        }
    }

    static int getMinSdkVersionForCodename(String string) throws CodenameMinSdkVersionException {
        char c;
        char c2 = c = string.isEmpty() ? (char)' ' : (char)string.charAt(0);
        if (c >= 'A' && c <= 'Z') {
            Pair[] pairArray = CodenamesLazyInitializer.SORTED_CODENAMES_FIRST_CHAR_TO_API_LEVEL;
            int n = Arrays.binarySearch(pairArray, Pair.of(Character.valueOf(c), null), CodenamesLazyInitializer.CODENAME_FIRST_CHAR_COMPARATOR);
            if (n >= 0) {
                return (Integer)pairArray[n].getSecond();
            }
            int n2 = -1 - n;
            if (n2 == 0) {
                return 1;
            }
            Pair pair = pairArray[n2 - 1];
            char c3 = ((Character)pair.getFirst()).charValue();
            int n3 = (Integer)pair.getSecond();
            return n3 + (c - c3);
        }
        throw new CodenameMinSdkVersionException("Unable to determine APK's minimum supported Android platform version : Unsupported codename in AndroidManifest.xml's minSdkVersion: \"" + string + "\"", string);
    }

    public static boolean getDebuggableFromBinaryAndroidManifest(ByteBuffer byteBuffer) throws ApkFormatException {
        try {
            AndroidBinXmlParser androidBinXmlParser = new AndroidBinXmlParser(byteBuffer);
            int n = androidBinXmlParser.getEventType();
            while (n != 2) {
                if (n == 3 && androidBinXmlParser.getDepth() == 2 && "application".equals(androidBinXmlParser.getName()) && androidBinXmlParser.getNamespace().isEmpty()) {
                    for (int i = 0; i < androidBinXmlParser.getAttributeCount(); ++i) {
                        if (androidBinXmlParser.getAttributeNameResourceId(i) != 0x101000F) continue;
                        int n2 = androidBinXmlParser.getAttributeValueType(i);
                        switch (n2) {
                            case 1: 
                            case 2: 
                            case 4: {
                                String string = androidBinXmlParser.getAttributeStringValue(i);
                                return "true".equals(string) || "TRUE".equals(string) || "1".equals(string);
                            }
                            case 3: {
                                throw new ApkFormatException("Unable to determine whether APK is debuggable: AndroidManifest.xml's android:debuggable attribute references a resource. References are not supported for security reasons. Only constant boolean, string and int values are supported.");
                            }
                        }
                        throw new ApkFormatException("Unable to determine whether APK is debuggable: AndroidManifest.xml's android:debuggable attribute uses unsupported value type. Only boolean, string and int values are supported.");
                    }
                    return false;
                }
                n = androidBinXmlParser.next();
            }
            return false;
        }
        catch (AndroidBinXmlParser.XmlParserException xmlParserException) {
            throw new ApkFormatException("Unable to determine whether APK is debuggable: malformed binary resource: AndroidManifest.xml", xmlParserException);
        }
    }

    public static String getPackageNameFromBinaryAndroidManifest(ByteBuffer byteBuffer) throws ApkFormatException {
        try {
            AndroidBinXmlParser androidBinXmlParser = new AndroidBinXmlParser(byteBuffer);
            int n = androidBinXmlParser.getEventType();
            while (n != 2) {
                if (n == 3 && androidBinXmlParser.getDepth() == 1 && MANIFEST_ELEMENT_TAG.equals(androidBinXmlParser.getName()) && androidBinXmlParser.getNamespace().isEmpty()) {
                    for (int i = 0; i < androidBinXmlParser.getAttributeCount(); ++i) {
                        if (!"package".equals(androidBinXmlParser.getAttributeName(i)) || !androidBinXmlParser.getNamespace().isEmpty()) continue;
                        return androidBinXmlParser.getAttributeStringValue(i);
                    }
                    return null;
                }
                n = androidBinXmlParser.next();
            }
            return null;
        }
        catch (AndroidBinXmlParser.XmlParserException xmlParserException) {
            throw new ApkFormatException("Unable to determine APK package name: malformed binary resource: AndroidManifest.xml", xmlParserException);
        }
    }

    public static int getTargetSandboxVersionFromBinaryAndroidManifest(ByteBuffer byteBuffer) {
        try {
            return ApkUtils.getAttributeValueFromBinaryAndroidManifest(byteBuffer, MANIFEST_ELEMENT_TAG, 16844108);
        }
        catch (ApkFormatException apkFormatException) {
            return 1;
        }
    }

    public static int getTargetSdkVersionFromBinaryAndroidManifest(ByteBuffer byteBuffer) {
        int n = 1;
        try {
            return ApkUtils.getAttributeValueFromBinaryAndroidManifest(byteBuffer, USES_SDK_ELEMENT_TAG, 16843376);
        }
        catch (ApkFormatException apkFormatException) {
            byteBuffer.rewind();
            try {
                n = ApkUtils.getMinSdkVersionFromBinaryAndroidManifest(byteBuffer);
            }
            catch (ApkFormatException apkFormatException2) {
                // empty catch block
            }
            return n;
        }
    }

    public static int getVersionCodeFromBinaryAndroidManifest(ByteBuffer byteBuffer) throws ApkFormatException {
        return ApkUtils.getAttributeValueFromBinaryAndroidManifest(byteBuffer, MANIFEST_ELEMENT_TAG, 16843291);
    }

    public static long getLongVersionCodeFromBinaryAndroidManifest(ByteBuffer byteBuffer) throws ApkFormatException {
        int n = ApkUtils.getVersionCodeFromBinaryAndroidManifest(byteBuffer);
        long l = 0L;
        try {
            byteBuffer.rewind();
            l = ApkUtils.getAttributeValueFromBinaryAndroidManifest(byteBuffer, MANIFEST_ELEMENT_TAG, 16844150);
        }
        catch (ApkFormatException apkFormatException) {
            // empty catch block
        }
        return l << 32 | (long)n;
    }

    private static int getAttributeValueFromBinaryAndroidManifest(ByteBuffer byteBuffer, String string, int n) throws ApkFormatException {
        if (string == null) {
            throw new NullPointerException("elementName cannot be null");
        }
        try {
            AndroidBinXmlParser androidBinXmlParser = new AndroidBinXmlParser(byteBuffer);
            int n2 = androidBinXmlParser.getEventType();
            while (n2 != 2) {
                if (n2 == 3 && string.equals(androidBinXmlParser.getName())) {
                    for (int i = 0; i < androidBinXmlParser.getAttributeCount(); ++i) {
                        if (androidBinXmlParser.getAttributeNameResourceId(i) != n) continue;
                        int n3 = androidBinXmlParser.getAttributeValueType(i);
                        switch (n3) {
                            case 1: 
                            case 2: {
                                return androidBinXmlParser.getAttributeIntValue(i);
                            }
                        }
                        throw new ApkFormatException("Unsupported value type, " + n3 + ", for attribute " + String.format("0x%08X", n) + " under element " + string);
                    }
                }
                n2 = androidBinXmlParser.next();
            }
            throw new ApkFormatException("Failed to determine APK's " + string + " attribute " + String.format("0x%08X", n) + " value");
        }
        catch (AndroidBinXmlParser.XmlParserException xmlParserException) {
            throw new ApkFormatException("Unable to determine value for attribute " + String.format("0x%08X", n) + " under element " + string + "; malformed binary resource: " + ANDROID_MANIFEST_ZIP_ENTRY_NAME, xmlParserException);
        }
    }

    public static byte[] computeSha256DigestBytes(byte[] byArray) {
        return ApkUtilsLite.computeSha256DigestBytes(byArray);
    }

    private static class CodenamesLazyInitializer {
        private static final Pair<Character, Integer>[] SORTED_CODENAMES_FIRST_CHAR_TO_API_LEVEL = new Pair[]{Pair.of(Character.valueOf('C'), 2), Pair.of(Character.valueOf('D'), 3), Pair.of(Character.valueOf('E'), 4), Pair.of(Character.valueOf('F'), 7), Pair.of(Character.valueOf('G'), 8), Pair.of(Character.valueOf('H'), 10), Pair.of(Character.valueOf('I'), 13), Pair.of(Character.valueOf('J'), 15), Pair.of(Character.valueOf('K'), 18), Pair.of(Character.valueOf('L'), 20), Pair.of(Character.valueOf('M'), 22), Pair.of(Character.valueOf('N'), 23), Pair.of(Character.valueOf('O'), 25)};
        private static final Comparator<Pair<Character, Integer>> CODENAME_FIRST_CHAR_COMPARATOR = new ByFirstComparator();

        private CodenamesLazyInitializer() {
        }

        private static class ByFirstComparator
        implements Comparator<Pair<Character, Integer>> {
            private ByFirstComparator() {
            }

            @Override
            public int compare(Pair<Character, Integer> pair, Pair<Character, Integer> pair2) {
                char c = pair.getFirst().charValue();
                char c2 = pair2.getFirst().charValue();
                return c - c2;
            }
        }
    }

    public static class ApkSigningBlock
    extends ApkUtilsLite.ApkSigningBlock {
        public ApkSigningBlock(long l, DataSource dataSource) {
            super(l, dataSource);
        }
    }

    public static class ZipSections
    extends com.android.apksig.zip.ZipSections {
        public ZipSections(long l, long l2, int n, long l3, ByteBuffer byteBuffer) {
            super(l, l2, n, l3, byteBuffer);
        }
    }
}

