/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Hints {
    public static final String PIN_HINT_ASSET_ZIP_ENTRY_NAME = "assets/com.android.hints.pins.txt";
    public static final String PIN_BYTE_RANGE_ZIP_ENTRY_NAME = "pinlist.meta";

    private static int clampToInt(long l) {
        return (int)Math.max(0L, Math.min(l, Integer.MAX_VALUE));
    }

    public static byte[] encodeByteRangeList(List<ByteRange> list) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(list.size() * 8);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            for (ByteRange byteRange : list) {
                dataOutputStream.writeInt(Hints.clampToInt(byteRange.start));
                dataOutputStream.writeInt(Hints.clampToInt(byteRange.end - byteRange.start));
            }
        }
        catch (IOException iOException) {
            throw new AssertionError("impossible", iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static ArrayList<PatternWithRange> parsePinPatterns(byte[] byArray) {
        ArrayList<PatternWithRange> arrayList = new ArrayList<PatternWithRange>();
        try {
            for (String string : new String(byArray, "UTF-8").split("\n")) {
                String string2 = string.replaceFirst("#.*", "");
                String[] stringArray = string2.split(" ");
                if (stringArray.length == 1) {
                    arrayList.add(new PatternWithRange(stringArray[0]));
                    continue;
                }
                if (stringArray.length == 3) {
                    long l = Long.parseLong(stringArray[1]);
                    long l2 = Long.parseLong(stringArray[2]);
                    arrayList.add(new PatternWithRange(stringArray[0], l, l2 - l));
                    continue;
                }
                throw new AssertionError((Object)("bad pin pattern line " + string2));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 must be supported", unsupportedEncodingException);
        }
        return arrayList;
    }

    public static final class PatternWithRange {
        final Pattern pattern;
        final long offset;
        final long size;

        public PatternWithRange(String string) {
            this.pattern = Pattern.compile(string);
            this.offset = 0L;
            this.size = Long.MAX_VALUE;
        }

        public PatternWithRange(String string, long l, long l2) {
            this.pattern = Pattern.compile(string);
            this.offset = l;
            this.size = l2;
        }

        public Matcher matcher(CharSequence charSequence) {
            return this.pattern.matcher(charSequence);
        }

        public ByteRange ClampToAbsoluteByteRange(ByteRange byteRange) {
            if (byteRange.end - byteRange.start < this.offset) {
                return null;
            }
            long l = byteRange.start + this.offset;
            long l2 = Math.min(byteRange.end - l, this.size);
            return new ByteRange(l, l + l2);
        }
    }

    public static final class ByteRange {
        final long start;
        final long end;

        public ByteRange(long l, long l2) {
            this.start = l;
            this.end = l2;
        }
    }
}

