/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig;

import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.util.DataSink;
import com.android.apksig.util.DataSource;
import com.android.apksig.util.RunnablesExecutor;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.List;
import java.util.Set;

public interface ApkSignerEngine
extends Closeable {
    default public void setExecutor(RunnablesExecutor runnablesExecutor) {
        throw new UnsupportedOperationException("setExecutor method is not implemented");
    }

    default public Set<String> initWith(byte[] byArray, Set<String> set) {
        throw new UnsupportedOperationException("initWith method is not implemented");
    }

    public void inputApkSigningBlock(DataSource var1) throws IOException, ApkFormatException, IllegalStateException;

    public InputJarEntryInstructions inputJarEntry(String var1) throws IllegalStateException;

    public InspectJarEntryRequest outputJarEntry(String var1) throws IllegalStateException;

    public InputJarEntryInstructions.OutputPolicy inputJarEntryRemoved(String var1) throws IllegalStateException;

    public void outputJarEntryRemoved(String var1) throws IllegalStateException;

    public OutputJarSignatureRequest outputJarEntries() throws ApkFormatException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, IllegalStateException;

    @Deprecated
    public OutputApkSigningBlockRequest outputZipSections(DataSource var1, DataSource var2, DataSource var3) throws IOException, ApkFormatException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, IllegalStateException;

    public OutputApkSigningBlockRequest2 outputZipSections2(DataSource var1, DataSource var2, DataSource var3) throws IOException, ApkFormatException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, IllegalStateException;

    public void outputDone() throws IllegalStateException;

    public void signV4(DataSource var1, File var2, boolean var3) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException, IOException;

    default public boolean isEligibleForSourceStamp() {
        return false;
    }

    default public byte[] generateSourceStampCertificateDigest() throws SignatureException {
        return new byte[0];
    }

    @Override
    public void close();

    public static interface OutputApkSigningBlockRequest2 {
        public byte[] getApkSigningBlock();

        public void done();

        public int getPaddingSizeBeforeApkSigningBlock();
    }

    @Deprecated
    public static interface OutputApkSigningBlockRequest {
        public byte[] getApkSigningBlock();

        public void done();
    }

    public static interface OutputJarSignatureRequest {
        public List<JarEntry> getAdditionalJarEntries();

        public void done();

        public static class JarEntry {
            private final String mName;
            private final byte[] mData;

            public JarEntry(String string, byte[] byArray) {
                this.mName = string;
                this.mData = (byte[])byArray.clone();
            }

            public String getName() {
                return this.mName;
            }

            public byte[] getData() {
                return (byte[])this.mData.clone();
            }
        }
    }

    public static interface InspectJarEntryRequest {
        public DataSink getDataSink();

        public void done();

        public String getEntryName();
    }

    public static class InputJarEntryInstructions {
        private final OutputPolicy mOutputPolicy;
        private final InspectJarEntryRequest mInspectJarEntryRequest;

        public InputJarEntryInstructions(OutputPolicy outputPolicy) {
            this(outputPolicy, null);
        }

        public InputJarEntryInstructions(OutputPolicy outputPolicy, InspectJarEntryRequest inspectJarEntryRequest) {
            this.mOutputPolicy = outputPolicy;
            this.mInspectJarEntryRequest = inspectJarEntryRequest;
        }

        public OutputPolicy getOutputPolicy() {
            return this.mOutputPolicy;
        }

        public InspectJarEntryRequest getInspectJarEntryRequest() {
            return this.mInspectJarEntryRequest;
        }

        public static enum OutputPolicy {
            SKIP,
            OUTPUT,
            OUTPUT_BY_ENGINE;

        }
    }
}

